/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.websphere.ssl.SSLConfigurationNotAvailableException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class JSSEHelper {
    private static final TraceComponent tc = Tr.register(JSSEHelper.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static final WebSphereRuntimePermission GET_SSLCONFIG = new WebSphereRuntimePermission("getSSLConfig");
    private static final WebSphereRuntimePermission SET_SSLCONFIG = new WebSphereRuntimePermission("setSSLConfig");
    public static final String DIRECTION_INBOUND = "inbound";
    public static final String DIRECTION_OUTBOUND = "outbound";
    public static final String DIRECTION_UNKNOWN = "unknown";
    public static final String ENDPOINT_IIOP = "IIOP";
    public static final String ENDPOINT_HTTP = "HTTP";
    public static final String ENDPOINT_SIP = "SIP";
    public static final String ENDPOINT_JMS = "JMS";
    public static final String ENDPOINT_BUS_CLIENT = "BUS_CLIENT";
    public static final String ENDPOINT_BUS_TO_WEBSPHERE_MQ = "BUS_TO_WEBSPHERE_MQ";
    public static final String ENDPOINT_BUS_TO_BUS = "BUS_TO_BUS";
    public static final String ENDPOINT_CLIENT_TO_WEBSPHERE_MQ = "CLIENT_TO_WEBSPHERE_MQ";
    public static final String ENDPOINT_LDAP = "LDAP";
    public static final String ENDPOINT_ADMIN_SOAP = "ADMIN_SOAP";
    public static final String ENDPOINT_ADMIN_IPC = "ADMIN_IPC";
    public static final String CONNECTION_INFO_DIRECTION = "com.ibm.ssl.direction";
    public static final String CONNECTION_INFO_ENDPOINT_NAME = "com.ibm.ssl.endPointName";
    public static final String CONNECTION_INFO_REMOTE_HOST = "com.ibm.ssl.remoteHost";
    public static final String CONNECTION_INFO_REMOTE_PORT = "com.ibm.ssl.remotePort";
    public static final String CONNECTION_INFO_CERT_MAPPING_HOST = "com.ibm.ssl.certMappingHost";
    public static final String CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND = "com.ibm.ssl.isWebContainerInbound";

    public static JSSEHelper getInstance() {
        return JSSESingleton.instance;
    }

    public void setSSLPropertiesOnThread(Properties props) {
        SSLConfig config;
        String alias;
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String debug = "Clearing thread properties.";
            if (props != null && null == (debug = props.getProperty("com.ibm.ssl.alias"))) {
                debug = props.toString();
            }
            Tr.entry((TraceComponent)tc, (String)"setSSLPropertiesOnThread", (Object[])new Object[]{debug});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + SET_SSLCONFIG.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)SET_SSLCONFIG);
        }
        if (props != null && (alias = props.getProperty("com.ibm.ssl.alias")) != null && (config = SSLConfigManager.getInstance().getSSLConfig(alias)) == null) {
            config = new SSLConfig(props);
            try {
                SSLConfigManager.getInstance().addSSLConfigToMap(alias, config);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"The following exception occurred in setSSLPropertiesOnThread().", (Object)new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"setSSLPropertiesOnThread", (Object)this);
            }
        }
        ThreadManager.getInstance().setPropertiesOnThread(props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSSLPropertiesOnThread");
        }
    }

    public Properties getSSLPropertiesOnThread() {
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLPropertiesOnThread", (Object[])new Object[0]);
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_SSLCONFIG.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)GET_SSLCONFIG);
        }
        Properties props = ThreadManager.getInstance().getPropertiesOnThread();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String debug = "Thread properties are NULL.";
            if (props != null && null == (debug = props.getProperty("com.ibm.ssl.alias"))) {
                debug = props.toString();
            }
            Tr.exit((TraceComponent)tc, (String)"getSSLPropertiesOnThread", (Object)new Object[]{debug});
        }
        return props;
    }

    public Properties getProperties(String sslAliasName) throws SSLException {
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProperties", (Object[])new Object[]{sslAliasName});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_SSLCONFIG.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)GET_SSLCONFIG);
        }
        try {
            Properties directSelectionProperties;
            if (sslAliasName != null && sslAliasName.length() > 0 && (directSelectionProperties = SSLConfigManager.getInstance().getProperties(sslAliasName)) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getProperties -> direct");
                }
                return directSelectionProperties;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getProperties", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getProperties().", (Object)new Object[]{e});
            }
            throw JSSEHelper.asSSLException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProperties -> null");
        }
        return null;
    }

    public SSLContext getSSLContext(Map<String, Object> connectionInfo, Properties props) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLContext", (Object[])new Object[]{connectionInfo});
        }
        if (props != null) {
            SSLConfig newConfig = new SSLConfig(props);
            String contextProvider = props.getProperty("com.ibm.ssl.contextProvider");
            SSLContext context = null;
            try {
                context = JSSEProviderFactory.getInstance(contextProvider).getSSLContext(connectionInfo, newConfig);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSSLContext", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"The following exception occurred getting the SSLContext.", (Object)new Object[]{e});
                }
                throw JSSEHelper.asSSLException(e);
            }
            if (context == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The SSLContext is null.  Throwing exception.", (Object[])new Object[0]);
                }
                throw new SSLException("The SSLContext returned is null.  Validate the Properties passed in.");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSSLContext");
            }
            return context;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SSL client config properties are missing. The property 'com.ibm.SSL.ConfigURL' may not be set properly.", (Object[])new Object[0]);
        }
        String message = TraceNLSHelper.getInstance().getString("ssl.no.properties.error.CWPKI0315E", "SSL configuration properites are null. Could be a problem parsing the SSL client configuraton.");
        throw new SSLException(message);
    }

    public URLStreamHandler getURLStreamHandler(Properties props) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getURLStreamHandler", (Object[])new Object[0]);
        }
        try {
            SSLConfig newConfig = new SSLConfig(props);
            String contextProvider = newConfig.getProperty("com.ibm.ssl.contextProvider");
            URLStreamHandler rc = JSSEProviderFactory.getInstance(contextProvider).getURLStreamHandler(newConfig);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getURLStreamHandler: " + rc));
            }
            return rc;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getURLStreamHandler", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred getting the SSLContext.", (Object)new Object[]{e});
            }
            throw JSSEHelper.asSSLException(e);
        }
    }

    public SSLServerSocketFactory getSSLServerSocketFactory(Properties props) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLServerSocketFactory", (Object[])new Object[0]);
        }
        try {
            SSLConfig newConfig = new SSLConfig(props);
            String contextProvider = newConfig.getProperty("com.ibm.ssl.contextProvider");
            SSLServerSocketFactory rc = JSSEProviderFactory.getInstance(contextProvider).getSSLServerSocketFactory(newConfig);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getSSLServerSocketFactory: " + rc));
            }
            return rc;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSSLServerSocketFactory", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getSSLServerSocketFactory().", (Object)new Object[]{e});
            }
            throw JSSEHelper.asSSLException(e);
        }
    }

    public SSLSocketFactory getSSLSocketFactory(Map<String, Object> connectionInfo, Properties props) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLSocketFactory", (Object[])new Object[0]);
        }
        try {
            SSLConfig newConfig = null;
            String contextProvider = null;
            if (props != null && !props.isEmpty()) {
                newConfig = new SSLConfig(props);
                contextProvider = newConfig.getProperty("com.ibm.ssl.contextProvider");
            } else if (connectionInfo == null || connectionInfo.isEmpty()) {
                connectionInfo = new HashMap<String, Object>();
                connectionInfo.put(CONNECTION_INFO_DIRECTION, DIRECTION_OUTBOUND);
                if (newConfig == null) {
                    Properties sslProps = this.getProperties(null, connectionInfo, null, true);
                    newConfig = new SSLConfig(sslProps);
                    contextProvider = sslProps.getProperty("com.ibm.ssl.contextProvider");
                }
            }
            SSLSocketFactory rc = JSSEProviderFactory.getInstance(contextProvider).getSSLSocketFactory(connectionInfo, newConfig);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getSSLSocketFactory: " + rc));
            }
            return rc;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSSLSocketFactory", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getSSLSocketFactory().", (Object)new Object[]{e});
            }
            throw JSSEHelper.asSSLException(e);
        }
    }

    public SSLContext getSSLContext(String sslAliasName, Map<String, Object> connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        return this.getSSLContext(sslAliasName, connectionInfo, listener, true);
    }

    public SSLContext getSSLContext(String sslAliasName, Map<String, Object> connectionInfo, SSLConfigChangeListener listener, boolean tryDefault) throws SSLException, SSLConfigurationNotAvailableException {
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLContext", (Object[])new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_SSLCONFIG.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)GET_SSLCONFIG);
        }
        try {
            SSLConfig props = (SSLConfig)this.getProperties(sslAliasName, connectionInfo, listener, tryDefault);
            if (props != null) {
                String contextProvider = props.getProperty("com.ibm.ssl.contextProvider");
                SSLContext context = JSSEProviderFactory.getInstance(contextProvider).getSSLContext(connectionInfo, props);
                if (context != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getSSLContext");
                    }
                    return context;
                }
                throw new SSLException("SSLContext could not be created from specified SSL properties.");
            }
            if (tryDefault) {
                throw new SSLException("SSLContext could not be created due to null SSL properties.");
            }
            throw new SSLConfigurationNotAvailableException("SSLContext could not be created for alias '" + sslAliasName + "', the configuration is not present.");
        }
        catch (SSLConfigurationNotAvailableException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSSLContext (2)", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getSSLContext().", (Object)new Object[]{e});
            }
            throw JSSEHelper.asSSLException(e);
        }
    }

    public URLStreamHandler getURLStreamHandler(String sslAliasName, Map<String, Object> connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getURLStreamHandler", (Object[])new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_SSLCONFIG.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)GET_SSLCONFIG);
        }
        URLStreamHandler urlStreamHandler = null;
        try {
            Properties sslProperties = this.getProperties(sslAliasName, connectionInfo, listener);
            String contextProvider = null;
            if (sslProperties != null) {
                contextProvider = sslProperties.getProperty("com.ibm.ssl.contextProvider");
            }
            urlStreamHandler = JSSEProviderFactory.getInstance(contextProvider).getURLStreamHandler((SSLConfig)sslProperties);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getURLStreamHandler (2)", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getURLStreamHandler().", (Object)new Object[]{e});
            }
            throw JSSEHelper.asSSLException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getURLStreamHandler");
        }
        return urlStreamHandler;
    }

    public SSLSocketFactory getSSLSocketFactory(String sslAliasName, Map<String, Object> connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLSocketFactory", (Object[])new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_SSLCONFIG.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)GET_SSLCONFIG);
        }
        SSLSocketFactory sslSocketFactory = null;
        if (sslAliasName == null && (connectionInfo == null || connectionInfo.isEmpty())) {
            connectionInfo = new HashMap<String, Object>();
            connectionInfo.put(CONNECTION_INFO_DIRECTION, DIRECTION_OUTBOUND);
        }
        try {
            SSLConfig sslProperties = (SSLConfig)this.getProperties(sslAliasName, connectionInfo, listener);
            String contextProvider = sslProperties.getProperty("com.ibm.ssl.contextProvider");
            sslSocketFactory = JSSEProviderFactory.getInstance(contextProvider).getSSLSocketFactory(connectionInfo, sslProperties);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSSLSocketFactory (2)", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getSSLSocketFactory().", (Object)new Object[]{e});
            }
            throw JSSEHelper.asSSLException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLSocketFactory");
        }
        return sslSocketFactory;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory(String sslAliasName, Map<String, Object> connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLServerSocketFactory", (Object[])new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_SSLCONFIG.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)GET_SSLCONFIG);
        }
        SSLServerSocketFactory sslServerSocketFactory = null;
        try {
            SSLConfig sslProperties = (SSLConfig)this.getProperties(sslAliasName, connectionInfo, listener);
            String contextProvider = sslProperties.getProperty("com.ibm.ssl.contextProvider");
            sslServerSocketFactory = JSSEProviderFactory.getInstance(contextProvider).getSSLServerSocketFactory(sslProperties);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSSLServerSocketFactory (2)", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getSSLServerSocketFactory().", (Object)new Object[]{e});
            }
            throw JSSEHelper.asSSLException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLServerSocketFactory");
        }
        return sslServerSocketFactory;
    }

    public Properties getProperties(String sslAliasName, Map<String, Object> connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        return this.getProperties(sslAliasName, connectionInfo, listener, true);
    }

    public Properties getProperties(String sslAliasName, Map<String, Object> connectionInfo, SSLConfigChangeListener listener, boolean tryDefault) throws SSLException {
        String direction;
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProperties", (Object[])new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_SSLCONFIG.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)GET_SSLCONFIG);
        }
        boolean isOutbound = true;
        if (SSLConfigManager.getInstance().isTransportSecurityEnabled() && connectionInfo != null && (direction = (String)connectionInfo.get(CONNECTION_INFO_DIRECTION)) != null && direction.equals(DIRECTION_INBOUND)) {
            isOutbound = false;
        }
        try {
            SSLConfig dynamicSelectionConfig;
            Properties programmaticProperties = this.getSSLPropertiesOnThread();
            if (programmaticProperties != null) {
                SSLConfig programmaticConfig = new SSLConfig(programmaticProperties);
                if (listener != null) {
                    String alias = programmaticConfig.getProperty("com.ibm.ssl.alias");
                    if (alias == null) {
                        alias = sslAliasName;
                    }
                    this.registerEvent(listener, alias, programmaticConfig, "thread", connectionInfo);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getProperties -> programmatic");
                }
                return programmaticConfig;
            }
            if (sslAliasName != null && sslAliasName.length() > 0) {
                String origAliasName;
                Properties directSelectionProperties = SSLConfigManager.getInstance().getProperties(sslAliasName);
                if (directSelectionProperties == null && (origAliasName = SSLConfigManager.getInstance().getPossibleActualID(sslAliasName)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("could not find properties with " + sslAliasName + " trying properties with " + origAliasName), (Object[])new Object[0]);
                    }
                    directSelectionProperties = SSLConfigManager.getInstance().getProperties(origAliasName);
                }
                if (directSelectionProperties != null) {
                    directSelectionProperties = SSLConfigManager.getInstance().determineIfCSIv2SettingsApply(directSelectionProperties, connectionInfo);
                    if (listener != null) {
                        this.registerEvent(listener, sslAliasName, directSelectionProperties, "direct", connectionInfo);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getProperties -> direct");
                    }
                    return directSelectionProperties;
                }
            }
            if (SSLConfigManager.getInstance().isTransportSecurityEnabled() && isOutbound && (dynamicSelectionConfig = (SSLConfig)SSLConfigManager.getInstance().getPropertiesFromDynamicSelectionInfo(connectionInfo)) != null) {
                if (listener != null) {
                    String alias = dynamicSelectionConfig.getProperty("com.ibm.ssl.alias");
                    if (alias == null) {
                        alias = sslAliasName;
                    }
                    this.registerEvent(listener, alias, dynamicSelectionConfig, "dynamic", connectionInfo);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getProperties -> dynamic");
                }
                return dynamicSelectionConfig;
            }
            if (tryDefault) {
                SSLConfig props;
                if (SSLConfigManager.getInstance().isTransportSecurityEnabled() && isOutbound && (props = SSLConfigManager.getInstance().getOutboundDefaultSSLConfig()) != null && !props.isEmpty()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getProperties -> outbound default");
                    }
                    return props;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getProperties -> default");
                }
                return SSLConfigManager.getInstance().getDefaultSSLConfig();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getProperties -> null");
            }
            return null;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getProperties (2)", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getProperties().", (Object)new Object[]{e});
            }
            throw JSSEHelper.asSSLException(e);
        }
    }

    private void registerEvent(SSLConfigChangeListener listener, String alias, Properties config, String selection, Map<String, Object> connInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerEvent", (Object[])new Object[]{listener, alias, selection});
        }
        if (listener != null) {
            SSLConfigChangeEvent event = new SSLConfigChangeEvent(alias, config, selection, connInfo);
            SSLConfigManager.getInstance().registerSSLConfigChangeListener(listener, event);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerEvent");
        }
    }

    public void registerSSLConfigChangeListener(String sslAliasName, Map<String, Object> connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerSSLConfigChangeListener", (Object[])new Object[]{sslAliasName, connectionInfo, listener});
        }
        this.getProperties(sslAliasName, connectionInfo, listener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerSSLConfigChangeListener");
        }
    }

    public void deregisterSSLConfigChangeListener(SSLConfigChangeListener listener) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deregisterSSLConfigChangeListener", (Object[])new Object[]{listener});
        }
        SSLConfigManager.getInstance().deregisterSSLConfigChangeListener(listener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deregisterSSLConfigChangeListener");
        }
    }

    public boolean doesSSLConfigExist(String sslAliasName) {
        boolean exists;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doesSSLConfigExist", (Object[])new Object[]{sslAliasName});
        }
        if (sslAliasName == null) {
            throw new IllegalArgumentException("sslAliasName is null.");
        }
        boolean bl = exists = null != SSLConfigManager.getInstance().getProperties(sslAliasName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("doesSSLConfigExist -> " + exists));
        }
        return exists;
    }

    public void reinitializeClientDefaultSSLProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reinitializeClientDefaultSSLProperties", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reinitializeClientDefaultSSLProperties");
        }
    }

    public void validateSSLProperties(Properties props) throws SSLException {
        SSLConfig testConfig = new SSLConfig(props);
        try {
            testConfig.validateSSLConfig();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"validateSSLProperties", (Object)this);
            throw JSSEHelper.asSSLException(e);
        }
    }

    public Map<String, Object> getInboundConnectionInfo() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInboundConnectionInfo", (Object[])new Object[0]);
        }
        Map<String, Object> inboundConnectionInfo = ThreadManager.getInstance().getInboundConnectionInfo();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInboundConnectionInfo", inboundConnectionInfo);
        }
        return inboundConnectionInfo;
    }

    public void setInboundConnectionInfo(Map<String, Object> connectionInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInboundConnectionInfo", (Object[])new Object[]{connectionInfo});
        }
        ThreadManager.getInstance().setInboundConnectionInfo(connectionInfo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInboundConnectionInfo");
        }
    }

    public Map<String, Object> getOutboundConnectionInfo() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutboundConnectionInfo", (Object[])new Object[0]);
        }
        Map<String, Object> outboundConnectionInfo = ThreadManager.getInstance().getOutboundConnectionInfo();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutboundConnectionInfo", outboundConnectionInfo);
        }
        return outboundConnectionInfo;
    }

    public void setOutboundConnectionInfo(Map<String, Object> connectionInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setOutboundConnectionInfo", (Object[])new Object[]{connectionInfo});
        }
        ThreadManager.getInstance().setOutboundConnectionInfo(connectionInfo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setOutboundConnectionInfo");
        }
    }

    private static SSLException asSSLException(Exception e) throws SSLException {
        if (e instanceof SSLException) {
            return (SSLException)e;
        }
        return new SSLException(e.getMessage(), e);
    }

    private static final class JSSESingleton {
        private static final JSSEHelper instance;

        private JSSESingleton() {
        }

        static {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Creating new instance of JSSEHelper.", (Object[])new Object[0]);
            }
            instance = new JSSEHelper();
        }
    }
}

