/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.timedoperations.bci.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.timedoperations.bci.internal.MethodInfo;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.AnalyzerAdapter;

public class TimedOperationsMethodAdapter
extends AdviceAdapter {
    private static final TraceComponent tc = Tr.register(TimedOperationsMethodAdapter.class);
    private final MethodVisitor visitor;
    private final MethodInfo methodInfo;
    private final String _type;
    private final String _classname;
    private int timer;
    private int timedops;
    private int metaDataProvider;
    private int metanamevarindex;
    private int rcIndex;

    protected TimedOperationsMethodAdapter(MethodVisitor visitor, MethodInfo mInfo, String timedOpsType, String classname, AnalyzerAdapter aa) {
        super(262144, visitor, mInfo.getAccessFlags(), mInfo.getMethodName(), mInfo.getDescriptor());
        this.visitor = visitor;
        this.methodInfo = mInfo;
        this._classname = classname;
        this._type = timedOpsType;
    }

    protected String getMethodName() {
        return this.methodInfo.getMethodName();
    }

    protected String getDescriptor() {
        return this.methodInfo.getDescriptor();
    }

    protected boolean isConstructor() {
        return "<init>".equals(this.getMethodName());
    }

    protected boolean isStaticInitializer() {
        return this.isStatic() && "<clinit>".equals(this.getMethodName());
    }

    protected int getAccessFlags() {
        return this.methodInfo.getAccessFlags();
    }

    protected boolean isStatic() {
        return (this.getAccessFlags() & 8) != 0;
    }

    protected String getSignature() {
        return this.methodInfo.getSignature();
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes((String)this.getDescriptor());
    }

    public Type getReturnType() {
        return Type.getReturnType((String)this.getDescriptor());
    }

    protected Set<Type> getDeclaredExceptions() {
        HashSet<Type> exceptionSet = new HashSet<Type>();
        for (String exception : this.methodInfo.getDeclaredExceptions()) {
            exceptionSet.add(Type.getType((String)exception));
        }
        return exceptionSet;
    }

    protected void createParameterArray() {
        int localVarOffset = this.isStatic() ? 0 : 1;
        Type[] argTypes = this.getArgumentTypes();
        this.createObjectArray(argTypes.length);
        for (int i = 0; i < argTypes.length; ++i) {
            int j = i + localVarOffset;
            this.visitInsn(89);
            this.visitLdcInsn(i);
            this.visitVarInsn(argTypes[i].getOpcode(21), j);
            this.box(argTypes[i]);
            this.visitInsn(83);
            localVarOffset += argTypes[i].getSize() - 1;
        }
    }

    protected void createObjectArray(int capacity) {
        this.visitLdcInsn(capacity);
        this.visitTypeInsn(189, "java/lang/Object");
    }

    protected void onMethodEnter() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry(TimedOperationsMethodAdapter.class, (TraceComponent)tc, (String)"onMethodEnter", (Object[])new Object[0]);
        }
        this.visitor.visitLdcInsn((Object)"TRACE POINT 1 : ENTRY");
        this.visitor.visitMethodInsn(184, "com/ibm/ws/timedoperations/bci/TimedOperationsHelper", "log", "(Ljava/lang/String;)V", false);
        this.metaDataProvider = this.newLocal(Type.getType((String)"com/ibm/wsspi/timedoperations/TimedOperationsTransformDescriptor"));
        this.metanamevarindex = this.newLocal(Type.getType((String)"Ljava/lang/String;"));
        this.visitor.visitLdcInsn((Object)this._classname);
        this.visitor.visitLdcInsn((Object)this.getMethodName());
        this.visitor.visitLdcInsn((Object)this.getDescriptor());
        this.visitor.visitMethodInsn(184, "com/ibm/ws/timedoperations/bci/TimedOperationsHelper", "getObjForInstrumentation", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/ibm/wsspi/timedoperations/TimedOperationsTransformDescriptor;", false);
        this.visitor.visitVarInsn(58, this.metaDataProvider);
        this.visitor.visitLdcInsn((Object)"TRACE POINT 2 : QUERIED TRANSFORM DESCRIPTOR FOR THIS METHOD");
        this.visitor.visitMethodInsn(184, "com/ibm/ws/timedoperations/bci/TimedOperationsHelper", "log", "(Ljava/lang/String;)V", false);
        this.visitor.visitVarInsn(25, this.metaDataProvider);
        this.visitor.visitVarInsn(25, 0);
        this.createParameterArray();
        this.visitor.visitMethodInsn(185, "com/ibm/wsspi/timedoperations/TimedOperationsTransformDescriptor", "getPattern", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/String;", true);
        this.visitor.visitVarInsn(58, this.metanamevarindex);
        this.visitor.visitLdcInsn((Object)"TRACE POINT 3 : INVOKE GETPATTERN SUCCESSFULLY");
        this.visitor.visitMethodInsn(184, "com/ibm/ws/timedoperations/bci/TimedOperationsHelper", "log", "(Ljava/lang/String;)V", false);
        this.timer = this.newLocal(Type.getType((String)"J"));
        this.timedops = this.newLocal(Type.getType((String)"com/ibm/wsspi/timedoperations/TimedOperation"));
        this.visitor.visitLdcInsn((Object)this._type);
        this.visitor.visitVarInsn(25, this.metanamevarindex);
        this.visitor.visitMethodInsn(184, "com/ibm/wsspi/timedoperations/TimedOperationService", "getTimedOperation", "(Ljava/lang/String;Ljava/lang/String;)Lcom/ibm/wsspi/timedoperations/TimedOperation;", false);
        this.visitor.visitVarInsn(58, this.timedops);
        this.visitor.visitLdcInsn((Object)"TRACE POINT 4 : GOT TIMEDOPERATION INSTANCE");
        this.visitor.visitMethodInsn(184, "com/ibm/ws/timedoperations/bci/TimedOperationsHelper", "log", "(Ljava/lang/String;)V", false);
        this.visitor.visitVarInsn(25, this.timedops);
        this.visitor.visitMethodInsn(185, "com/ibm/wsspi/timedoperations/TimedOperation", "start", "()J", true);
        this.visitor.visitVarInsn(55, this.timer);
        this.visitor.visitLdcInsn((Object)"TRACE POINT 5 : COMPLETED ENTRY.");
        this.visitor.visitMethodInsn(184, "com/ibm/ws/timedoperations/bci/TimedOperationsHelper", "log", "(Ljava/lang/String;)V", false);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit(TimedOperationsMethodAdapter.class, (TraceComponent)tc, (String)"onMethodEnter");
        }
    }

    public void onMethodExit(int opcode) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry(TimedOperationsMethodAdapter.class, (TraceComponent)tc, (String)"onMethodExit", (Object[])new Object[0]);
        }
        this.visitor.visitVarInsn(25, this.timedops);
        this.visitor.visitVarInsn(22, this.timer);
        this.visitor.visitMethodInsn(185, "com/ibm/wsspi/timedoperations/TimedOperation", "stopAndCheck", "(J)I", true);
        this.rcIndex = this.newLocal(Type.getType((String)"I"));
        this.visitor.visitVarInsn(54, this.rcIndex);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit(TimedOperationsMethodAdapter.class, (TraceComponent)tc, (String)"onMethodExit");
        }
    }
}

