/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.timedoperations.bci.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.timedoperations.bci.TimedOperationsHelper;
import com.ibm.ws.timedoperations.bci.internal.TimedOperationsClassVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class TimedOperationsTransformer
implements ClassFileTransformer {
    private Instrumentation inst = null;
    private static final TraceComponent tc = Tr.register(TimedOperationsTransformer.class);
    private static final ClassLoader loader = TimedOperationsTransformer.class.getClassLoader();

    public TimedOperationsTransformer(Instrumentation instrumentation) {
        this.inst = instrumentation;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (loader == TimedOperationsTransformer.loader) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"transform", (Object[])new Object[]{className});
        }
        byte[] ba = null;
        if (!TimedOperationsHelper.interestedClass(className)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"transform", (Object)className);
            }
            return null;
        }
        try {
            ba = this.transformClassForTimedOperations(classfileBuffer, className);
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"TIMED_OPERATION_METHOD_MONITOR_ERROR", (Object[])new Object[]{className, e.getMessage()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"transform", (Object)className);
        }
        return ba;
    }

    private byte[] transformClassForTimedOperations(byte[] cBuffer, String nameOfClass) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(cBuffer);
        ClassReader classReader = new ClassReader((InputStream)in);
        ClassWriter cw = new ClassWriter(2);
        TimedOperationsClassVisitor tocv = new TimedOperationsClassVisitor((ClassVisitor)cw, nameOfClass);
        classReader.accept((ClassVisitor)tocv, 4);
        return cw.toByteArray();
    }

    public void retransformTimedOperationRelatedClasses() {
        for (Class clazz : this.inst.getAllLoadedClasses()) {
            this.classAvailable(clazz);
        }
    }

    private void classAvailable(Class<?> clazz) {
        if (TimedOperationsHelper.interestedClass(clazz.getName().replace(".", "/"))) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"TRANSFORM", (Object[])new Object[]{clazz.getName()});
                }
                this.inst.retransformClasses(clazz);
            }
            catch (Exception e) {
                Tr.error((TraceComponent)tc, (String)"TIMED_OPERATION_METHOD_MONITOR_ERROR", (Object[])new Object[]{clazz.getName(), e});
            }
        }
    }
}

