/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.timedoperations.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.timedoperations.internal.TimedOperationRule;
import com.ibm.ws.timedoperations.internal.TimedOperationRuleImpl;
import com.ibm.wsspi.timedoperations.TimedOperation;
import java.util.logging.Logger;

public class TimedOperationImpl
implements TimedOperation {
    private final String type;
    private final String pattern;
    private final String id;
    private final TimedOperationRuleImpl rule;
    private static final TraceComponent tc = Tr.register(TimedOperationImpl.class);
    protected static final Logger log = Logger.getLogger("com.ibm.ws.timedoperations.internal");
    private static final int INVALID_START_TIME = -2;

    public TimedOperationImpl(String newType, String newPattern) {
        this.type = newType;
        this.pattern = newPattern;
        this.id = this.pattern != null ? this.type + ":" + this.pattern : this.type;
        this.rule = new TimedOperationRuleImpl();
    }

    public TimedOperationImpl(String newType) {
        this.type = newType;
        this.pattern = null;
        this.id = newType;
        this.rule = new TimedOperationRuleImpl();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long start() {
        long token = System.nanoTime();
        return token;
    }

    @Override
    public int stopAndCheck(long startTime) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"stopAndCheck", (Object[])new Object[]{startTime});
        }
        if (startTime <= 0L) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"stopAndCheck");
            }
            return -2;
        }
        long crtTime = System.nanoTime();
        long elapsedTime = crtTime - startTime;
        int ruleMatched = this.rule.processDataPoint((double)elapsedTime / 1000000.0, this.id);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"stopAndCheck", (Object)ruleMatched);
        }
        return ruleMatched;
    }

    public TimedOperationRule getRule() {
        return this.rule;
    }
}

