/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.timedoperations.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.timedoperations.internal.TimedOperationImpl;
import com.ibm.wsspi.logging.IntrospectableService;
import com.ibm.wsspi.timedoperations.TimedOperation;
import com.ibm.wsspi.timedoperations.TimedOperationService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TimedOperationIntrospector
implements IntrospectableService {
    private static final String INDENT6 = "      ";
    private static final String INDENT9 = "         ";
    private static final String INDENT16 = "                ";
    private static final TraceComponent tc = Tr.register(TimedOperationIntrospector.class);

    public String getName() {
        return "TimedOperationIntrospector";
    }

    public String getDescription() {
        return "Information about the timed operations, grouped by type, and sorted within each group by expected duration";
    }

    public void introspect(OutputStream out) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"introspect", (Object[])new Object[0]);
        }
        PrintWriter writer = new PrintWriter(out, true);
        writer.println();
        writer.println("---------------------------------------------------------------");
        HashMap<String, ArrayList<TimedOperation>> timedOperationsByType = TimedOperationService.getTimedOperationsByType();
        for (Map.Entry<String, ArrayList<TimedOperation>> crtEntry : timedOperationsByType.entrySet()) {
            ArrayList<TimedOperation> toSortedList = crtEntry.getValue();
            String crtType = crtEntry.getKey();
            writer.println("Timed operations for: " + crtType);
            writer.println("---------------------------------------------------------------");
            writer.println("Expected duration (ms)      Standard deviation (ms)      Timed operation");
            for (int i = 0; i < toSortedList.size(); ++i) {
                if (((TimedOperationImpl)toSortedList.get(i)).getRule().getExpectedDuration() != 0.0 && ((TimedOperationImpl)toSortedList.get(i)).getRule().getStandardDeviation() != 0.0) {
                    writer.println(String.format("%22.6f", ((TimedOperationImpl)toSortedList.get(i)).getRule().getExpectedDuration()) + String.format("%29.6f", ((TimedOperationImpl)toSortedList.get(i)).getRule().getStandardDeviation()) + INDENT6 + toSortedList.get(i).getId());
                    continue;
                }
                writer.println("         Not available                Not available      " + toSortedList.get(i).getId());
            }
            writer.println();
        }
        writer.flush();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"introspect");
        }
    }
}

