/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.timedoperations.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.timedoperations.internal.TimedOperationRule;

public class TimedOperationRuleImpl
implements TimedOperationRule {
    private static final TraceComponent tc = Tr.register(TimedOperationRuleImpl.class, (String)"timedOperations", (String)"com.ibm.ws.timedoperations.internal.resources.LoggingMessages");
    private final int NUM_SAMPLES_TO_EXCLUDE = 100;
    private final int NUM_SAMPLES_TO_IGNORE = 100;
    private static final int NUM_SAMPLES_FOR_MA = 100;
    private long numSamplesCounter = 0L;
    private int excludedSamples = 0;
    private int ignoredSamples = 0;
    private int noSamples = 0;
    private double ma = 0.0;
    private double stdDev = 0.0;
    private double maVariance = Double.NEGATIVE_INFINITY;
    private double oldM;
    private double newM;
    private double oldS;
    private double newS;
    private final TimedOperationSamplesQueue samples = new TimedOperationSamplesQueue();

    @Override
    public synchronized double getExpectedDuration() {
        return this.ma;
    }

    public synchronized double getVariance() {
        if (this.maVariance == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return this.maVariance;
    }

    @Override
    public synchronized double getStandardDeviation() {
        return Math.sqrt(this.maVariance);
    }

    private boolean isReady() {
        return this.excludedSamples >= 100 && this.ignoredSamples >= 100;
    }

    private void restartProcessing() {
        this.noSamples = 0;
        this.ignoredSamples = 0;
        this.numSamplesCounter = 0L;
        this.ma = 0.0;
        this.stdDev = 0.0;
        this.maVariance = Double.NEGATIVE_INFINITY;
        this.newS = 0.0;
        this.oldS = 0.0;
        this.newM = 0.0;
        this.oldM = 0.0;
        this.samples.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processDataPoint(double value, String timedOperationId) {
        int ruleMatch = -1;
        double mean = value;
        boolean isReady = false;
        boolean logWarning = false;
        TimedOperationRuleImpl timedOperationRuleImpl = this;
        synchronized (timedOperationRuleImpl) {
            if (this.excludedSamples < 100) {
                ++this.excludedSamples;
                return ruleMatch;
            }
            if (this.ignoredSamples < 100) {
                ++this.ignoredSamples;
            }
            if (this.noSamples < 100) {
                ++this.noSamples;
            }
            ++this.numSamplesCounter;
            if (this.noSamples == 1) {
                this.oldM = this.newM = value;
                this.ma = this.newM;
                this.newS = 0.0;
                this.oldS = 0.0;
                this.maVariance = 0.0;
                this.stdDev = 0.0;
                this.samples.add(false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(timedOperationId + ";" + value + ";" + this.ma + ";" + this.oldS + ";" + this.maVariance + ";" + this.stdDev + ";" + false + ";" + this.samples.countNumberNormalSamples() + ";" + this.samples.countNumberSamplesAboveZone() + ";" + this.numSamplesCounter), (Object[])new Object[0]);
                }
                return ruleMatch;
            }
            isReady = this.isReady();
            double zoneAbove5StdDev = this.ma + 5.0 * this.stdDev;
            if (!isReady || value < zoneAbove5StdDev) {
                mean = this.ma;
                this.ma = this.newM = this.oldM + (value - this.oldM) / (double)this.noSamples;
                this.newS = this.oldS + (value - this.oldM) * (value - this.newM);
                this.maVariance = this.newS / (double)(this.numSamplesCounter - 1L);
                this.oldM = this.newM;
                this.oldS = this.newS;
                this.stdDev = Math.sqrt(this.maVariance);
            }
            if (value < zoneAbove5StdDev) {
                ruleMatch = 0;
                this.samples.add(false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(timedOperationId + ";" + value + ";" + this.ma + ";" + this.newS + ";" + this.maVariance + ";" + this.stdDev + ";" + false + ";" + this.samples.countNumberNormalSamples() + ";" + this.samples.countNumberSamplesAboveZone() + ";" + this.numSamplesCounter), (Object[])new Object[0]);
                }
            } else {
                this.samples.add(true);
                mean = this.ma;
                if (isReady) {
                    int n = ruleMatch = this.samples.isNormalDistribution() ? 0 : 1;
                    if (ruleMatch == 1) {
                        logWarning = true;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(timedOperationId + ";" + value + ";" + this.ma + ";" + this.newS + ";" + this.maVariance + ";" + this.stdDev + ";" + true + ";" + this.samples.countNumberNormalSamples() + ";" + this.samples.countNumberSamplesAboveZone() + ";" + this.numSamplesCounter), (Object[])new Object[0]);
                }
                if (isReady && this.samples.isResetRequired()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Reset Required. Samples Above Normal Zone = " + this.samples.countNumberSamplesAboveZone()), (Object[])new Object[0]);
                    }
                    this.restartProcessing();
                }
            }
        }
        if (logWarning) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(timedOperationId + ";" + value + ";" + mean + ";WARNING"), (Object[])new Object[0]);
            }
            Tr.warning((TraceComponent)tc, (String)"TIMED_OPERATIONS_ABNORMAL_PATTERN_UCL", (Object[])new Object[]{timedOperationId.trim(), value, mean});
        }
        return ruleMatch;
    }

    protected static class TimedOperationSamplesQueue {
        private static final int NUM_SAMPLES_FOR_DISTRIBUTION = 32;
        private static final int PERCENTAGE_NORMAL_SAMPLES = 70;
        private static final int PERCENTAGE_DISCARDED_SAMPLES = 50;
        private static final int LIMIT_NORMAL_SAMPLES = 22;
        private static final int LIMIT_DISCARDED_SAMPLES = 16;
        private int recentSamplesQueue = 0;
        private int numGoodSamples = 0;
        private int numBadSamples = 0;

        protected boolean add(boolean sampleAboveZone) {
            boolean first;
            boolean bl = first = this.recentSamplesQueue < 0;
            if (this.numGoodSamples + this.numBadSamples < 32) {
                if (sampleAboveZone) {
                    ++this.numBadSamples;
                } else {
                    ++this.numGoodSamples;
                }
            } else {
                if (sampleAboveZone && !first) {
                    ++this.numBadSamples;
                    --this.numGoodSamples;
                }
                if (!sampleAboveZone && first) {
                    ++this.numGoodSamples;
                    --this.numBadSamples;
                }
            }
            this.recentSamplesQueue <<= 1;
            this.recentSamplesQueue |= sampleAboveZone ? 1 : 0;
            return first;
        }

        protected int countNumberSamplesAboveZone() {
            return this.numBadSamples;
        }

        protected int countNumberNormalSamples() {
            return this.numGoodSamples;
        }

        protected void reset() {
            this.recentSamplesQueue = 0;
            this.numGoodSamples = 0;
            this.numBadSamples = 0;
        }

        private boolean isResetRequired() {
            return this.numBadSamples >= 16;
        }

        private boolean isNormalDistribution() {
            return this.numGoodSamples >= 22;
        }

        public String toString() {
            return String.format("%32s", Integer.toBinaryString(this.recentSamplesQueue)).replace(' ', '0');
        }
    }
}

