/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.genericbnf.internal.BNFHeadersImpl;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.genericbnf.internal.TokenCodes;
import com.ibm.ws.http.channel.internal.HttpRequestMessageImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class GenericMessageImpl
extends BNFHeadersImpl {
    private static final TraceComponent tc = Tr.register(GenericMessageImpl.class, (String)"GenericBNF", null);
    private static final long serialVersionUID = 2516122741254647791L;
    private transient boolean completedFirstLine = false;
    private transient int numFirstLineTokensRead = 0;
    private transient boolean firstLineChanged = false;
    public long startTime = 0L;

    protected GenericMessageImpl() {
    }

    protected abstract void setParsedFirstToken(byte[] var1) throws Exception;

    protected abstract void setParsedSecondToken(byte[] var1) throws Exception;

    protected abstract void setParsedThirdToken(byte[] var1) throws Exception;

    protected boolean overChangeLimit() {
        return super.overHeaderChangeLimit();
    }

    protected abstract void parsingComplete() throws MalformedMessageException;

    protected abstract byte[] getMarshalledFirstToken();

    protected abstract byte[] getMarshalledSecondToken();

    protected abstract byte[] getMarshalledThirdToken();

    protected void setFirstLineComplete(boolean flag) {
        this.completedFirstLine = flag;
        if (flag) {
            this.firstLineChanged = false;
        }
    }

    protected final boolean isFirstLineComplete() {
        return this.completedFirstLine;
    }

    protected void setFirstLineChanged() {
        this.firstLineChanged = true;
    }

    protected boolean hasFirstLineChanged() {
        return this.firstLineChanged || super.overHeaderChangeLimit();
    }

    protected final int getNumberFirstLineTokens() {
        return this.numFirstLineTokensRead;
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseLine(WsByteBuffer buff) throws Exception {
        bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && GenericMessageImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)GenericMessageImpl.tc, (String)("parseLine called for " + this), (Object[])new Object[0]);
        }
        if (this instanceof HttpRequestMessageImpl && ((HttpRequestMessageImpl)this).getServiceContext().getHttpConfig().isAccessLoggingEnabled()) {
            this.startTime = System.nanoTime();
        }
        rc = false;
        startpos = bTrace != false && GenericMessageImpl.tc.isDebugEnabled() != false ? buff.position() : 0;
        tcRC = TokenCodes.TOKEN_RC_MOREDATA;
        while (!rc) {
            if (0 == this.numFirstLineTokensRead) {
                tcRC = this.skipCRLFs(buff);
                if (TokenCodes.TOKEN_RC_DELIM.equals(tcRC)) {
                    try {
                        tcRC = this.parseTokenExtract(buff, (byte)32, false, 0);
                        if (tcRC.equals(TokenCodes.TOKEN_RC_MOREDATA)) ** GOTO lbl56
                        this.setParsedFirstToken(this.getParsedToken());
                    }
                    catch (MalformedMessageException mme) {
                        if (bTrace && GenericMessageImpl.tc.isDebugEnabled()) {
                            curpos = buff.position();
                            buff.position(startpos);
                            offset = 0;
                            if (null != this.getParsedToken()) {
                                offset = this.getParsedToken().length;
                                data = new byte[curpos - startpos + offset];
                                System.arraycopy(this.getParsedToken(), 0, data, 0, offset);
                            } else {
                                data = new byte[curpos - startpos];
                            }
                            buff.get(data, offset, data.length - offset);
                            Tr.debug((TraceComponent)GenericMessageImpl.tc, (String)("Initial parse of message failed, (128) of buffer: \n" + GenericUtils.getHexDump(data, 128)), (Object[])new Object[0]);
                        }
                        throw mme;
                    }
                } else {
                    if (TokenCodes.TOKEN_RC_MOREDATA.equals(tcRC)) {
                        this.resetByteCache();
                        break;
                    }
                    if (TokenCodes.TOKEN_RC_CRLF.equals(tcRC)) {
                        throw new MalformedMessageException("Too many leading CRLFs");
                    }
                }
            } else if (1 == this.numFirstLineTokensRead) {
                tcRC = this.parseTokenExtract(buff, (byte)32, true, 2);
                if (!tcRC.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
                    this.setParsedSecondToken(this.getParsedToken());
                    if (tcRC.equals(TokenCodes.TOKEN_RC_CRLF)) {
                        if (bTrace && GenericMessageImpl.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)GenericMessageImpl.tc, (String)"Received CRLF after second token", (Object[])new Object[0]);
                        }
                        rc = true;
                    }
                }
            } else if (2 == this.numFirstLineTokensRead) {
                tcRC = this.parseCRLFTokenExtract(buff, 0);
                if (!tcRC.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
                    this.setParsedThirdToken(this.getParsedToken());
                    rc = true;
                }
            } else {
                rc = true;
            }
lbl56:
            // 6 sources

            if (tcRC.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
                this.resetByteCache();
                break;
            }
            this.setParsedToken(null);
            ++this.numFirstLineTokensRead;
        }
        if (rc) {
            this.parsingComplete();
            this.setFirstLineComplete(true);
            this.decrementBytePositionIgnoringLFs();
        }
        if (bTrace && GenericMessageImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)GenericMessageImpl.tc, (String)("parseLine returning " + rc + " for " + this), (Object[])new Object[0]);
        }
        return rc;
    }

    public WsByteBuffer[] marshallLine() {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallLine", (Object[])new Object[0]);
        }
        WsByteBuffer[] firstLine = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        firstLine = this.putBytes(this.getMarshalledFirstToken(), firstLine);
        firstLine = this.putByte((byte)32, firstLine);
        firstLine = this.putBytes(this.getMarshalledSecondToken(), firstLine);
        firstLine = this.putByte((byte)32, firstLine);
        firstLine = this.putBytes(this.getMarshalledThirdToken(), firstLine);
        firstLine = this.putBytes(BNFHeaders.EOL, firstLine);
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallLine");
        }
        return firstLine;
    }

    public boolean parseMessage(WsByteBuffer buffer, boolean bExtractValue) throws Exception {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        boolean rc = false;
        if (!this.isFirstLineComplete()) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Parsing First Line", (Object[])new Object[0]);
            }
            rc = this.parseLine(buffer);
        }
        if (this.isFirstLineComplete()) {
            rc = this.parseHeaders(buffer, bExtractValue);
        }
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseMessage returning " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    public WsByteBuffer[] marshallMessage() throws MessageSentException {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallMessage", (Object[])new Object[0]);
        }
        this.preMarshallMessage();
        WsByteBuffer[] marshalledObj = this.hasFirstLineChanged() ? this.marshallLine() : null;
        this.headerComplianceCheck();
        marshalledObj = this.marshallHeaders(marshalledObj);
        this.postMarshallMessage();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallMessage");
        }
        return marshalledObj;
    }

    protected abstract void headerComplianceCheck() throws MessageSentException;

    protected void preMarshallMessage() throws MessageSentException {
        super.resetByteCache();
    }

    protected void postMarshallMessage() {
    }

    @Override
    public void clear() {
        super.clear();
        this.completedFirstLine = false;
        this.numFirstLineTokensRead = 0;
        this.firstLineChanged = false;
    }

    @Override
    protected void destroy() {
        super.destroy();
    }

    @Override
    public void debug() {
        super.debug();
    }

    public void duplicate(GenericMessageImpl msg) {
        if (null == msg) {
            throw new NullPointerException("Null message passed to duplicate");
        }
        super.duplicate(msg);
    }

    @Override
    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        super.readExternal(s);
    }

    @Override
    public void writeExternal(ObjectOutput s) throws IOException {
        super.writeExternal(s);
    }
}

