/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

public class utils {
    static final byte FRAME_TYPE_DATA = 0;
    static final byte FRAME_TYPE_HEADERS = 1;
    static final byte FRAME_TYPE_PRIORITY = 2;
    static final byte FRAME_TYPE_RST_STREAM = 3;
    static final byte FRAME_TYPE_SETTINGS = 4;
    static final byte FRAME_TYPE_PUSH_PROMISE = 5;
    static final byte FRAME_TYPE_PING = 6;
    static final byte FRAME_TYPE_GOAWAY = 7;
    static final byte FRAME_TYPE_WINDOW_UPDATE = 8;
    static final byte FRAME_TYPE_CONTINUATION = 9;
    static final byte FRAME_TYPE_UNKNOWN = 15;
    static final int ZERO_STREAM_ID = 0;
    static final byte FRAME_TYPE_INDEX = 3;
    static final byte FRAME_FLAGS_INDEX = 4;
    static final byte FRAME_STREAM_START_INDEX = 5;
    static final int FRAME_STREAM_START_INDEX_INT = 5;

    public static String getErrorFromCode(int code) {
        switch (code) {
            case 0: {
                return "NO_ERROR";
            }
            case 1: {
                return "PROTOCOL_ERROR";
            }
            case 2: {
                return "INTERNAL_ERROR";
            }
            case 3: {
                return "FLOW_CONTROL_ERROR";
            }
            case 4: {
                return "SETTINGS_TIMEOUT";
            }
            case 5: {
                return "STREAM_CLOSED";
            }
            case 6: {
                return "FRAME_SIZE_ERROR";
            }
            case 7: {
                return "REFUSED_STREAM";
            }
            case 8: {
                return "CANCEL";
            }
            case 9: {
                return "COMPRESSION_ERROR";
            }
            case 10: {
                return "CONNECT_ERROR";
            }
            case 11: {
                return "ENHANCE_YOUR_CALM";
            }
            case 12: {
                return "INADEQUATE_SECURITY";
            }
            case 13: {
                return "HTTP_1_1_REQUIRED";
            }
        }
        return "UNDEFINED_ERROR";
    }

    public static void Move8BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in & 0xFF);
    }

    public static void Move16BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in >> 8 & 0xFF);
        out[++offset] = (byte)(in & 0xFF);
    }

    public static void Move24BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in >> 16 & 0xFF);
        out[++offset] = (byte)(in >> 8 & 0xFF);
        out[++offset] = (byte)(in & 0xFF);
    }

    public static void Move31BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in >>> 24 & 0x7F);
        out[++offset] = (byte)(in >> 16 & 0xFF);
        out[++offset] = (byte)(in >> 8 & 0xFF);
        out[++offset] = (byte)(in & 0xFF);
    }

    public static void Move32BitstoByteArray(int in, byte[] out, int offset) {
        out[offset] = (byte)(in >>> 24 & 0xFF);
        out[++offset] = (byte)(in >> 16 & 0xFF);
        out[++offset] = (byte)(in >> 8 & 0xFF);
        out[++offset] = (byte)(in & 0xFF);
    }

    public static byte getIndexNumber(String x) {
        if (x == null) {
            return -1;
        }
        if (x.compareToIgnoreCase(":authority") == 0) {
            return 1;
        }
        if (x.compareToIgnoreCase(":method-GET") == 0) {
            return 2;
        }
        if (x.compareToIgnoreCase(":method-POST") == 0) {
            return 3;
        }
        if (x.compareToIgnoreCase(":path-/") == 0) {
            return 4;
        }
        if (x.compareToIgnoreCase(":path-/index.html") == 0) {
            return 5;
        }
        if (x.compareToIgnoreCase(":scheme-http") == 0) {
            return 6;
        }
        if (x.compareToIgnoreCase(":scheme-https") == 0) {
            return 7;
        }
        if (x.compareToIgnoreCase(":status-200") == 0) {
            return 8;
        }
        if (x.compareToIgnoreCase(":status-204") == 0) {
            return 9;
        }
        if (x.compareToIgnoreCase(":status-206") == 0) {
            return 10;
        }
        if (x.compareToIgnoreCase(":status-304") == 0) {
            return 11;
        }
        if (x.compareToIgnoreCase(":status-400") == 0) {
            return 12;
        }
        if (x.compareToIgnoreCase(":status-404") == 0) {
            return 13;
        }
        if (x.compareToIgnoreCase(":status-500") == 0) {
            return 14;
        }
        if (x.compareToIgnoreCase("accept-charset") == 0) {
            return 15;
        }
        if (x.compareToIgnoreCase("accept-encoding-gzip") == 0) {
            return 16;
        }
        if (x.compareToIgnoreCase("accept-encoding-deflate") == 0) {
            return 16;
        }
        if (x.compareToIgnoreCase("accept-language") == 0) {
            return 17;
        }
        if (x.compareToIgnoreCase("accept-ranges") == 0) {
            return 18;
        }
        if (x.compareToIgnoreCase("accept") == 0) {
            return 19;
        }
        if (x.compareToIgnoreCase("access-control-allow-origin") == 0) {
            return 20;
        }
        if (x.compareToIgnoreCase("age") == 0) {
            return 21;
        }
        if (x.compareToIgnoreCase("allow") == 0) {
            return 22;
        }
        if (x.compareToIgnoreCase("authorization") == 0) {
            return 23;
        }
        if (x.compareToIgnoreCase("cache-control") == 0) {
            return 24;
        }
        if (x.compareToIgnoreCase("content-disposition") == 0) {
            return 25;
        }
        if (x.compareToIgnoreCase("content-encoding") == 0) {
            return 26;
        }
        if (x.compareToIgnoreCase("content-language") == 0) {
            return 27;
        }
        if (x.compareToIgnoreCase("content-length") == 0) {
            return 28;
        }
        if (x.compareToIgnoreCase("content-location") == 0) {
            return 29;
        }
        if (x.compareToIgnoreCase("content-range") == 0) {
            return 30;
        }
        if (x.compareToIgnoreCase("content-type") == 0) {
            return 31;
        }
        if (x.compareToIgnoreCase("cookie") == 0) {
            return 32;
        }
        if (x.compareToIgnoreCase("date") == 0) {
            return 33;
        }
        if (x.compareToIgnoreCase("etag") == 0) {
            return 34;
        }
        if (x.compareToIgnoreCase("expect") == 0) {
            return 35;
        }
        if (x.compareToIgnoreCase("expires") == 0) {
            return 36;
        }
        if (x.compareToIgnoreCase("from") == 0) {
            return 37;
        }
        if (x.compareToIgnoreCase("host") == 0) {
            return 38;
        }
        if (x.compareToIgnoreCase("if-match") == 0) {
            return 39;
        }
        if (x.compareToIgnoreCase("if-modified-since") == 0) {
            return 40;
        }
        if (x.compareToIgnoreCase("if-none-match") == 0) {
            return 41;
        }
        if (x.compareToIgnoreCase("if-range") == 0) {
            return 42;
        }
        if (x.compareToIgnoreCase("if-unmodified-since") == 0) {
            return 43;
        }
        if (x.compareToIgnoreCase("last-modified") == 0) {
            return 44;
        }
        if (x.compareToIgnoreCase("link") == 0) {
            return 45;
        }
        if (x.compareToIgnoreCase("location") == 0) {
            return 46;
        }
        if (x.compareToIgnoreCase("max-forwards") == 0) {
            return 47;
        }
        if (x.compareToIgnoreCase("proxy-authenticate") == 0) {
            return 48;
        }
        if (x.compareToIgnoreCase("proxy-authorization") == 0) {
            return 49;
        }
        if (x.compareToIgnoreCase("range") == 0) {
            return 50;
        }
        if (x.compareToIgnoreCase("referer") == 0) {
            return 51;
        }
        if (x.compareToIgnoreCase("refresh") == 0) {
            return 52;
        }
        if (x.compareToIgnoreCase("retry-after") == 0) {
            return 53;
        }
        if (x.compareToIgnoreCase("server") == 0) {
            return 54;
        }
        if (x.compareToIgnoreCase("set-cookie") == 0) {
            return 55;
        }
        if (x.compareToIgnoreCase("strict-transport-security") == 0) {
            return 56;
        }
        if (x.compareToIgnoreCase("transfer-encoding") == 0) {
            return 57;
        }
        if (x.compareToIgnoreCase("user-agent") == 0) {
            return 58;
        }
        if (x.compareToIgnoreCase("vary") == 0) {
            return 59;
        }
        if (x.compareToIgnoreCase("via") == 0) {
            return 60;
        }
        if (x.compareToIgnoreCase("www-authenticate") == 0) {
            return 61;
        }
        return -1;
    }

    public static String printArray(byte[] x) {
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i <= x.length; ++i) {
            if (i % 16 == 0) {
                buf.append(String.format("0x%02X", x[i - 1]) + " ");
                continue;
            }
            buf.append(String.format("0x%02X", x[i - 1]) + " ");
        }
        return buf.toString();
    }

    public static String printCharArrayWithHex(char[] x, int length) {
        int count = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c = x[i];
            byte b = (byte)c;
            if (++count % 64 == 0 && b != 10) {
                if (b == 13) {
                    buf.append("<CR>\n");
                    count = 0;
                    continue;
                }
                if (b > 0 && b < 127) {
                    buf.append(c + "\n");
                    count = 0;
                    continue;
                }
                buf.append(String.format("<0x%02X>", b) + " \n");
                count = 0;
                continue;
            }
            if (b == 10) {
                buf.append("\n<LF>");
                count = 0;
                continue;
            }
            if (b == 13) {
                buf.append("<CR>");
                continue;
            }
            if (b > 0 && b < 127) {
                buf.append(c);
                continue;
            }
            buf.append(String.format("<0x%02X>", b) + " ");
        }
        return buf.toString();
    }

    public static String printByteArrayWithHex(byte[] x, int length) {
        int count = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c;
            byte b = x[i];
            if (++count % 64 == 0 && b != 10) {
                if (b == 13) {
                    buf.append("<CR>\n");
                    count = 0;
                    continue;
                }
                if (b > 0 && b < 127) {
                    c = (char)b;
                    buf.append(c + "\n");
                    count = 0;
                    continue;
                }
                buf.append(String.format("<0x%02X>", b) + " \n");
                count = 0;
                continue;
            }
            if (b == 10) {
                buf.append("\n<LF>");
                count = 0;
                continue;
            }
            if (b == 13) {
                buf.append("<CR>");
                continue;
            }
            if (b > 0 && b < 127) {
                c = (char)b;
                buf.append(c);
                continue;
            }
            buf.append(String.format("<0x%02X>", b) + " ");
        }
        return buf.toString();
    }

    public static boolean getFlag(byte flags, int position) {
        byte[] bytes = new byte[]{flags};
        return (bytes[position / 8] & 1 << position % 8) != 0;
    }

    public static boolean getReservedBit(byte input) {
        return (input & 0xFFFFFF80) == -128;
    }
}

