/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.logging.DebugLog;

public class HttpISCWriteErrorCallback
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(HttpISCWriteErrorCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final HttpISCWriteErrorCallback myInstance = new HttpISCWriteErrorCallback();

    private HttpISCWriteErrorCallback() {
    }

    public static final HttpISCWriteErrorCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: vc=" + vc), (Object[])new Object[0]);
        }
        if (vc != null) {
            HttpInboundServiceContextImpl mySC = (HttpInboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
            mySC.finishSendError();
        }
    }

    public void error(VirtualConnection vc, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: vc=" + vc + " t=" + t), (Object[])new Object[0]);
        }
        if (vc != null) {
            HttpInboundServiceContextImpl mySC = (HttpInboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
            if (mySC.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
                mySC.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "The write of the response failed from a socket exception.", (HttpServiceContext)mySC);
            }
            mySC.logLegacyMessage();
            mySC.finishSendError();
        }
    }
}

