/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.embeddable.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.tx.jta.embeddable.impl.EmbeddableFailureScopeController;
import com.ibm.tx.jta.embeddable.impl.EmbeddableRegisteredResources;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTimeoutManager;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTranManagerSet;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTransactionState;
import com.ibm.tx.jta.embeddable.impl.WSATAsyncResource;
import com.ibm.tx.jta.embeddable.impl.WSATParticipantWrapper;
import com.ibm.tx.jta.embeddable.impl.WSATRecoveryCoordinator;
import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.JCARecoveryData;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.TransactionState;
import com.ibm.tx.jta.impl.TxPrimaryKey;
import com.ibm.tx.jta.impl.XidImpl;
import com.ibm.tx.remote.DistributableTransaction;
import com.ibm.tx.remote.TRANSACTION_ROLLEDBACK;
import com.ibm.tx.remote.TransactionWrapper;
import com.ibm.tx.util.TMHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.uow.embeddable.SynchronizationRegistryUOWScope;
import java.io.Serializable;
import java.util.Stack;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;

public class EmbeddableTransactionImpl
extends TransactionImpl
implements SynchronizationRegistryUOWScope,
DistributableTransaction {
    private static final TraceComponent tc = Tr.register(EmbeddableTransactionImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected final int _inactivityTimeout;
    protected EmbeddableWebSphereTransactionManager.InactivityTimer _inactivityTimer;
    protected boolean _inactivityTimerActive;
    protected Stack<Thread> _mostRecentThread;
    private int _activeAssociations;
    private int _suspendedAssociations;
    private String _globalId;
    private WSATRecoveryCoordinator _wsatRC;
    private int _retryWait;
    private Thread _thread;

    public EmbeddableTransactionImpl() {
        this._inactivityTimeout = this._configProvider.getClientInactivityTimeout();
        this._mostRecentThread = new Stack();
        this._retryWait = this._configProvider.getHeuristicRetryInterval() <= 0 ? 60 : this._configProvider.getHeuristicRetryInterval();
    }

    public EmbeddableTransactionImpl(int timeout, Xid xid, JCARecoveryData jcard) {
        super(timeout, xid, jcard);
        this._inactivityTimeout = this._configProvider.getClientInactivityTimeout();
        this._mostRecentThread = new Stack();
        this._retryWait = this._configProvider.getHeuristicRetryInterval() <= 0 ? 60 : this._configProvider.getHeuristicRetryInterval();
    }

    public EmbeddableTransactionImpl(EmbeddableFailureScopeController fsc) {
        super((FailureScopeController)fsc);
        this._inactivityTimeout = this._configProvider.getClientInactivityTimeout();
        this._mostRecentThread = new Stack();
        this._retryWait = this._configProvider.getHeuristicRetryInterval() <= 0 ? 60 : this._configProvider.getHeuristicRetryInterval();
    }

    public EmbeddableTransactionImpl(int txType, int timeout) {
        super(txType, timeout);
        this._inactivityTimeout = this._configProvider.getClientInactivityTimeout();
        this._mostRecentThread = new Stack();
        this._retryWait = this._configProvider.getHeuristicRetryInterval() <= 0 ? 60 : this._configProvider.getHeuristicRetryInterval();
    }

    public EmbeddableTransactionImpl(int timeout) {
        super(timeout);
        this._inactivityTimeout = this._configProvider.getClientInactivityTimeout();
        this._mostRecentThread = new Stack();
        this._retryWait = this._configProvider.getHeuristicRetryInterval() <= 0 ? 60 : this._configProvider.getHeuristicRetryInterval();
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("EmbeddableTransaction BEGIN occurred for TX: " + this._localTID), (Object[])new Object[0]);
        }
        ++this._activeAssociations;
        this.setThread(Thread.currentThread());
        this.updateMostRecentThread();
    }

    public EmbeddableTransactionImpl(int timeout, String globalID) throws SystemException {
        this._inactivityTimeout = this._configProvider.getClientInactivityTimeout();
        this._mostRecentThread = new Stack();
        this._retryWait = this._configProvider.getHeuristicRetryInterval() <= 0 ? 60 : this._configProvider.getHeuristicRetryInterval();
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"EmbeddableTransactionImpl", (Object[])new Object[]{timeout, globalID});
        }
        this._failureScopeController = Configuration.getFailureScopeController();
        this._subordinate = true;
        this._globalId = globalID;
        TxPrimaryKey pk = this.initializeTran(timeout);
        this._xid = new XidImpl(pk);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"EmbeddableTransactionImpl", (Object)this);
        }
    }

    protected void initialize(int timeout) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("(SPI) Transaction BEGIN occurred for TX: " + this._localTID), (Object[])new Object[0]);
        }
        if (this._failureScopeController != null) {
            this._failureScopeController.registerTransaction((TransactionImpl)this, false);
            if (this._failureScopeController.getRecoveryManager() == null) {
                this._disableTwoPhase = true;
            }
        } else {
            this._disableTwoPhase = true;
        }
        if (traceOn && tc.isDebugEnabled() && this._disableTwoPhase) {
            Tr.debug((TraceComponent)tc, (String)"No recovery log is currently available. Transaction can only support 1PC protocol", (Object[])new Object[0]);
        }
        this._status = new EmbeddableTransactionState(this);
        int maximumTransactionTimeout = this._configProvider.getMaximumTransactionTimeout();
        if (maximumTransactionTimeout > 0 && (timeout > maximumTransactionTimeout || timeout == 0)) {
            if (traceOn && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Timeout limited by maximumTransactionTimeout", (Object[])new Object[0]);
            }
            timeout = maximumTransactionTimeout;
        }
        if (timeout > 0) {
            this._timeout = timeout;
            EmbeddableTimeoutManager.setTimeout(this, 1, timeout);
        }
    }

    public boolean startInactivityTimer(EmbeddableWebSphereTransactionManager.InactivityTimer inactivityTimer) {
        this._inactivityTimer = inactivityTimer;
        boolean timerStarted = this.startInactivityTimer();
        if (!timerStarted) {
            this._inactivityTimer = null;
        }
        return this._inactivityTimerActive;
    }

    public boolean startInactivityTimer() {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startInactivityTimer", (Object[])new Object[0]);
        }
        if (this._inactivityTimeout > 0 && this._status.getState() == 0 && !this._inactivityTimerActive) {
            EmbeddableTimeoutManager.setTimeout(this, 4, this._inactivityTimeout);
            this._inactivityTimerActive = true;
            this._mostRecentThread.pop();
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startInactivityTimer", (Object)this._inactivityTimerActive);
        }
        return this._inactivityTimerActive;
    }

    public void rollbackResources() {
        boolean traceOn;
        block5: {
            traceOn = TraceComponent.isAnyTracingEnabled();
            if (traceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"rollbackResources", (Object[])new Object[0]);
            }
            try {
                Transaction t = ((EmbeddableTranManagerSet)TransactionManagerFactory.getTransactionManager()).suspend();
                this.getResources().rollbackResources();
                if (t != null) {
                    ((EmbeddableTranManagerSet)TransactionManagerFactory.getTransactionManager()).resume(t);
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.tx.jta.impl.EmbeddableTransactionImpl.rollbackResources", (String)"104", (Object)this);
                if (!traceOn || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Exception caught from rollbackResources()", (Object[])new Object[]{ex});
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollbackResources");
        }
    }

    public EmbeddableRegisteredResources getResources() {
        if (this._resources == null) {
            this._resources = new EmbeddableRegisteredResources(this, this._disableTwoPhase);
        }
        return (EmbeddableRegisteredResources)this._resources;
    }

    public synchronized void stopInactivityTimer() {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopInactivityTimer", (Object[])new Object[0]);
        }
        if (this._inactivityTimerActive) {
            this._inactivityTimerActive = false;
            EmbeddableTimeoutManager.setTimeout(this, 4, 0);
        }
        this._mostRecentThread.push(Thread.currentThread());
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopInactivityTimer");
        }
    }

    protected void distributeAfter(int status) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"distributeAfter", (Object[])new Object[]{status});
        }
        EmbeddableTransactionManagerFactory.getTransactionManager().suspend();
        if (this._syncs != null) {
            this._syncs.distributeAfter(status);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeAfter");
        }
    }

    @Override
    public int getUOWType() {
        return 1;
    }

    @Override
    public int getUOWStatus() {
        int uowStatus;
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWStatus", (Object[])new Object[]{this});
        }
        int status = this.getStatus();
        switch (status) {
            case 0: {
                uowStatus = 0;
                break;
            }
            case 1: {
                uowStatus = 1;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                uowStatus = 2;
                break;
            }
            case 3: {
                uowStatus = 3;
                break;
            }
            case 4: {
                uowStatus = 4;
                break;
            }
            default: {
                if (traceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUOWStatus", (Object)"IllegalStateException");
                }
                throw new IllegalStateException();
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWStatus", (Object)uowStatus);
        }
        return uowStatus;
    }

    protected void updateMostRecentThread() {
        this._mostRecentThread.push(Thread.currentThread());
    }

    @Override
    public void suspendAssociation() {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspendAssociation", (Object[])new Object[0]);
        }
        this.suspendAssociation(false);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspendAssociation");
        }
    }

    public synchronized void suspendAssociation(boolean notify) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspendAssociation", (Object[])new Object[]{notify, this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
        ++this._suspendedAssociations;
        if (notify) {
            this.notifyAll();
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspendAssociation", (Object)new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
    }

    @Override
    public void resumeAssociation() {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resumeAssociation", (Object[])new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
        this.resumeAssociation(true);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resumeAssociation", (Object)new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
    }

    public synchronized void resumeAssociation(boolean allowSetRollback) throws TRANSACTION_ROLLEDBACK {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resumeAssociation", (Object[])new Object[]{allowSetRollback, this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
        boolean doSetRollback = false;
        while (this._activeAssociations > this._suspendedAssociations) {
            block10: {
                doSetRollback = allowSetRollback;
                try {
                    if (doSetRollback && !this._rollbackOnly) {
                        this.setRollbackOnly();
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.Transaction.JTA.TransactionImpl.resumeAssociation", (String)"1748", (Object)this);
                    if (!traceOn || !tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)"setRollbackOnly threw exception", (Object[])new Object[]{ex});
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        --this._suspendedAssociations;
        if (doSetRollback) {
            TRANSACTION_ROLLEDBACK trb = new TRANSACTION_ROLLEDBACK("Context already active");
            if (traceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resumeAssociation throwing rolledback", (Object)new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread", trb});
            }
            throw trb;
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resumeAssociation", (Object)new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
    }

    @Override
    public String getGlobalId() {
        if (this._globalId == null) {
            this._globalId = Util.toHexString((byte[])this.getXid().getGlobalTransactionId());
        }
        return this._globalId;
    }

    public boolean isResumable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isResumable", (Object[])new Object[]{this, this._thread == null || this._suspendedAssociations >= this._activeAssociations});
        }
        return this._thread == null || this._suspendedAssociations >= this._activeAssociations;
    }

    @Override
    public synchronized void addAssociation() {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addAssociation", (Object[])new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
        if (this._activeAssociations > this._suspendedAssociations) {
            block7: {
                if (traceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"addAssociation received incoming request for active context", (Object[])new Object[0]);
                }
                try {
                    this.setRollbackOnly();
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.Transaction.JTA.TransactionImpl.addAssociation", (String)"1701", (Object)this);
                    if (!traceOn || !tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"setRollbackOnly threw exception", (Object[])new Object[]{ex});
                }
            }
            TRANSACTION_ROLLEDBACK trb = new TRANSACTION_ROLLEDBACK("Context already active");
            if (traceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addAssociation throwing rolledback", (Object)new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread", trb});
            }
            throw trb;
        }
        this.stopInactivityTimer();
        ++this._activeAssociations;
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addAssociation", (Object)new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
    }

    @Override
    public synchronized void removeAssociation() {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAssociation", (Object[])new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
        --this._activeAssociations;
        if (this._activeAssociations <= 0) {
            this.startInactivityTimer();
        } else {
            this._mostRecentThread.pop();
        }
        this.notifyAll();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAssociation", (Object)new Object[]{this._activeAssociations, this._suspendedAssociations, this._thread != null ? String.format("%08X", this._thread.getId()) : "Not on a thread"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enlistAsyncResource(String xaResFactoryFilter, Serializable xaResInfo, Xid xid) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlistAsyncResource", (Object[])new Object[]{"(SPI): args: ", xaResFactoryFilter, xaResInfo, xid});
        }
        try {
            WSATAsyncResource res = new WSATAsyncResource(xaResFactoryFilter, xaResInfo, xid);
            WSATParticipantWrapper wrapper = new WSATParticipantWrapper(res);
            this.getResources().addAsyncResource(wrapper);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistAsyncResource", (Object)"(SPI)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void timeoutTransaction(boolean initial) {
        traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && EmbeddableTransactionImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)EmbeddableTransactionImpl.tc, (String)"timeoutTransaction", (Object[])new Object[]{initial});
        }
        if (traceOn && EmbeddableTransactionImpl.tc.isEventEnabled()) {
            Tr.event((TraceComponent)EmbeddableTransactionImpl.tc, (String)("(SPI) Transaction TIMEOUT occurred for TX: " + this.getLocalTID()), (Object[])new Object[0]);
        }
        this._rollbackOnly = true;
        this._timedOut = true;
        this.abortTransactionParticipants();
        if (initial) {
            if (this._status.getState() == 0) {
                if (this._timeout == 0) {
                    this._timeout = 10;
                }
                EmbeddableTimeoutManager.setTimeout(this, 3, this._timeout);
                if (this._activeAssociations <= 0) {
                    this.rollbackResources();
                }
            }
        } else if (this._activeAssociations <= 0) {
            block21: {
                tranManager = (EmbeddableTranManagerSet)TransactionManagerFactory.getTransactionManager();
                resumed = false;
                try {
                    tranManager.resume((Transaction)this);
                    resumed = true;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.tx.jta.TransactionImpl.timeoutTransaction", (String)"1311", (Object)this);
                    if (!traceOn || !EmbeddableTransactionImpl.tc.isDebugEnabled()) break block21;
                    Tr.debug((TraceComponent)EmbeddableTransactionImpl.tc, (String)"timeoutTransaction resume threw exception", (Object[])new Object[]{t});
                }
            }
            if (resumed) {
                rolledback = false;
                try {
                    tranManager.rollback();
                    rolledback = true;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.tx.jta.TransactionImpl.timeoutTransaction", (String)"1326", (Object)this);
                    if (!traceOn || !EmbeddableTransactionImpl.tc.isDebugEnabled()) ** GOTO lbl51
                    Tr.debug((TraceComponent)EmbeddableTransactionImpl.tc, (String)"timeoutTransaction rollback threw exception", (Object[])new Object[]{t});
                }
                finally {
                    if (!rolledback) {
                        tranManager.suspend();
                    }
                }
            }
        } else {
            this._rollbackOnly = true;
            if (this._status.getState() == 0) {
                if (this._timeout == 0) {
                    this._timeout = 10;
                }
                EmbeddableTimeoutManager.setTimeout(this, 3, this._timeout);
            }
        }
lbl51:
        // 8 sources

        if (traceOn && EmbeddableTransactionImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)EmbeddableTransactionImpl.tc, (String)"timeoutTransaction");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void recover() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object[])new Object[]{this});
        }
        if (this._activeAssociations <= 0) {
            int state = this._status.getState();
            if (this._subordinate) {
                block0 : switch (state) {
                    case 3: 
                    case 4: 
                    case 7: {
                        this.recoverCommit(true);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: {
                        this.recoverRollback(true);
                        break;
                    }
                    default: {
                        if (this._JCARecoveryData != null) {
                            String id = this._JCARecoveryData.getWrapper().getProviderId();
                            if (TMHelper.isProviderInstalled((String)id)) {
                                if (!tc.isDebugEnabled()) break;
                                Tr.debug((TraceComponent)tc, (String)"recover", (Object[])new Object[]{"Do nothing. Expect provider " + id + " will complete."});
                                break;
                            }
                            switch (this._configProvider.getHeuristicCompletionDirection()) {
                                case 0: {
                                    Tr.error((TraceComponent)tc, (String)"WTRN0098_COMMIT_RA_UNINSTALLED", (Object[])new Object[]{this.getTranName(), id});
                                    this.recoverCommit(false);
                                    break block0;
                                }
                                case 2: {
                                    this._needsManualCompletion = true;
                                    Tr.info((TraceComponent)tc, (String)"WTRN0101_MANUAL_RA_UNINSTALLED", (Object[])new Object[]{this.getTranName(), id});
                                    break block0;
                                }
                            }
                            Tr.error((TraceComponent)tc, (String)"WTRN0099_ROLLBACK_RA_UNINSTALLED", (Object[])new Object[]{this.getTranName(), id});
                            this.recoverRollback(false);
                            break;
                        }
                        this.retryCompletion();
                        break;
                    }
                }
            } else if (state == 9) {
                switch (ConfigurationProviderManager.getConfigurationProvider().getHeuristicCompletionDirection()) {
                    case 0: {
                        Tr.error((TraceComponent)tc, (String)"WTRN0096_HEURISTIC_MAY_HAVE_OCCURED", (Object[])new Object[]{this.getTranName()});
                        this.recoverCommit(false);
                        break;
                    }
                    case 2: {
                        this._needsManualCompletion = true;
                        Tr.info((TraceComponent)tc, (String)"WTRN0097_HEURISTIC_MANUAL_COMPLETION", (Object[])new Object[]{this.getTranName()});
                        break;
                    }
                    default: {
                        Tr.error((TraceComponent)tc, (String)"WTRN0102_HEURISTIC_MAY_HAVE_OCCURED", (Object[])new Object[]{this.getTranName()});
                        this.recoverRollback(false);
                        break;
                    }
                }
            } else if (state == 3) {
                this.recoverCommit(false);
            } else {
                this.recoverRollback(false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    public boolean hasSuspendedAssociations() {
        boolean result;
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"hasSuspendedAssociations", (Object[])new Object[]{"_activeAssociations=" + this._activeAssociations, "_suspendedAssociations=" + this._suspendedAssociations});
        }
        boolean bl = result = this._suspendedAssociations > 0;
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"hasSuspendedAssociations", (Object)result);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void inactivityTimeout() {
        block15: {
            traceOn = TraceComponent.isAnyTracingEnabled();
            if (traceOn && EmbeddableTransactionImpl.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)EmbeddableTransactionImpl.tc, (String)"inactivityTimeout", (Object[])new Object[]{this});
            }
            this._inactivityTimerActive = false;
            if (this._inactivityTimer != null) {
                try {
                    this._inactivityTimer.alarm();
                }
                catch (Throwable exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.tx.jta.TransactionImpl.inactivityTimeout", (String)"2796", (Object)this);
                    if (!traceOn || !EmbeddableTransactionImpl.tc.isEventEnabled()) ** GOTO lbl34
                    Tr.event((TraceComponent)EmbeddableTransactionImpl.tc, (String)"exception caught in inactivityTimeout", (Object[])new Object[]{exc});
                }
                finally {
                    this._inactivityTimer = null;
                }
            } else if (this._activeAssociations <= 0) {
                tranManager = (EmbeddableTranManagerSet)TransactionManagerFactory.getTransactionManager();
                try {
                    block14: {
                        tranManager.resume((Transaction)this);
                        try {
                            tranManager.setRollbackOnly();
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.TransactionImpl.inactivityTimeout", (String)"4353", (Object)this);
                            if (!traceOn || !EmbeddableTransactionImpl.tc.isDebugEnabled()) break block14;
                            Tr.debug((TraceComponent)EmbeddableTransactionImpl.tc, (String)"inactivityTimeout setRollbackOnly threw exception", (Object[])new Object[]{e});
                        }
                    }
                    tranManager.rollback();
                }
                catch (Exception ex) {
                    if (!traceOn || !EmbeddableTransactionImpl.tc.isDebugEnabled()) break block15;
                    Tr.debug((TraceComponent)EmbeddableTransactionImpl.tc, (String)"inactivityTimeout resume/rollback threw exception", (Object[])new Object[]{ex});
                }
            }
        }
        if (traceOn && EmbeddableTransactionImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)EmbeddableTransactionImpl.tc, (String)"inactivityTimeout");
        }
    }

    public Thread getMostRecentThread() {
        if (this._activeAssociations > 0) {
            return this._mostRecentThread.peek();
        }
        return null;
    }

    protected void cancelAlarms() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancelAlarms", (Object[])new Object[0]);
        }
        if (this._timeout > 0) {
            EmbeddableTimeoutManager.setTimeout(this, 0, 0);
            this._timeout = 0;
        }
        if (this._inactivityTimerActive) {
            this.stopInactivityTimer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancelAlarms");
        }
    }

    protected void handleHeuristicOnCommit(boolean waitForHeuristic) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleHeuristicOnCommit", (Object[])new Object[]{waitForHeuristic, this});
        }
        if (this._doNotRetryRecovery && waitForHeuristic && 7 == this._status.getState()) {
            if (traceOn && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"recoverCommit", (Object[])new Object[]{"Checking if we can forget transaction"});
            }
            if (this._wsatRC != null) {
                this.notifyCompletion();
            } else if (this._JCARecoveryData == null) {
                this.replay();
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleHeuristicOnCommit");
        }
    }

    protected void handleHeuristicOnRollback(boolean waitForHeuristic) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleHeuristicOnRollback", (Object[])new Object[]{waitForHeuristic, this});
        }
        if (this._doNotRetryRecovery && waitForHeuristic && 8 == this._status.getState()) {
            if (traceOn && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"recoverRollback", (Object[])new Object[]{"Checking if we can forget transaction"});
            }
            if (this._wsatRC != null) {
                this.notifyCompletion();
            } else if (this._JCARecoveryData == null) {
                this.replay();
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleHeuristicOnRollback");
        }
    }

    protected void retryCompletion() {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retryCompletion", (Object[])new Object[]{this, this._configProvider.getHeuristicRetryLimit(), this._retryAttempts});
        }
        if (this._configProvider.getHeuristicRetryLimit() <= 0 || this._retryAttempts < this._configProvider.getHeuristicRetryLimit()) {
            ++this._retryAttempts;
            this.replay();
            Tr.warning((TraceComponent)tc, (String)"WTRN0056_TRAN_RESYNC_FAILURE", (Object[])new Object[]{this.getTranName()});
            if (!this._inRecovery) {
                if (this._retryAttempts % 10 == 0 && this._retryWait < 0x3FFFFFFF) {
                    this._retryWait *= 2;
                }
                EmbeddableTimeoutManager.setTimeout(this, 2, this._retryWait);
            }
        } else {
            switch (this._configProvider.getHeuristicCompletionDirection()) {
                case 0: {
                    Tr.error((TraceComponent)tc, (String)"WTRN0093_COMMIT_REPLAY_COMPLETION", (Object[])new Object[]{this.getTranName()});
                    this.recoverCommit(false);
                    break;
                }
                case 2: {
                    this._needsManualCompletion = true;
                    Tr.info((TraceComponent)tc, (String)"WTRN0095_MANUAL_REPLAY_COMPLETION", (Object[])new Object[]{this.getTranName()});
                    break;
                }
                default: {
                    Tr.error((TraceComponent)tc, (String)"WTRN0094_ROLLBACK_REPLAY_COMPLETION", (Object[])new Object[]{this.getTranName()});
                    this.recoverRollback(false);
                }
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retryCompletion");
        }
    }

    protected void replay() {
        boolean traceOn;
        block7: {
            traceOn = TraceComponent.isAnyTracingEnabled();
            if (traceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"replay", (Object[])new Object[]{this});
            }
            try {
                if (this._wsatRC != null) {
                    this._wsatRC.replayCompletion(this._globalId);
                } else if (traceOn && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("No WSATRecoveryCoordinator to call replayCompletion on: " + this._globalId), (Object[])new Object[0]);
                }
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.embeddable.impl.EmbeddableTransactionImpl.replay", (String)"1018", (Object)this);
                if (!traceOn || !tc.isEventEnabled()) break block7;
                Tr.event((TraceComponent)tc, (String)"exception caught in recover", (Object[])new Object[]{exc});
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"replay");
        }
    }

    protected void reconstructCoordinators(RecoverableUnit log) throws SystemException {
        RecoverableUnitSection _wsatRCSection;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconstructCoordinators", (Object[])new Object[]{log, this});
        }
        if ((_wsatRCSection = log.lookupSection(9)) != null) {
            if (this._subordinate) {
                Tr.error((TraceComponent)tc, (String)"WTRN0001_ERR_INT_ERROR", (Object[])new Object[]{"reconstruct", this.getClass().getName()});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reconstructCoordinators", (Object)"SystemException");
                }
                throw new SystemException();
            }
            try {
                this._subordinate = true;
                byte[] logData = _wsatRCSection.lastData();
                this._wsatRC = WSATRecoveryCoordinator.fromLogData(logData);
                this._globalId = this._wsatRC.getGlobalId();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("We are WSAT subordinate: " + this._globalId), (Object[])new Object[0]);
                }
                new TransactionWrapper(this);
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.tx.jta.TransactionImpl.reconstruct", (String)"1670", (Object)this);
                Tr.fatal((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object[])new Object[]{"reconstruct", this.getClass().getName(), e});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reconstructCoordinators", (Object)"SystemException");
                }
                throw new SystemException(e.getLocalizedMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconstructCoordinators");
        }
    }

    protected TransactionState createState(TransactionImpl tx) {
        return new EmbeddableTransactionState((EmbeddableTransactionImpl)tx);
    }

    @Override
    public void setWSATRecoveryCoordinator(WSATRecoveryCoordinator rc) {
        this._wsatRC = rc;
    }

    public WSATRecoveryCoordinator getWSATRecoveryCoordinator() {
        return this._wsatRC;
    }

    @Override
    public void replayCompletion() {
        this.recover();
    }

    public void setThread(Thread t) {
        this._thread = t;
    }

    public Thread getThread() {
        return this._thread;
    }

    public String toString() {
        Thread local_thread = this._thread;
        return super.toString() + ",active=" + this._activeAssociations + ",suspended=" + this._suspendedAssociations + "," + (local_thread != null ? "thread=" + String.format("%08X", local_thread.getId()) : "Not on a thread, globalId=" + this._globalId);
    }
}

