/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.JsonHelper;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.Product;
import com.ibm.ws.usage.metering.common.TaskScheduler;
import com.ibm.ws.usage.metering.common.UsageTask;
import com.ibm.ws.usage.metering.common.Util;
import com.ibm.ws.usage.metering.common.exceptions.MeteringException;
import com.ibm.wsspi.usage.metering.AggregationMethodDescriptor;
import com.ibm.wsspi.usage.metering.Metric;
import com.ibm.wsspi.usage.metering.Usage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class CollectUsageTask
implements Runnable {
    private static final String CLASS_NAME = CollectUsageTask.class.getName();
    private static final TraceComponent tc = Tr.register(CollectUsageTask.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static int totalAggregratedMessages = 1;
    protected final long intervalStartTime;
    protected final long intervalEndTime;
    private final MeteringMetadata data;
    private final TaskScheduler scheduler;
    private final List<Product> products;
    private final Queue<JSONObject> queue;
    private final boolean retry;

    public CollectUsageTask(MeteringMetadata data, TaskScheduler scheduler, List<Product> products, Queue<JSONObject> queue, boolean retry, long intervalStartTime, long intervalEndTime) {
        this.data = data;
        this.scheduler = scheduler;
        this.products = products;
        this.queue = queue;
        this.retry = retry;
        this.intervalStartTime = intervalStartTime;
        this.intervalEndTime = intervalEndTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        Class<CollectUsageTask> clazz = CollectUsageTask.class;
        synchronized (CollectUsageTask.class) {
            block38: {
                ArrayList productResolvers = new ArrayList();
                HashSet<String> allMetricTypes = new HashSet<String>();
                for (Product p : this.products) {
                    productResolvers.add(new RequestUsage(p));
                    Set<String> metricTypes = p.getMetricTypes();
                    if (metricTypes == null) continue;
                    allMetricTypes.addAll(metricTypes);
                }
                try {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CollectUsageTask: " + this.products.size() + " products found: startTime=" + this.intervalStartTime + ", endTime=" + this.intervalEndTime));
                    }
                    List allProductUsage = this.retry ? this.scheduler.invokeAll(productResolvers, 2L, UsageTask.TIMEOUTUNIT) : this.scheduler.invokeAll(productResolvers, 15L, TimeUnit.SECONDS);
                    Usage primaryProductUsage = null;
                    Vector<Metric> allProductMetrics = new Vector<Metric>();
                    HashSet<String> metricTypes = new HashSet<String>();
                    for (int pos = 0; pos < allProductUsage.size(); ++pos) {
                        try {
                            Usage usage = (Usage)allProductUsage.get(pos).get();
                            if (usage == null) continue;
                            Collection<Metric> metrics = usage.getMetrics();
                            if (metrics != null) {
                                for (Metric metric : metrics) {
                                    String metricType = metric.getMetricType();
                                    Number metricValue = metric.getMetricValue();
                                    if (metricType == null || metricType.equals("")) {
                                        Tr.warning((TraceComponent)tc, (String)"INVALID_METRIC_TYPE_CWWKR0428W", (Object)new Object[]{metricValue, metricType, this.products.get(pos).getName()});
                                        continue;
                                    }
                                    if (metricValue == null) {
                                        Tr.warning((TraceComponent)tc, (String)"INVALID_METRIC_VALUE_CWWKR0429W", (Object)new Object[]{metricValue, metricType, this.products.get(pos).getName()});
                                        continue;
                                    }
                                    if (allMetricTypes.contains(metricType)) {
                                        if (metricTypes.contains(metricType)) continue;
                                        metricTypes.add(metricType);
                                        allProductMetrics.add(metric);
                                        continue;
                                    }
                                    Tr.warning((TraceComponent)tc, (String)"INVALID_METRIC_TYPE_CWWKR0428W", (Object)new Object[]{metricValue, metricType, this.products.get(pos).getName()});
                                }
                            }
                            if (pos != 0) continue;
                            primaryProductUsage = usage;
                            continue;
                        }
                        catch (CancellationException e) {
                            if (this.retry) {
                                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"95", (Object)this);
                                Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0431W", (Object)new Object[]{this.products.get(pos).getName(), e.getCause() != null ? e.getCause().toString() : e.toString()});
                            } else if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("CollectUsageTask: Timeout occurred waiting for last product usage: " + this.products.get(pos).getName() + ": " + e.getClass().getName() + ": " + (e.getCause() != null ? e.getCause() : e)));
                            }
                            this.products.get(pos).resetUsageDataCollection();
                            continue;
                        }
                        catch (ExecutionException e) {
                            if (this.retry) {
                                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"101", (Object)this);
                                Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0431W", (Object)new Object[]{this.products.get(pos).getName(), e.getCause() != null ? e.getCause().toString() : e.toString()});
                            } else if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("CollectUsageTask: Product exception occurred while waiting for last product usage: " + this.products.get(pos).getName() + ": " + e.getClass().getName() + ": " + (e.getCause() != null ? e.getCause() : e)));
                            }
                            this.products.get(pos).resetUsageDataCollection();
                            continue;
                        }
                        catch (InterruptedException e) {
                            if (this.retry) {
                                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"106", (Object)this);
                                Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0431W", (Object)new Object[]{this.products.get(pos).getName(), e.getCause() != null ? e.getCause().toString() : e.toString()});
                            } else if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("CollectUsageTask: Interruption occurred while waiting for last product usage: " + this.products.get(pos).getName() + ": " + e.getClass().getName() + ": " + (e.getCause() != null ? e.getCause() : e)));
                            }
                            this.products.get(pos).resetUsageDataCollection();
                            continue;
                        }
                        catch (Exception e) {
                            if (this.retry) {
                                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"117", (Object)this);
                                Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0431W", (Object)new Object[]{this.products.get(pos).getName(), e.getCause() != null ? e.getCause().toString() : e.toString()});
                            } else if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("CollectUsageTask: Interruption occurred while waiting for last product usage: " + this.products.get(pos).getName() + ": " + e.getClass().getName() + ": " + (e.getCause() != null ? e.getCause() : e)));
                            }
                            this.products.get(pos).resetUsageDataCollection();
                        }
                    }
                    if (!allProductMetrics.isEmpty()) {
                        if (this.data.logCSV()) {
                            this.data.getLogHelper().writeUsageCSV(allProductMetrics, this.intervalStartTime, this.intervalEndTime);
                        }
                        this.pushMessage(JsonHelper.createUsageMessage(this.data, primaryProductUsage, allProductMetrics, this.intervalStartTime, this.intervalEndTime));
                    } else if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"CollectUsageTask: Didn't collect any product metrics, canceling.");
                    }
                }
                catch (InterruptedException ie) {
                    if (this.retry && !this.scheduler.isShuttingDown()) {
                        FFDCFilter.processException((Throwable)ie, (String)(CLASS_NAME + ".run"), (String)"121", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0409W", (Object)(ie.getCause() != null ? ie.getCause().getMessage() : ie.getMessage()));
                        for (Product product : this.products) {
                            product.resetUsageDataCollection();
                        }
                    }
                    if (!isTraceOn || !tc.isDebugEnabled()) break block38;
                    Tr.debug((TraceComponent)tc, (String)("CollectUsageTask: Interruption occurred while waiting for the products usage: " + (ie.getCause() != null ? ie.getCause().getMessage() : ie.getMessage())));
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushMessage(JSONObject message) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("pushMessage: queue size=" + this.queue.size() + ", " + Util.identity(message)));
        }
        Queue<JSONObject> queue = this.queue;
        synchronized (queue) {
            if (this.queue.size() < UsageTask.MAX_QUEUE_SIZE) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && totalAggregratedMessages > 1) {
                    Tr.debug((TraceComponent)tc, (String)"Detected queue size was reduced. Resetting totalAggregratedMessages to 1.");
                }
                totalAggregratedMessages = 1;
                this.queue.add(message);
            } else {
                if ((totalAggregratedMessages - 1) % 4 == 0) {
                    Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0436W", (Object)new Object[]{UsageTask.MAX_QUEUE_SIZE + totalAggregratedMessages, UsageTask.INTERVALTIMEUNIT.toMinutes(UsageTask.COLLECTION_INTERVAL), "IBM Cloud Private Metering"});
                }
                JSONObject lastMessage = this.popLastMessage();
                try {
                    JSONObject registrationJson = OrderedJSONObject.parse((String)JsonHelper.buildRegistrationJSON(this.data, this.products));
                    JSONArray metricDescriptorsArray = (JSONArray)registrationJson.get((Object)"metrics");
                    JSONObject mergedMessage = CollectUsageTask.mergeMessages(lastMessage, message, metricDescriptorsArray);
                    this.queue.add(mergedMessage);
                }
                catch (Exception e) {
                    totalAggregratedMessages = 1;
                    this.queue.add(message);
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"264");
                    Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0409W", (Object)("CollectUsageTask: Failed to merge messages. The new message was added and the last message was removed. Exception was: " + e));
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pushMessage");
        }
    }

    public static JSONObject mergeMessages(JSONObject lastMessage, JSONObject newMessage, JSONArray metricDescriptorsArray) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Last message:");
            try {
                Tr.debug((TraceComponent)tc, (String)lastMessage.serialize());
                Tr.debug((TraceComponent)tc, (String)"New Message: ");
                Tr.debug((TraceComponent)tc, (String)newMessage.serialize());
            }
            catch (IOException e) {
                Tr.debug((TraceComponent)tc, (String)"failed to serialize the JSON objects for trace");
            }
        }
        JSONObject mergedMessage = new JSONObject();
        long lastMessageStartTime = (Long)lastMessage.get((Object)"startTime");
        long lastMessageEndTime = (Long)lastMessage.get((Object)"endTime");
        long newMessageStartTime = (Long)newMessage.get((Object)"startTime");
        long newMessageEndTime = (Long)newMessage.get((Object)"endTime");
        if (newMessageStartTime - lastMessageEndTime != 1L) {
            MeteringException ex = new MeteringException("Unable to merge the new usage message with the last usage message. The last message and the new message times are not contiguous.");
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".run"), (String)"285");
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CollectUsageTask: Unable to merge messages. Discarding the latest message");
            }
            return newMessage;
        }
        mergedMessage.put((Object)"startTime", (Object)lastMessageStartTime);
        mergedMessage.put((Object)"endTime", (Object)newMessageEndTime);
        ++totalAggregratedMessages;
        mergedMessage.put((Object)"hostName", newMessage.get((Object)"hostName"));
        mergedMessage.put((Object)"installDirectory", newMessage.get((Object)"installDirectory"));
        mergedMessage.put((Object)"instanceIdentifier", newMessage.get((Object)"instanceIdentifier"));
        if (newMessage.get((Object)"environmentType") != null) {
            mergedMessage.put((Object)"environmentType", newMessage.get((Object)"environmentType"));
        } else if (lastMessage.get((Object)"environmentType") != null) {
            mergedMessage.put((Object)"environmentType", lastMessage.get((Object)"environmentType"));
        }
        if (newMessage.get((Object)"productSpecificData") != null) {
            mergedMessage.put((Object)"productSpecificData", newMessage.get((Object)"productSpecificData"));
        } else if (lastMessage.get((Object)"productSpecificData") != null) {
            mergedMessage.put((Object)"productSpecificData", lastMessage.get((Object)"productSpecificData"));
        }
        JSONArray mergedUsageArray = new JSONArray();
        JSONArray lastMessageUsageArray = (JSONArray)lastMessage.get((Object)"usageList");
        JSONArray newMessageUsageArray = (JSONArray)newMessage.get((Object)"usageList");
        for (int lastMessageUsageIndex = 0; lastMessageUsageIndex < lastMessageUsageArray.size(); ++lastMessageUsageIndex) {
            JSONObject usage = (JSONObject)lastMessageUsageArray.get(lastMessageUsageIndex);
            String metricType = (String)usage.get((Object)"metricType");
            Number metricValue = (Number)usage.get((Object)"metricValue");
            JSONObject matchingMetric = null;
            block5: for (int index = 0; index < newMessageUsageArray.size(); ++index) {
                JSONObject newUsage = (JSONObject)newMessageUsageArray.get(index);
                String newUsageMetricType = (String)newUsage.get((Object)"metricType");
                if (!metricType.equals(newUsageMetricType)) continue;
                matchingMetric = newUsage;
                Number newMetricValue = (Number)newUsage.get((Object)"metricValue");
                for (int i = 0; i < metricDescriptorsArray.size(); ++i) {
                    double doubleValue;
                    JSONObject metricDescriptor = (JSONObject)metricDescriptorsArray.get(i);
                    if (!metricDescriptor.get((Object)"metricType").equals(metricType)) continue;
                    String sliceAggregate = CollectUsageTask.getSliceAggregate(metricDescriptor);
                    if (AggregationMethodDescriptor.SliceAggregationMethod.MIN.equals((Object)AggregationMethodDescriptor.SliceAggregationMethod.valueOf(sliceAggregate))) {
                        mergedUsageArray = CollectUsageTask.addMergedMetric(mergedUsageArray, metricType, metricValue.doubleValue() < newMetricValue.doubleValue() ? (Number)metricValue : (Number)newMetricValue);
                        break block5;
                    }
                    if (AggregationMethodDescriptor.SliceAggregationMethod.MAX.equals((Object)AggregationMethodDescriptor.SliceAggregationMethod.valueOf(sliceAggregate))) {
                        mergedUsageArray = CollectUsageTask.addMergedMetric(mergedUsageArray, metricType, metricValue.doubleValue() > newMetricValue.doubleValue() ? (Number)metricValue : (Number)newMetricValue);
                        break block5;
                    }
                    if (AggregationMethodDescriptor.SliceAggregationMethod.AVG.equals((Object)AggregationMethodDescriptor.SliceAggregationMethod.valueOf(sliceAggregate))) {
                        Number average;
                        doubleValue = metricValue.doubleValue();
                        if (doubleValue == (double)Math.round(doubleValue)) {
                            long initialValue = metricValue.longValue() * (long)(totalAggregratedMessages - 1);
                            average = (initialValue + newMetricValue.longValue()) / (long)totalAggregratedMessages;
                        } else {
                            double initialValue = metricValue.doubleValue() * (double)(totalAggregratedMessages - 1);
                            average = (initialValue + newMetricValue.doubleValue()) / (double)totalAggregratedMessages;
                        }
                        mergedUsageArray = CollectUsageTask.addMergedMetric(mergedUsageArray, metricType, average);
                        break block5;
                    }
                    if (AggregationMethodDescriptor.SliceAggregationMethod.SUM.equals((Object)AggregationMethodDescriptor.SliceAggregationMethod.valueOf(sliceAggregate))) {
                        doubleValue = metricValue.doubleValue();
                        Number sum = doubleValue == (double)Math.round(doubleValue) ? (Number)(metricValue.longValue() + newMetricValue.longValue()) : (Number)(metricValue.doubleValue() + newMetricValue.doubleValue());
                        mergedUsageArray = CollectUsageTask.addMergedMetric(mergedUsageArray, metricType, sum);
                        break block5;
                    }
                    if (!AggregationMethodDescriptor.SliceAggregationMethod.LAST.equals((Object)AggregationMethodDescriptor.SliceAggregationMethod.valueOf(sliceAggregate))) break block5;
                    mergedUsageArray = CollectUsageTask.addMergedMetric(mergedUsageArray, metricType, newMetricValue);
                    break block5;
                }
                break;
            }
            if (matchingMetric == null) {
                mergedUsageArray.add((Object)usage);
                continue;
            }
            newMessageUsageArray.remove(matchingMetric);
        }
        for (int i = 0; i < newMessageUsageArray.size(); ++i) {
            mergedUsageArray.add(newMessageUsageArray.get(i));
        }
        mergedMessage.put((Object)"usageList", (Object)mergedUsageArray);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Merged message:");
            try {
                Tr.debug((TraceComponent)tc, (String)mergedMessage.serialize());
            }
            catch (IOException e) {
                Tr.debug((TraceComponent)tc, (String)"failed to serialize the merged message to print to trace");
            }
        }
        return mergedMessage;
    }

    private static String getSliceAggregate(JSONObject metricDescriptor) {
        String sliceAggregate = AggregationMethodDescriptor.SliceAggregationMethod.AVG.toString();
        JSONArray sliceAggregateArray = (JSONArray)metricDescriptor.get((Object)"sliceAggregationMethods");
        if (sliceAggregateArray != null && sliceAggregateArray.size() > 0) {
            sliceAggregate = (String)sliceAggregateArray.get(0);
            if (sliceAggregateArray.size() > 1) {
                ArrayList<String> allAggs = new ArrayList<String>();
                for (int j = 0; j < sliceAggregateArray.size(); ++j) {
                    allAggs.add((String)sliceAggregateArray.get(j));
                }
                if (allAggs.contains(AggregationMethodDescriptor.SliceAggregationMethod.SUM.toString())) {
                    sliceAggregate = AggregationMethodDescriptor.SliceAggregationMethod.SUM.toString();
                } else if (allAggs.contains(AggregationMethodDescriptor.SliceAggregationMethod.AVG.toString())) {
                    sliceAggregate = AggregationMethodDescriptor.SliceAggregationMethod.AVG.toString();
                } else if (allAggs.contains(AggregationMethodDescriptor.SliceAggregationMethod.LAST.toString())) {
                    sliceAggregate = AggregationMethodDescriptor.SliceAggregationMethod.LAST.toString();
                }
            }
        }
        return sliceAggregate;
    }

    private static JSONArray addMergedMetric(JSONArray mergedUsageArray, String metricType, Number metricValue) {
        JSONObject mergedMetric = new JSONObject();
        mergedMetric.put((Object)"metricType", (Object)metricType);
        mergedMetric.put((Object)"metricValue", (Object)metricValue);
        mergedUsageArray.add((Object)mergedMetric);
        return mergedUsageArray;
    }

    private JSONObject popLastMessage() {
        JSONObject lastMessage = null;
        for (JSONObject next : this.queue) {
            if (lastMessage != null && (Long)lastMessage.get((Object)"startTime") >= (Long)next.get((Object)"startTime")) continue;
            lastMessage = next;
        }
        this.queue.remove(lastMessage);
        return lastMessage;
    }

    protected static class RequestUsage
    implements Callable<Usage> {
        protected static final ThreadLocal<RequestUsage> threadRequestUsage = new ThreadLocal();
        private final Product product;

        public RequestUsage(Product product) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("<init>: " + Util.identity(product)));
            }
            this.product = product;
        }

        @Override
        public Usage call() throws Exception {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RequestUsage: " + Util.identity(this.product)));
            }
            threadRequestUsage.set(this);
            Usage usage = this.product.getCurrentUsage();
            threadRequestUsage.remove();
            return usage;
        }
    }
}

