/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.JavaProduct;
import com.ibm.ws.usage.metering.common.MeteringConstants;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.Product;
import com.ibm.ws.usage.metering.common.Util;
import com.ibm.wsspi.usage.metering.Group;
import com.ibm.wsspi.usage.metering.Metric;
import com.ibm.wsspi.usage.metering.MetricCapDescriptor;
import com.ibm.wsspi.usage.metering.MetricDescriptor;
import com.ibm.wsspi.usage.metering.MetricGroupDescriptor;
import com.ibm.wsspi.usage.metering.Usage;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JsonHelper {
    private static final String CLASS_NAME = JsonHelper.class.getName();
    private static final TraceComponent tc = Tr.register(JsonHelper.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");

    public static String buildRegistrationJSON(MeteringMetadata data, List<Product> products) throws IOException {
        String capGroupId;
        boolean isValidCapMetricType;
        List<Group> configGroups;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"buildRegistrationJSON");
        }
        OrderedJSONObject json = new OrderedJSONObject();
        json.put((Object)"hostName", (Object)data.getHostName());
        json.put((Object)"installDirectory", (Object)data.getInstallDirectory());
        json.put((Object)"instanceIdentifier", (Object)data.getInstanceIdentifier());
        json.put((Object)"startTime", (Object)data.getStartTimeNano());
        json.put((Object)"sendTime", (Object)System.nanoTime());
        JSONArray productsArray = new JSONArray();
        for (Product p : products) {
            productsArray.add((Object)JsonHelper.buildProductJSON(p));
        }
        productsArray.add((Object)JsonHelper.buildProductJSON(JavaProduct.getInstance()));
        json.put((Object)"products", (Object)productsArray);
        ArrayList<Group> groups = new ArrayList<Group>();
        String groupString = data.getGroup();
        if (groupString != null && !groupString.equals("") && (configGroups = JsonHelper.parseGroups(groupString)) != null) {
            groups.addAll(configGroups);
        }
        for (int i = products.size() - 1; i >= 0; --i) {
            List<Group> combinedGroups = new ArrayList(groups);
            combinedGroups = products.get(i).getGroups(combinedGroups);
            if (combinedGroups == null) continue;
            groups = new ArrayList<Group>(combinedGroups);
        }
        HashSet<MetricDescriptor> allMetricDescriptors = new HashSet<MetricDescriptor>();
        for (Product p : products) {
            Set<MetricDescriptor> productMetricDescriptors = p.getMetricDescriptors(groups);
            if (productMetricDescriptors == null) continue;
            allMetricDescriptors.addAll(productMetricDescriptors);
        }
        JSONObject psd = (JSONObject)((JSONObject)productsArray.get(0)).get((Object)"productSpecificData");
        if (psd == null) {
            psd = new JSONObject();
            ((JSONObject)productsArray.get(0)).put((Object)"productSpecificData", (Object)psd);
        }
        HashMap<String, String> fullGroupNames = new HashMap<String, String>();
        if (!groups.isEmpty()) {
            JSONArray groupsArray = new JSONArray();
            boolean addedNewGroups = true;
            while (addedNewGroups) {
                addedNewGroups = false;
                for (Group g : groups) {
                    if (fullGroupNames.containsKey(g.getId())) continue;
                    String groupName = g.getName();
                    Map<String, String> translatedGroupNames = g.getTranslatedName();
                    if (translatedGroupNames != null) {
                        groupName = translatedGroupNames.get(Locale.getDefault().toString());
                        if (groupName == null) {
                            groupName = (String)translatedGroupNames.get(Locale.getDefault().getLanguage());
                        }
                        if (groupName == null) {
                            groupName = g.getName();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Could not find a matching translation group name for group " + groupName + " for the Locale: " + Locale.getDefault()));
                            }
                        }
                    }
                    if (g.getParentGroupId() == null) {
                        fullGroupNames.put(g.getId(), groupName);
                        groupsArray.add((Object)JsonHelper.buildGroupJSON(g));
                        addedNewGroups = true;
                        continue;
                    }
                    if (!fullGroupNames.containsKey(g.getParentGroupId())) continue;
                    fullGroupNames.put(g.getId(), (String)fullGroupNames.get(g.getParentGroupId()) + "/" + groupName);
                    groupsArray.add((Object)JsonHelper.buildGroupJSON(g));
                    addedNewGroups = true;
                }
            }
            json.put((Object)"groups", (Object)groupsArray);
            ArrayList groupNameList = new ArrayList(fullGroupNames.values());
            Collator coll = Collator.getInstance(Locale.getDefault());
            coll.setStrength(0);
            Collections.sort(groupNameList, coll);
            StringBuffer allGroupsString = new StringBuffer();
            allGroupsString.append("[");
            for (String groupName : groupNameList) {
                String delim = allGroupsString.length() == 1 ? "" : ", ";
                allGroupsString.append(delim + groupName);
            }
            allGroupsString.append("]");
            psd.put((Object)"Groups", (Object)allGroupsString.toString());
        } else {
            psd.put((Object)"Groups", (Object)"NO_GROUP");
        }
        MetricCapDescriptor metricCapDescriptor = products.get(0).getMetricCapDescriptor();
        boolean bl = isValidCapMetricType = metricCapDescriptor == null;
        if (metricCapDescriptor != null && (capGroupId = metricCapDescriptor.getCapGroupId()) != null) {
            if (fullGroupNames.containsKey(capGroupId)) {
                json.put((Object)"capGroup", (Object)capGroupId);
            } else {
                Tr.warning((TraceComponent)tc, (String)"INVALID_CAP_GROUP_CWWKR0439W", (Object)new Object[]{products.get(0).getName(), capGroupId, fullGroupNames.keySet()});
            }
        }
        JSONArray metricsArray = new JSONArray();
        for (MetricDescriptor metricDescriptor : allMetricDescriptors) {
            metricsArray.add((Object)JsonHelper.buildMetricRegistrationJSONHelper(metricDescriptor, metricCapDescriptor));
            if (isValidCapMetricType || !metricDescriptor.getType().equals(metricCapDescriptor.getCapMetricType())) continue;
            isValidCapMetricType = true;
        }
        if (!isValidCapMetricType) {
            Object[] allMetrics = new String[allMetricDescriptors.size()];
            int i = 0;
            for (MetricDescriptor metricDescriptor : allMetricDescriptors) {
                allMetrics[i] = metricDescriptor.getType();
                ++i;
            }
            Tr.warning((TraceComponent)tc, (String)"INVALID_METRIC_CWWKR0443W", (Object)new Object[]{products.get(0).getName(), metricCapDescriptor.getCapMetricType(), Arrays.toString(allMetrics)});
        }
        json.put((Object)"metrics", (Object)metricsArray);
        String adminURL = data.getAdminUIURL();
        if (adminURL != null) {
            json.put((Object)"adminUiUrl", (Object)adminURL);
        }
        json.put((Object)"operatingSystem", (Object)MeteringConstants.OS_NAME);
        json.put((Object)"operatingSystemVersion", (Object)MeteringConstants.OS_VERSION);
        if (data.logCSV()) {
            data.getLogHelper().writeRegistrationCSV((JSONObject)json);
        }
        if (data.logJSON()) {
            data.getLogHelper().writeJSON(null, (JSONObject)json);
        }
        StringWriter writer = new StringWriter();
        try {
            json.serialize((Writer)writer, true);
        }
        catch (IOException ioex) {
            writer.flush();
            FFDCFilter.processException((Throwable)ioex, (String)(CLASS_NAME + ".buildRegistrationJSON"), (String)"232", (Object[])new Object[]{writer.toString()});
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"buildRegistrationJSON", (Object)(ioex + " : " + writer.toString()));
            }
            throw ioex;
        }
        String jsonString = writer.toString();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildRegistrationJSON", (Object)jsonString);
        }
        return jsonString;
    }

    public static JSONObject createUsageMessage(MeteringMetadata data, Usage primaryUsage, List<Metric> usageMetrics, long startTime, long endTime) {
        Map<String, Object> productUniqueData;
        String envType;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createUsageMessage: startTime=" + startTime + ", endTime=" + endTime));
        }
        OrderedJSONObject usage = new OrderedJSONObject();
        usage.put((Object)"hostName", (Object)data.getHostName());
        usage.put((Object)"installDirectory", (Object)data.getInstallDirectory());
        usage.put((Object)"instanceIdentifier", (Object)data.getInstanceIdentifier());
        String string = envType = primaryUsage != null ? primaryUsage.getEnvironmentType() : null;
        if (envType != null) {
            usage.put((Object)"environmentType", (Object)envType);
        }
        Map<String, Object> map = productUniqueData = primaryUsage != null ? primaryUsage.getProductSpecificData() : null;
        if (productUniqueData != null && !productUniqueData.isEmpty()) {
            usage.put((Object)"productSpecificData", (Object)JsonHelper.buildProductUniqueDataJSON(productUniqueData));
        }
        usage.put((Object)"startTime", (Object)startTime);
        usage.put((Object)"endTime", (Object)endTime);
        JSONArray metricsArray = new JSONArray();
        for (Metric m : usageMetrics) {
            metricsArray.add((Object)JsonHelper.buildMetricJSON(m));
        }
        usage.put((Object)"usageList", (Object)metricsArray);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createUsageMessage", (Object)usage);
        }
        return usage;
    }

    private static OrderedJSONObject buildProductJSON(Product p) {
        Set<String> apars;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("buildProductJSON: " + Util.identity(p)));
        }
        OrderedJSONObject jsonProduct = new OrderedJSONObject();
        String persistentId = p.getPersistentId();
        if (persistentId != null) {
            jsonProduct.put((Object)"persistentId", (Object)persistentId);
        }
        jsonProduct.put((Object)"name", (Object)p.getName());
        jsonProduct.put((Object)"version", (Object)p.getVersion());
        Map<String, Object> productUniqueData = p.getProductSpecificData();
        if (productUniqueData != null && !productUniqueData.isEmpty()) {
            jsonProduct.put((Object)"productSpecificData", (Object)JsonHelper.buildProductUniqueDataJSON(productUniqueData));
        }
        if ((apars = p.getApars()) != null && !apars.isEmpty()) {
            JSONArray aparsArray = new JSONArray();
            aparsArray.addAll(apars);
            jsonProduct.put((Object)"apar", (Object)aparsArray);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildProductJSON", (Object)jsonProduct);
        }
        return jsonProduct;
    }

    private static OrderedJSONObject buildMetricRegistrationJSONHelper(MetricDescriptor metricDescriptor, MetricCapDescriptor metricCapDescriptor) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("buildMetricRegistrationJSONHelper: " + metricDescriptor + ", " + metricCapDescriptor));
        }
        OrderedJSONObject metricJSON = new OrderedJSONObject();
        metricJSON.put((Object)"metricType", (Object)metricDescriptor.getType());
        if (metricDescriptor.getName() != null) {
            metricJSON.put((Object)"name", (Object)metricDescriptor.getName());
        }
        JSONObject nameObject = new JSONObject();
        nameObject.putAll(metricDescriptor.getTranslatedNames());
        metricJSON.put((Object)"translatedName", (Object)nameObject);
        if (metricDescriptor.getUnits() != null) {
            metricJSON.put((Object)"units", (Object)metricDescriptor.getUnits());
        }
        if (metricDescriptor.getTranslatedUnits() != null) {
            JSONObject unitObject = new JSONObject();
            unitObject.putAll(metricDescriptor.getTranslatedUnits());
            metricJSON.put((Object)"translatedUnits", (Object)unitObject);
        }
        if (metricDescriptor.getMinValue() != null) {
            metricJSON.put((Object)"min", (Object)metricDescriptor.getMinValue());
        }
        if (metricDescriptor.getMaxValue() != null) {
            metricJSON.put((Object)"max", (Object)metricDescriptor.getMaxValue());
        }
        if (metricDescriptor.getSliceAggregationMethods() != null) {
            JSONArray slice = new JSONArray();
            slice.addAll(metricDescriptor.getSliceAggregationMethodNames());
            metricJSON.put((Object)"sliceAggregationMethods", (Object)slice);
        }
        if (metricDescriptor.getRangeAggregationMethods() != null) {
            JSONArray range = new JSONArray();
            range.addAll(metricDescriptor.getRangeAggregationMethodNames());
            metricJSON.put((Object)"rangeAggregationMethods", (Object)range);
        }
        JSONArray groupAggregation = new JSONArray();
        if (metricDescriptor.getGroupDescriptors() != null) {
            for (MetricGroupDescriptor groupDescriptor : metricDescriptor.getGroupDescriptors()) {
                OrderedJSONObject anotherGroupAggregation = JsonHelper.buildGroupAggregationHelper(groupDescriptor);
                if (anotherGroupAggregation == null) continue;
                groupAggregation.add((Object)anotherGroupAggregation);
            }
        }
        if (!groupAggregation.isEmpty()) {
            metricJSON.put((Object)"groupAggregations", (Object)groupAggregation);
        }
        if (metricDescriptor.getDefaultValue() != null) {
            metricJSON.put((Object)"defaultValue", (Object)metricDescriptor.getDefaultValue());
        }
        if (metricCapDescriptor != null && metricDescriptor.getType().equals(metricCapDescriptor.getCapMetricType())) {
            metricJSON.put((Object)metricCapDescriptor.getCapAlgorithm(), (Object)metricCapDescriptor.getCap());
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("buildMetricRegistrationJSONHelper: " + metricJSON));
        }
        return metricJSON;
    }

    private static OrderedJSONObject buildGroupAggregationHelper(MetricGroupDescriptor groupDescriptor) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("buildGroupAggregationHelper: " + groupDescriptor));
        }
        OrderedJSONObject groupAggregationObject = new OrderedJSONObject();
        boolean somethingToPut = false;
        if (groupDescriptor.getGroupID() != null) {
            groupAggregationObject.put((Object)"groupId", (Object)groupDescriptor.getGroupID());
            somethingToPut = true;
        }
        if (groupDescriptor.getSliceAggregationMethods() != null) {
            JSONArray slice = new JSONArray();
            slice.addAll(groupDescriptor.getSliceAggregationMethodNames());
            groupAggregationObject.put((Object)"sliceAggregationMethods", (Object)slice);
            somethingToPut = true;
        }
        if (groupDescriptor.getRangeAggregationMethods() != null) {
            JSONArray range = new JSONArray();
            range.addAll(groupDescriptor.getRangeAggregationMethodNames());
            groupAggregationObject.put((Object)"rangeAggregationMethods", (Object)range);
            somethingToPut = true;
        }
        if (groupDescriptor.getGroupRollUpMethod() != null) {
            groupAggregationObject.put((Object)"rollUp", (Object)groupDescriptor.getGroupRollUpMethod());
            somethingToPut = true;
        }
        if (somethingToPut) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("buildGroupAggregationHelper: " + groupAggregationObject));
            }
            return groupAggregationObject;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("buildGroupAggregationHelper: " + null));
        }
        return null;
    }

    public static OrderedJSONObject buildMetricJSON(Metric m) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("buildMetricJSON: " + Util.identity(m)));
        }
        OrderedJSONObject jsonMetric = new OrderedJSONObject();
        jsonMetric.put((Object)"metricType", (Object)m.getMetricType());
        jsonMetric.put((Object)"metricValue", (Object)m.getMetricValue());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildMetricJSON", (Object)jsonMetric);
        }
        return jsonMetric;
    }

    private static OrderedJSONObject buildGroupJSON(Group g) {
        String parentGroupId;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"buildGroupJSON: ");
        }
        OrderedJSONObject jsonGroup = new OrderedJSONObject();
        jsonGroup.put((Object)"id", (Object)g.getId());
        jsonGroup.put((Object)"name", (Object)g.getName());
        Map<String, String> translatedName = g.getTranslatedName();
        if (translatedName != null) {
            JSONObject nameObject = new JSONObject();
            nameObject.putAll(translatedName);
            jsonGroup.put((Object)"translatedName", (Object)nameObject);
        }
        if ((parentGroupId = g.getParentGroupId()) != null) {
            jsonGroup.put((Object)"parentGroupId", (Object)parentGroupId);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildGroupJSON", (Object)jsonGroup);
        }
        return jsonGroup;
    }

    public static String extractErrorStreamMessages(JSONObject errorJSON) {
        String detailsKey;
        Object detailsValue;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("extractErrorStreamMessages: " + Util.identity(errorJSON)));
        }
        StringBuffer message = new StringBuffer();
        String messageKey = "message";
        Object messageValue = errorJSON.get((Object)"message");
        if (messageValue != null) {
            message.append((String)messageValue);
        }
        if ((detailsValue = errorJSON.get((Object)(detailsKey = "details"))) != null && detailsValue instanceof JSONArray) {
            JSONArray detailsArray = (JSONArray)detailsValue;
            for (int i = 0; i < detailsArray.size(); ++i) {
                JSONObject detailJSON;
                Object detail = detailsArray.get(i);
                if (detail == null || !(detail instanceof JSONObject) || (messageValue = (detailJSON = (JSONObject)detail).get((Object)"message")) == null) continue;
                message.append(", ");
                message.append((String)messageValue);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("extractErrorStreamMessages: " + message.toString()));
        }
        return message.toString();
    }

    private static OrderedJSONObject buildProductUniqueDataJSON(Map<String, Object> productUniqueData) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"buildProductUniqueDataJSON");
        }
        OrderedJSONObject productUniqueDataJSON = new OrderedJSONObject();
        for (Map.Entry<String, Object> uniqueDataEntry : productUniqueData.entrySet()) {
            String key = uniqueDataEntry.getKey();
            Object value = uniqueDataEntry.getValue();
            if (value instanceof Collection) {
                StringBuffer buf = new StringBuffer();
                buf.append('[');
                for (Object feature : (Collection)value) {
                    if (buf.length() > 1) {
                        buf.append(", ");
                    }
                    buf.append(feature);
                }
                buf.append(']');
                String valueString = buf.toString();
                productUniqueDataJSON.put((Object)key, (Object)valueString);
                continue;
            }
            productUniqueDataJSON.put((Object)key, value);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildProductUniqueDataJSON", (Object)productUniqueDataJSON);
        }
        return productUniqueDataJSON;
    }

    private static List<Group> parseGroups(String groupString) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("parseGroups: " + groupString));
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        HashSet<String> groupNames = new HashSet<String>();
        String parentGroupId = null;
        String validateRegex = "[A-Za-z0-9:./_-]+";
        String[] groupArray = groupString.split("/");
        for (int i = 0; i < groupArray.length; ++i) {
            String groupName = groupArray[i].trim();
            String groupId = groupName.replaceAll(" ", "__");
            if (groupName.length() == 0) continue;
            if (!groupNames.add(groupName)) {
                Tr.warning((TraceComponent)tc, (String)"GROUP_DUPLICATE_NAME_CWWKR0419W", groupNames);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"parseGroups: null");
                }
                return null;
            }
            if (!groupId.matches(validateRegex)) {
                Tr.warning((TraceComponent)tc, (String)"GROUP_INVALID_CHARACTER_CWWKR0416W", (Object)groupName);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"parseGroups: null");
                }
                return null;
            }
            if (groupName.startsWith("WAS_")) {
                Tr.warning((TraceComponent)tc, (String)"GROUP_RESERVED_NAME_CWWKR0417W", (Object)groupName);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"parseGroups: null");
                }
                return null;
            }
            Group group = new Group(groupId, groupName);
            if (parentGroupId != null) {
                group.setParentGroupId(parentGroupId);
            }
            groups.add(group);
            parentGroupId = groupId;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseGroups", groups);
        }
        return Collections.unmodifiableList(groups);
    }
}

