/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.usage.metering.Metric;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public abstract class LogHelper {
    private static final String CLASS_NAME = LogHelper.class.getName();
    private static final TraceComponent tc = Tr.register(LogHelper.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static final String METERING_LOG_DIRECTORY = "metering";
    private static final String LOG_NAME_PREFIX = "metering_";
    private static final String CSV_USAGE_LOG_NAME_PREFIX = "metering_usage_";
    private static final String CSV_REGISTRATION_LOG_NAME_PREFIX = "metering_registration_";
    private static final String REGISTRATION_CSV_HEADER = "timestamp,hostName,installDirectory,instanceIdentifier,startTimeNano";
    private ArrayList<String> sortedMetrics = null;

    private File getFile(String filename) throws IOException {
        File logDirectory;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getFile: filename=" + filename));
        }
        String logLocation = this.getLogLocation() + File.separatorChar + METERING_LOG_DIRECTORY;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("LogHelper: logLocation: " + logLocation));
        }
        if (!(logDirectory = new File(logLocation)).exists() && !logDirectory.mkdirs() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("LogHelper: Failed to create log directory: " + logLocation));
        }
        File file = new File(logLocation, filename);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFile");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRegistrationCSV(JSONObject json) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeRegistrationCSV");
        }
        long currentTime = System.currentTimeMillis();
        PrintWriter writer = null;
        Class<LogHelper> clazz = LogHelper.class;
        synchronized (LogHelper.class) {
            File registrationCSV;
            try {
                registrationCSV = this.getFile(CSV_REGISTRATION_LOG_NAME_PREFIX + this.getDateSuffix(currentTime) + ".csv");
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".writeRegistrationCSV"), (String)"81");
                Tr.warning((TraceComponent)tc, (String)"LOGGING_EXCEPTION_CWWKR0444W", (Object)e);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeRegistrationCSV");
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return;
            }
            if (!registrationCSV.exists()) {
                try {
                    if (!registrationCSV.createNewFile() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("LogHelper: Failed to create log file: " + registrationCSV.getName()));
                    }
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(registrationCSV, true), "UTF-8"));
                    writer.println(REGISTRATION_CSV_HEADER);
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".writeRegistrationCSV"), (String)"81");
                    Tr.warning((TraceComponent)tc, (String)"LOGGING_EXCEPTION_CWWKR0444W", (Object)e);
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"writeRegistrationCSV");
                    }
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return;
                }
            }
            if (writer == null) {
                try {
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(registrationCSV, true), "UTF-8"));
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".writeRegistrationCSV"), (String)"91");
                    Tr.warning((TraceComponent)tc, (String)"LOGGING_EXCEPTION_CWWKR0444W", (Object)e);
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"writeRegistrationCSV");
                    }
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("LogHelper: writing registration data to: " + registrationCSV.getAbsolutePath()));
            }
            String registrationData = this.formatTimestampCSV(currentTime) + "," + json.get((Object)"hostName") + "," + json.get((Object)"installDirectory") + "," + json.get((Object)"instanceIdentifier") + "," + json.get((Object)"startTime");
            writer.println(registrationData);
            writer.flush();
            writer.close();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (this.sortedMetrics == null) {
                this.sortedMetrics = new ArrayList();
                JSONArray metrics = (JSONArray)json.get((Object)"metrics");
                for (JSONObject metric : metrics) {
                    this.sortedMetrics.add((String)metric.get((Object)"metricType"));
                }
                Collections.sort(this.sortedMetrics);
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeRegistrationCSV");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void writeUsageCSV(List<Metric> allProductMetrics, long startTime, long endTime) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeUsageCSV");
        }
        PrintWriter writer = null;
        Class<LogHelper> clazz = LogHelper.class;
        synchronized (LogHelper.class) {
            void var12_16;
            StringBuffer sb;
            File usageCSV;
            try {
                usageCSV = this.getFile(CSV_USAGE_LOG_NAME_PREFIX + this.getDateSuffix(startTime) + ".csv");
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".writeUsageCSV"), (String)"160");
                Tr.warning((TraceComponent)tc, (String)"LOGGING_EXCEPTION_CWWKR0444W", (Object)e);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeUsageCSV");
                }
                // ** MonitorExit[clazz] (shouldn't be in output)
                return;
            }
            if (this.sortedMetrics == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("LogHelper: Could not write usage to CSV because sortedMetrics was null. (Registration hasn't processed sortedMetric yet). Skipping logging usage for starting time: " + startTime));
                }
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeUsageCSV");
                }
                // ** MonitorExit[clazz] (shouldn't be in output)
                return;
            }
            if (!usageCSV.exists()) {
                try {
                    if (!usageCSV.createNewFile() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("LogHelper: Failed to create log file: " + usageCSV.getName()));
                    }
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(usageCSV, true), "UTF-8"));
                    sb = new StringBuffer();
                    sb.append("timestamp,startTime,endTime");
                    for (String string : this.sortedMetrics) {
                        sb.append("," + string);
                    }
                    writer.println(sb.toString());
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".writeUsageCSV"), (String)"126");
                    Tr.warning((TraceComponent)tc, (String)"LOGGING_EXCEPTION_CWWKR0444W", (Object)e);
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"writeUsageCSV");
                    }
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return;
                }
            }
            if (writer == null) {
                try {
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(usageCSV, true), "UTF-8"));
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".writeUsageCSV"), (String)"135");
                    Tr.warning((TraceComponent)tc, (String)"LOGGING_EXCEPTION_CWWKR0444W", (Object)e);
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"writeUsageCSV");
                    }
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("LogHelper: writing usage data to: " + usageCSV.getAbsolutePath()));
            }
            sb = new StringBuffer();
            sb.append(this.formatTimestampCSV(System.currentTimeMillis()) + "," + startTime + "," + endTime);
            String[] values = new String[this.sortedMetrics.size()];
            for (Metric m : allProductMetrics) {
                int index = this.sortedMetrics.indexOf(m.getMetricType());
                if (index < 0) continue;
                values[index] = m.getMetricValue().toString();
            }
            boolean bl = false;
            while (var12_16 < values.length) {
                sb.append("," + (values[var12_16] != null ? values[var12_16] : ""));
                ++var12_16;
            }
            writer.println(sb.toString());
            writer.flush();
            writer.close();
            // ** MonitorExit[clazz] (shouldn't be in output)
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeUsageCSV");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJSON(JSONArray jsonArray, JSONObject jsonObject) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeJSON");
        }
        PrintWriter writer = null;
        Class<LogHelper> clazz = LogHelper.class;
        synchronized (LogHelper.class) {
            File jsonFile;
            try {
                jsonFile = this.getFile(LOG_NAME_PREFIX + this.getDateSuffix(System.currentTimeMillis()) + ".json");
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".writeJSON"), (String)"160");
                Tr.warning((TraceComponent)tc, (String)"LOGGING_EXCEPTION_CWWKR0444W", (Object)e);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeJSON");
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            try {
                String line = "";
                if (!jsonFile.exists()) {
                    if (!jsonFile.createNewFile() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("LogHelper: Failed to create log file: " + jsonFile.getName()));
                    }
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile, true), "UTF-8"));
                    writer.println("[");
                } else {
                    RandomAccessFile file = new RandomAccessFile(jsonFile, "rw");
                    long length = file.length();
                    file.setLength(length - 1L);
                    file.close();
                    line = line + ",";
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile, true), "UTF-8"));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("LogHelper: writing json data to: " + jsonFile.getAbsolutePath()));
                }
                if (jsonArray != null) {
                    writer.println(line + jsonArray.serialize());
                }
                if (jsonObject != null) {
                    writer.println(line + jsonObject.serialize());
                }
                writer.append("]");
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".writeJSON"), (String)"213");
                Tr.warning((TraceComponent)tc, (String)"LOGGING_EXCEPTION_CWWKR0444W", (Object)e);
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeJSON");
            }
            return;
        }
    }

    private String getDateSuffix(long timeMillis) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDateSuffix");
        }
        Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        utcCalendar.setTimeInMillis(timeMillis);
        int monthInt = utcCalendar.get(2) + 1;
        String month = (monthInt < 10 ? "0" : "") + monthInt;
        String dateSuffix = utcCalendar.get(1) + "_" + month;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDateSuffix: " + dateSuffix));
        }
        return dateSuffix;
    }

    private String formatTimestampCSV(long timeMillis) {
        String formattedTime;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("formatTimestampCSV: " + timeMillis));
        }
        if ((formattedTime = this.formatTimestamp(timeMillis)).contains(",")) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removing commas from: " + formattedTime));
            }
            formattedTime = formattedTime.replaceAll(", ", " ");
            formattedTime = formattedTime.replaceAll(",", " ");
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("formatTimestampCSV: " + formattedTime));
        }
        return formattedTime;
    }

    protected abstract String formatTimestamp(long var1);

    protected abstract String getLogLocation();
}

