/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.LogHelper;
import com.ibm.ws.usage.metering.common.MeteringConstants;
import com.ibm.ws.usage.metering.common.MeteringContextImpl;
import com.ibm.ws.usage.metering.common.MetricImpl;
import com.ibm.ws.usage.metering.common.ServerEnvironmentUtil;
import com.ibm.ws.usage.metering.common.exceptions.MeteringErrorCode;
import com.ibm.ws.usage.metering.common.exceptions.SSLConfigException;
import com.ibm.ws.usage.metering.common.exceptions.ValidationException;
import com.ibm.wsspi.usage.metering.MeteringContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class MeteringMetadata {
    private static final String CLASS_NAME = MeteringMetadata.class.getName();
    private static final TraceComponent tc = Tr.register(MeteringMetadata.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static final String METERING_API_STR = "/meteringapi";
    private Map<String, Object> config;
    private URL registrationURL;
    private URL registrationURL2;
    private URL usageURL;
    private URL usageURL2;
    private HttpHost proxy;
    private CloseableHttpClient closableHttpClient = null;
    private boolean dirtyCache = false;
    private String token = "";
    private long tokenExpirationTimestamp = 0L;
    private boolean noTokenService = false;
    private MeteringContext meteringContext;
    private String lastFailureMsg = null;
    private int lastFailureCount = 0;
    private static final int CONNECTION_TIMEOUT = 120000;
    private volatile boolean isValid;
    private long usageAdjustment = -1L;
    private boolean resetUsageAdjustment = false;

    protected void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    protected Object getProperty(MeteringConstants.Property prop) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getProperty: " + (Object)((Object)prop) + " : '" + this.config.get(prop.toString()) + "'"));
        }
        return this.config.get(prop.toString());
    }

    protected boolean isValid() {
        return this.isValid;
    }

    protected void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    protected long getUsageAdjustment() {
        return this.usageAdjustment;
    }

    protected void setUsageAdjustment(long usageAdjustment) {
        this.usageAdjustment = usageAdjustment;
    }

    protected boolean getResetUsageAdjustment() {
        return this.resetUsageAdjustment;
    }

    protected void setResetUsageAdjustment(boolean resetUsageAdjustment) {
        this.resetUsageAdjustment = resetUsageAdjustment;
    }

    private synchronized CloseableHttpClient createConnection() throws SSLConfigException, IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConnection");
        }
        if (this.dirtyCache || this.closableHttpClient == null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting a new client connection. dirtyCache=" + this.dirtyCache));
            }
            this.closeHttpClient();
            try {
                HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
                httpClientBuilder = this.setupProxy(httpClientBuilder);
                httpClientBuilder = this.setSSLConnectionSocketFactory(httpClientBuilder);
                RequestConfig config = RequestConfig.custom().setConnectTimeout(120000).setConnectionRequestTimeout(120000).setSocketTimeout(120000).build();
                httpClientBuilder.setDefaultRequestConfig(config);
                this.closableHttpClient = httpClientBuilder.build();
                this.dirtyCache = false;
            }
            catch (ValidationException ve) {
                FFDCFilter.processException((Throwable)ve, (String)(CLASS_NAME + ".createConnection"), (String)"79", (Object)this);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createConnection : " + this.closableHttpClient));
        }
        return this.closableHttpClient;
    }

    protected synchronized CloseableHttpResponse executeRequest(HttpUriRequest httpPost) throws SSLConfigException, IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("executeRequest : " + httpPost));
        }
        CloseableHttpClient client = this.createConnection();
        CloseableHttpResponse response = null;
        try {
            response = client.execute(httpPost);
        }
        catch (Throwable t) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("executeRequest : retry after failure : " + t));
            }
            this.dirtyCache = true;
            client = this.createConnection();
            response = client.execute(httpPost);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("executeRequest : " + response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getToken(boolean forceTokenRefresh, boolean logCachedFailures) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getToken : refresh=" + forceTokenRefresh + ", logCachedFailures=" + logCachedFailures));
        }
        if (this.noTokenService) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getToken : null (ICP 2.1 - no token service)");
            }
            return null;
        }
        long currentTime = System.currentTimeMillis();
        long currentTimePlusFifteen = currentTime + 900000L;
        if (currentTimePlusFifteen > this.tokenExpirationTimestamp) {
            forceTokenRefresh = true;
        }
        if (this.token == null || this.token.length() == 0 || forceTokenRefresh || this.lastFailureMsg != null) {
            CloseableHttpResponse response = null;
            try {
                URL targetURL = this.getTokenURL("iam-token/oidc/token");
                HttpPost httpPost = new HttpPost(targetURL.toString());
                StringEntity in = new StringEntity("grant_type=urn%3Aibm%3Aparams%3Aoauth%3Agrant-type%3Aapikey&apikey=" + this.getAPIKey() + "&response_type=cloud_iam");
                in.setContentEncoding("UTF-8");
                in.setContentType("application/x-www-form-urlencoded");
                httpPost.setEntity((HttpEntity)in);
                response = this.executeRequest((HttpUriRequest)httpPost);
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode == 200) {
                    InputStream inputStream = response.getEntity().getContent();
                    InputStreamReader reader = null;
                    reader = new InputStreamReader(inputStream, "UTF-8");
                    JSONObject responseJson = JSONObject.parse((Reader)reader);
                    String newtoken = (String)responseJson.get((Object)"access_token");
                    Long expireSeconds = (Long)responseJson.get((Object)"expires_in");
                    Long expiration = (Long)responseJson.get((Object)"expiration");
                    String newtype = (String)responseJson.get((Object)"token_type");
                    if (newtype != null && newtoken != null) {
                        this.token = newtype + " " + newtoken;
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("new token obtained of type " + newtype));
                        }
                    } else if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("returned type or token was null (" + newtype + ", " + this.token + "); re-using prior value"));
                    }
                    if (expireSeconds != null) {
                        this.tokenExpirationTimestamp = currentTime + expireSeconds * 1000L;
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Token expires in " + expireSeconds + " seconds (" + this.tokenExpirationTimestamp + ")"));
                        }
                        if (expiration != null && isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("expiration returned as " + expiration));
                        }
                    } else if (expiration != null) {
                        this.tokenExpirationTimestamp = expiration * 1000L;
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Token expiration is " + this.tokenExpirationTimestamp));
                        }
                    } else {
                        this.tokenExpirationTimestamp = 0L;
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Expected to find expires_in or expiration from the token service, but none was found. We will get a new token on every request.");
                        }
                    }
                    this.clearGetTokenFailures();
                } else if (responseCode == 404 && targetURL.toString().contains(":31443")) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No token service on ICP 2.1; will skip obtaining token");
                    }
                    this.clearGetTokenFailures();
                    this.noTokenService = true;
                    this.token = null;
                } else {
                    this.logGetTokenFailure(responseCode + " : " + response.getStatusLine().getReasonPhrase(), logCachedFailures);
                }
            }
            catch (SSLHandshakeException sslex) {
                this.flushGetTokenFailures();
                FFDCFilter.processException((Throwable)sslex, (String)(CLASS_NAME + ".getToken"), (String)"202", (Object)this);
                Tr.error((TraceComponent)tc, (String)"TOKEN_FAILURE_CWWKR0418E", (Object)new Object[]{"IBM Cloud Private Metering", sslex.toString()});
                this.token = "";
            }
            catch (HttpHostConnectException hce) {
                this.logGetTokenFailure(hce.toString(), logCachedFailures);
            }
            catch (ConnectTimeoutException cte) {
                this.logGetTokenFailure(cte.toString(), logCachedFailures);
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getToken"), (String)"258", (Object)this);
                this.logGetTokenFailure(e.toString(), logCachedFailures);
                this.token = "";
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException sslex) {}
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken : " + (this.token == null ? "null" : Integer.valueOf(this.token.length()))));
        }
        return this.token;
    }

    public String getTokenFailure() {
        return this.lastFailureMsg;
    }

    private void logGetTokenFailure(String failure, boolean logCachedFailures) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("logGetTokenFailure : " + failure + ", " + logCachedFailures));
        }
        if (failure.equals(this.lastFailureMsg)) {
            ++this.lastFailureCount;
            if (logCachedFailures) {
                String warning = failure + " (x" + this.lastFailureCount + ")";
                Tr.warning((TraceComponent)tc, (String)"TOKEN_FAILURE_CWWKR0441W", (Object)new Object[]{"IBM Cloud Private Metering", warning});
                this.lastFailureCount = 0;
            }
        } else {
            String warning = this.lastFailureCount > 0 ? this.lastFailureMsg + " (x" + this.lastFailureCount + "), " + failure : failure;
            Tr.warning((TraceComponent)tc, (String)"TOKEN_FAILURE_CWWKR0441W", (Object)new Object[]{"IBM Cloud Private Metering", warning});
            this.lastFailureMsg = failure;
            this.lastFailureCount = 0;
        }
    }

    private void flushGetTokenFailures() {
        if (this.lastFailureCount > 0) {
            String warning = this.lastFailureMsg + " (x" + this.lastFailureCount + ")";
            Tr.warning((TraceComponent)tc, (String)"TOKEN_FAILURE_CWWKR0441W", (Object)new Object[]{"IBM Cloud Private Metering", warning});
            this.lastFailureCount = 0;
        }
        this.lastFailureMsg = null;
    }

    private void clearGetTokenFailures() {
        if (this.lastFailureMsg != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("clearGetTokenFailures : " + this.lastFailureMsg + ", " + this.lastFailureCount));
            }
            this.lastFailureMsg = null;
            this.lastFailureCount = 0;
        }
    }

    protected synchronized void closeHttpClient() {
        if (this.closableHttpClient != null) {
            try {
                this.closableHttpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void validate() throws ValidationException {
        String url = (String)this.getProperty(MeteringConstants.Property.URL);
        if (url == null || url.isEmpty()) {
            throw new ValidationException(MeteringErrorCode.REGISTRATOR_MISSING_URL);
        }
        if (this.registrationURL == null || !this.isValid) {
            this.registrationURL = this.getURL(url, "api/startup/", true);
            this.registrationURL2 = this.getURL(url, "api/startup/", false);
        }
        if (this.usageURL == null || !this.isValid) {
            this.usageURL = this.getURL(url, "api/usage/", true);
            this.usageURL2 = this.getURL(url, "api/usage/", false);
        }
        this.getProxy();
        String apiKey = this.getAPIKey();
        if (apiKey == null || apiKey.isEmpty()) {
            throw new ValidationException(MeteringErrorCode.REGISTRATOR_MISSING_APIKEY);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("validate: url=" + url));
        }
        this.isValid = true;
    }

    private URL getURL(String urlString, String path, boolean icp3) throws ValidationException {
        urlString = this.removeTrailingSlash(urlString);
        int colonIndex = urlString.lastIndexOf(":");
        int slashIndex = urlString.lastIndexOf("/");
        boolean subdomain = slashIndex > colonIndex;
        boolean meteringapi = urlString.endsWith(METERING_API_STR);
        if (!icp3 && meteringapi) {
            urlString = urlString.substring(0, urlString.length() - METERING_API_STR.length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(urlString);
        if (icp3 && !meteringapi && !subdomain) {
            sb.append(METERING_API_STR);
        }
        sb.append(path.startsWith("/") ? "" : "/").append(path);
        return this.getURL(sb);
    }

    private URL getTokenURL(String path) throws ValidationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTokenURL");
        }
        String urlString = (String)this.getProperty(MeteringConstants.Property.URL);
        urlString = this.removeTrailingSlash(urlString);
        int colonIndex = urlString.lastIndexOf(":");
        int slashIndex = urlString.lastIndexOf("/");
        if (slashIndex > colonIndex) {
            urlString = urlString.substring(0, slashIndex);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(urlString);
        sb.append(path.startsWith("/") ? "" : "/").append(path);
        URL tokenURL = this.getURL(sb);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokenURL: " + tokenURL));
        }
        return tokenURL;
    }

    private URL getURL(StringBuilder sb) throws ValidationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getURL: " + sb));
        }
        String urlString = sb.toString();
        urlString = this.removeTrailingSlash(urlString);
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new ValidationException(MeteringErrorCode.REGISTRATOR_INVALID_URL);
        }
        if (!"https".equals(url.getProtocol())) {
            throw new ValidationException(MeteringErrorCode.REGISTRATOR_URL_PROTOCOL_NOT_HTTPS);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getURL: " + url));
        }
        return url;
    }

    private HttpClientBuilder setupProxy(HttpClientBuilder httpClientBuilder) throws ValidationException {
        HttpHost proxy;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupProxy");
        }
        if ((proxy = this.getProxy()) != null) {
            httpClientBuilder.setProxy(proxy);
            httpClientBuilder = this.setProxyAuthorization(httpClientBuilder, proxy.getHostName(), proxy.getPort());
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProxy: " + proxy));
        }
        return httpClientBuilder;
    }

    private HttpHost getProxy() throws ValidationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProxy");
        }
        if (this.proxy == null || !this.isValid) {
            URL proxyUrl = null;
            String proxyUrlString = (String)this.getProperty(MeteringConstants.Property.PROXY_URL);
            if (proxyUrlString != null && !proxyUrlString.isEmpty()) {
                proxyUrlString = this.removeTrailingSlash(proxyUrlString);
                try {
                    proxyUrl = new URL(proxyUrlString);
                    int port = proxyUrl.getPort();
                    if (port == -1) {
                        port = proxyUrl.getDefaultPort();
                    }
                    this.proxy = new HttpHost(proxyUrl.getHost(), port);
                }
                catch (MalformedURLException e) {
                    throw new ValidationException(MeteringErrorCode.REGISTRATOR_INVALID_PROXY_URL);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProxy: " + this.proxy));
        }
        return this.proxy;
    }

    protected String decode(String password) {
        String decoded = password;
        if (password != null && PasswordUtil.isEncrypted((String)password)) {
            try {
                decoded = PasswordUtil.decode((String)password);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".decode"), (String)"391", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("failed to decode property : " + ex));
                }
                decoded = null;
            }
        }
        return decoded;
    }

    private HttpClientBuilder setProxyAuthorization(HttpClientBuilder httpClientBuilder, String host, int port) throws ValidationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setProxyAuthorization");
        }
        String proxyUser = (String)this.getProperty(MeteringConstants.Property.PROXY_USER);
        String actualPassword = this.getProxyPassword();
        if (proxyUser != null && actualPassword != null && !proxyUser.isEmpty() && !actualPassword.isEmpty()) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"proxy user and password not null");
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"obtained proxy user and password");
            }
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUser, actualPassword));
            httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProxyAuthorization");
        }
        return httpClientBuilder;
    }

    private String removeTrailingSlash(String urlString) {
        if (urlString.endsWith("/")) {
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        return urlString;
    }

    protected String getGroup() {
        return (String)this.getProperty(MeteringConstants.Property.GROUP);
    }

    public boolean logCSV() {
        String logData = (String)this.getProperty(MeteringConstants.Property.LOG_DATA);
        return logData != null && (logData.equals("csv") || logData.equals("all"));
    }

    public boolean logJSON() {
        String logData = (String)this.getProperty(MeteringConstants.Property.LOG_DATA);
        return logData != null && (logData.equals("json") || logData.equals("all"));
    }

    public String getHostName() {
        return ServerEnvironmentUtil.getServerHostName();
    }

    public URL getRegistrationURL(String token) {
        if (token == null) {
            return this.registrationURL2;
        }
        return this.registrationURL;
    }

    public URL getUsageURL(String token) {
        if (token == null) {
            return this.usageURL2;
        }
        return this.usageURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String getDockerContainerIdFromFilesystem() {
        isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && MeteringMetadata.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)MeteringMetadata.tc, (String)"getDockerContainerIdFromFilesystem");
        }
        containerId = null;
        cgroupFileLocation = File.separator + "proc" + File.separator + "self" + File.separator + "cgroup";
        cgroup = new File(cgroupFileLocation);
        if (cgroup.exists()) {
            is = null;
            buf = null;
            try {
                is = new FileInputStream(cgroup);
                buf = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                line = buf.readLine();
                while (line != null && containerId == null) {
                    index = line.indexOf("/docker/");
                    if (index > 0) {
                        if (isTraceOn && MeteringMetadata.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)MeteringMetadata.tc, (String)("Found /docker/ on line " + line));
                        }
                        if (line.length() >= index + 8 + 64) {
                            containerId = line.substring(index + 7, index + 8 + 64);
                        } else if (isTraceOn && MeteringMetadata.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)MeteringMetadata.tc, (String)"Couldn't get the container id from the line with /docker/");
                        }
                    }
                    line = buf.readLine();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(MeteringMetadata.CLASS_NAME + ".getDockerContainerIdFromFilesystem"), (String)"387", (Object)this);
                if (!isTraceOn || !MeteringMetadata.tc.isDebugEnabled()) ** GOTO lbl43
                Tr.debug((TraceComponent)MeteringMetadata.tc, (String)("Failed to lookup the docker container id.  Exception was: " + e.getMessage()));
            }
            finally {
                try {
                    if (buf != null) {
                        buf.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException var7_10) {}
            }
        } else if (isTraceOn && MeteringMetadata.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)MeteringMetadata.tc, (String)("Files " + cgroupFileLocation + " : doesn't exist"));
        }
lbl43:
        // 6 sources

        if (isTraceOn && MeteringMetadata.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)MeteringMetadata.tc, (String)("getDockerContainerIdFromFilesystem: " + containerId));
        }
        return containerId;
    }

    public MeteringContext getMeteringContext() {
        MeteringContext context;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMeteringContext");
        }
        if ((context = this.meteringContext) == null) {
            context = new MeteringContextImpl();
            context.put("com.ibm.wsspi.usage.metering.hostName", ServerEnvironmentUtil.getRealServerHostName());
            context.put("com.ibm.wsspi.usage.metering.reportedHostName", ServerEnvironmentUtil.getServerHostName());
            context.put("com.ibm.wsspi.usage.metering.instanceIdentifier", this.getInstanceIdentifier());
            String optionalMetrics = this.scrubOptionalMetrics();
            if (optionalMetrics != null) {
                context.put("com.ibm.wsspi.usage.metering.configuredOptionaMetrics", optionalMetrics);
            }
            this.meteringContext = context;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getMeteringContext : " + context));
        }
        return context;
    }

    private String scrubOptionalMetrics() {
        String dirtyOptionalMetrics;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"scrubOptionalMetrics");
        }
        if ((dirtyOptionalMetrics = this.getOptionalMetricConfiguration()) == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"scrubOptionalMetrics: optionalMetrics Not Configured");
            }
            return null;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Starting optionalMetrics String: " + dirtyOptionalMetrics));
        }
        String cleanOptionalMetrics = "";
        if (dirtyOptionalMetrics.trim().isEmpty()) {
            cleanOptionalMetrics = "NONE";
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("scrubOptionalMetrics: " + cleanOptionalMetrics));
            }
            return cleanOptionalMetrics;
        }
        List<String> metrics = Arrays.asList(dirtyOptionalMetrics.split(","));
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("metrics: " + metrics));
        }
        if (metrics.isEmpty()) {
            cleanOptionalMetrics = "NONE";
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("scrubOptionalMetrics: " + cleanOptionalMetrics));
            }
            return cleanOptionalMetrics;
        }
        ArrayList<Object> cleanedMetrics = new ArrayList<Object>();
        boolean hasNone = false;
        boolean hasAll = false;
        boolean hasSome = false;
        for (String metric : metrics) {
            String temp = metric.trim().toUpperCase();
            if (temp.isEmpty()) continue;
            if (temp.equals("ALL")) {
                hasAll = true;
            } else if (temp.equals("NONE")) {
                hasNone = true;
            } else {
                hasSome = true;
            }
            if (cleanedMetrics.contains(temp)) continue;
            cleanedMetrics.add(temp);
        }
        if (hasSome && (hasAll || hasNone)) {
            String specialValues = hasAll && hasNone ? "ALL & NONE" : (hasAll ? "ALL" : "NONE");
            Tr.warning((TraceComponent)tc, (String)"INVALID_METRIC_COMBINATION_CWWKR0446W", (Object)specialValues);
        } else if (hasAll && hasNone) {
            Tr.warning((TraceComponent)tc, (String)"INVALID_METRIC_COMBINATION_CWWKR0446W", (Object)"NONE");
        }
        if (cleanedMetrics.isEmpty()) {
            cleanOptionalMetrics = "NONE";
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("scrubOptionalMetrics: " + cleanOptionalMetrics));
            }
            return cleanOptionalMetrics;
        }
        ArrayList<MetricImpl.Type> METRIC_TYPES = new ArrayList<MetricImpl.Type>(Arrays.asList(MetricImpl.Type.values()));
        ArrayList<String> wasRequiredMetricTypes = new ArrayList<String>();
        for (MetricImpl.Type type : METRIC_TYPES) {
            if (!type.isRequired()) continue;
            wasRequiredMetricTypes.add(type.toString());
        }
        StringBuilder sb = new StringBuilder();
        for (String string : cleanedMetrics) {
            if (hasSome && (string.equals("ALL") || string.equals("NONE")) || hasAll && string.equals("NONE")) continue;
            if (wasRequiredMetricTypes.contains(string)) {
                wasRequiredMetricTypes.remove(string);
            }
            sb.append(string);
            sb.append(",");
        }
        if (hasSome) {
            for (String string : wasRequiredMetricTypes) {
                sb.append(string);
                sb.append(",");
            }
        }
        cleanOptionalMetrics = sb.toString().substring(0, sb.length() - 1);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("scrubOptionalMetrics: " + cleanOptionalMetrics));
        }
        return cleanOptionalMetrics;
    }

    public abstract HttpClientBuilder setSSLConnectionSocketFactory(HttpClientBuilder var1) throws SSLConfigException;

    public abstract String getInstallDirectory();

    public abstract String getInstanceIdentifier();

    protected abstract String getOptionalMetricConfiguration();

    public abstract String getAdminUIURL();

    public abstract long getStartTimeNano();

    protected abstract String getAPIKey();

    protected abstract String getProxyPassword();

    protected abstract String getTrustStorePassword();

    protected abstract boolean isZOSSR();

    protected abstract LogHelper getLogHelper();
}

