/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.InstalledProductInfo;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.Product;
import com.ibm.ws.usage.metering.common.ProductFactory;
import com.ibm.ws.usage.metering.common.RegisterTask;
import com.ibm.ws.usage.metering.common.RegistrationHelper;
import com.ibm.ws.usage.metering.common.TaskScheduler;
import com.ibm.ws.usage.metering.common.TrNLS;
import com.ibm.ws.usage.metering.common.UsageTask;
import com.ibm.wsspi.usage.metering.MetricDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class MeteringTask
implements Runnable {
    private static final String CLASS_NAME = MeteringTask.class.getName();
    private static final TraceComponent tc = Tr.register(MeteringTask.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private final int scheduleDelay = 5;
    private final List<InstalledProductInfo> productInfos;
    private final TaskScheduler scheduler;
    private final MeteringMetadata data;
    private final RegistrationHelper helper;
    private RegisterTask registerTask;
    private Future<?> registerTaskFuture;
    private UsageTask usageTask;
    private Future<?> usageTaskFuture;
    private ScheduledFuture<?> retryFuture;

    public MeteringTask(MeteringMetadata data, TaskScheduler scheduler, RegistrationHelper helper, List<InstalledProductInfo> productInfos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init>");
        }
        this.data = data;
        this.scheduler = scheduler;
        this.helper = helper;
        this.productInfos = productInfos;
    }

    @Override
    public synchronized void run() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        ArrayList<Product> products = new ArrayList<Product>();
        boolean failed = true;
        try {
            Product product;
            products.addAll(this.helper.createNonTagProducts(this.productInfos));
            HashSet<File> tagsDirs = new HashSet<File>();
            for (InstalledProductInfo installedProductInfo : this.productInfos) {
                tagsDirs.add(installedProductInfo.getTagsDir());
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tagsDirs = " + tagsDirs));
            }
            ArrayList productResolvers = new ArrayList();
            for (File tagsDir : tagsDirs) {
                productResolvers.add(new ProcessTags(tagsDir, this.helper));
            }
            List list = this.scheduler.invokeAll(productResolvers);
            ArrayList productsFromTag = new ArrayList();
            for (Future future : list) {
                productsFromTag.addAll((Collection)future.get());
            }
            for (Product product2 : productsFromTag) {
                if (!product2.isWebSphere()) continue;
                products.clear();
                break;
            }
            products.addAll(productsFromTag);
            if (products.size() == 0) {
                Tr.error((TraceComponent)tc, (String)"PRODUCT_TAGS_NOT_FOUND_CWWKR0407E", (Object)"IBM Cloud Private Metering");
                String message = TrNLS.formatMessage(ProductFactory.class, "PRODUCT_TAGS_NOT_FOUND_CWWKR0407E", "IBM Cloud Private Metering");
                Tr.error((TraceComponent)tc, (String)"REGISTRATION_FATAL_ERROR_CWWKR0403E", (Object)new Object[]{"IBM Cloud Private Metering", message});
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("MeteringTask: CWWKR0403E : CWWKR0407E : The following tags directory is missing or empty: " + tagsDirs));
                }
                return;
            }
            Collections.sort(products);
            Collections.reverse(products);
            boolean websphereFound = false;
            for (Product product3 : products) {
                if (!product3.isWebSphere()) continue;
                websphereFound = true;
                break;
            }
            if (!websphereFound && (product = this.helper.createEmbeddedWebSphereProduct(this.productInfos)) != null) {
                products.add(product);
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                for (Product product3 : products) {
                    Tr.debug((TraceComponent)tc, (String)("Sorted Product : " + product3.getName()));
                }
                Tr.debug((TraceComponent)tc, (String)"The product information for the usageMetering feature have been processed successfully.");
            }
            failed = false;
        }
        catch (ExecutionException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"85", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_EXCEPTION_CWWKR0401W", (Object)new Object[]{"IBM Cloud Private Metering", 5, e.getCause().getMessage()});
        }
        catch (InterruptedException ie) {
            FFDCFilter.processException((Throwable)ie, (String)(CLASS_NAME + ".run"), (String)"95", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_EXCEPTION_CWWKR0401W", (Object)new Object[]{"IBM Cloud Private Metering", 5, ie.toString()});
        }
        if (failed) {
            this.retryFuture = this.scheduler.schedule(this, 5L, TimeUnit.MINUTES);
        } else {
            this.validateOptionalMetrics(products);
            MeteringTask.enableProductUsage(this.scheduler, products);
            this.registerTask = new RegisterTask(this.data, this.scheduler, products);
            this.registerTaskFuture = this.scheduler.submit(this.registerTask);
            this.usageTask = new UsageTask(this.data, this.scheduler, products, this.helper.getRegistrationListener());
            this.usageTaskFuture = this.scheduler.submit(this.usageTask);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    private synchronized void validateOptionalMetrics(List<Product> products) {
        String optionalMetrics;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateOptionalMetrics");
        }
        String string = optionalMetrics = this.data.getMeteringContext().get("com.ibm.wsspi.usage.metering.configuredOptionaMetrics") == null ? null : this.data.getMeteringContext().get("com.ibm.wsspi.usage.metering.configuredOptionaMetrics").toString();
        if (optionalMetrics == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateOptionalMetrics: optionalMetrics Not Configured");
            }
            return;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("optionalMetrics String: " + optionalMetrics));
        }
        List<String> metrics = Arrays.asList(optionalMetrics.split(","));
        HashSet<MetricDescriptor> allMetricDescriptors = new HashSet<MetricDescriptor>();
        for (Product product : products) {
            Set<MetricDescriptor> set = product.getMetricDescriptors(null);
            if (set == null) continue;
            allMetricDescriptors.addAll(set);
        }
        ArrayList<String> metricTypes = new ArrayList<String>();
        for (MetricDescriptor metricDescriptor : allMetricDescriptors) {
            metricTypes.add(metricDescriptor.getType());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : metrics) {
            if (string2.equals("ALL") || string2.equals("NONE") || metricTypes.contains(string2)) continue;
            arrayList.add(string2);
        }
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : arrayList) {
                stringBuilder.append(string3);
                stringBuilder.append(",");
            }
            String string4 = stringBuilder.toString().substring(0, stringBuilder.length() - 1);
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String good : metricTypes) {
                stringBuilder2.append(good);
                stringBuilder2.append(",");
            }
            String supported = stringBuilder2.toString().substring(0, stringBuilder2.length() - 1);
            Tr.warning((TraceComponent)tc, (String)"UNKNOWN_METRIC_CWWKR0445W", (Object)new Object[]{string4, supported});
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateOptionalMetrics: exit");
        }
    }

    public synchronized void reregister() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reregister");
        }
        if (this.registerTaskFuture == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reregister: registerTaskFuture = null");
            }
            return;
        }
        Future<?> scheduledFuture = this.registerTask.reregister();
        if (scheduledFuture != null) {
            this.registerTaskFuture = scheduledFuture;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reregister");
        }
    }

    public synchronized void cleanupTasks() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanupTasks");
        }
        if (this.retryFuture != null && !this.retryFuture.isDone()) {
            this.retryFuture.cancel(true);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cleanupTasks: retryFuture");
            }
        }
        if (this.registerTaskFuture != null && !this.registerTaskFuture.isDone()) {
            this.registerTaskFuture.cancel(true);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cleanupTasks: registerTaskFuture");
            }
        }
        if (this.usageTaskFuture != null && !this.usageTaskFuture.isDone()) {
            this.usageTaskFuture.cancel(true);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cleanupTasks: usageTaskFuture");
            }
        }
        if (this.registerTask != null) {
            this.registerTask.cancelRegisterTask();
        }
        if (this.usageTask != null) {
            this.usageTask.cancelUsageTask();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanupTasks");
        }
    }

    public synchronized void submitLastUsage(boolean waitForUsage) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("submitLastUsage: " + waitForUsage));
        }
        if (RegisterTask.isRegistrationSuccessful()) {
            if (this.usageTaskFuture != null && !this.usageTaskFuture.isDone() && !this.usageTaskFuture.cancel(false)) {
                if (waitForUsage) {
                    this.usageTask.waitForUsageTask();
                }
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"submitLastUsage: usageTaskFuture");
                }
                return;
            }
            this.usageTask.submitLastUsage(waitForUsage);
        } else if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"submitLastUsage: registration wasn't successful. Not submitting last usage.");
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"submitLastUsage");
        }
    }

    private static void enableProductUsage(TaskScheduler scheduler, List<Product> products) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enableProductUsage");
        }
        ArrayList productResolvers = new ArrayList();
        for (Product p : products) {
            productResolvers.add(new EnableUsage(p));
        }
        try {
            scheduler.invokeAll(productResolvers);
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".enableProductUsage"), (String)"211");
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_FATAL_ERROR_CWWKR0403E", (Object)new Object[]{"IBM Cloud Private Metering", e.toString()});
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enableProductUsage");
        }
    }

    public synchronized boolean checkIfUsageFinished() {
        if (this.usageTask != null) {
            return this.usageTask.isUsageDone();
        }
        return true;
    }

    private static class ProcessTags
    implements Callable<List<Product>> {
        private final File tagsDir;
        private final RegistrationHelper helper;

        public ProcessTags(File tagsDir, RegistrationHelper helper) {
            this.tagsDir = tagsDir;
            this.helper = helper;
        }

        @Override
        public List<Product> call() throws Exception {
            return ProductFactory.readProducts(this.tagsDir, this.helper);
        }
    }

    private static class EnableUsage
    implements Callable<Void> {
        private final Product product;

        public EnableUsage(Product product) {
            this.product = product;
        }

        @Override
        public Void call() throws Exception {
            this.product.enableUsageDataCollection(true);
            return null;
        }
    }
}

