/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.MetricImpl;
import com.ibm.ws.usage.metering.common.TranslationHelper;
import com.ibm.ws.usage.metering.common.UsageImpl;
import com.ibm.ws.usage.metering.common.Util;
import com.ibm.ws.usage.metering.common.exceptions.MeteringException;
import com.ibm.wsspi.usage.metering.AggregationMethodDescriptor;
import com.ibm.wsspi.usage.metering.Group;
import com.ibm.wsspi.usage.metering.MeteringContext;
import com.ibm.wsspi.usage.metering.MetricCapDescriptor;
import com.ibm.wsspi.usage.metering.MetricDescriptor;
import com.ibm.wsspi.usage.metering.MetricGroupDescriptor;
import com.ibm.wsspi.usage.metering.ProductExtension;
import com.ibm.wsspi.usage.metering.RegistrationListener;
import com.ibm.wsspi.usage.metering.Usage;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ProductExtensionImpl
implements ProductExtension {
    private static final String CLASS_NAME = ProductExtensionImpl.class.getName();
    private static final TraceComponent tc = Tr.register(ProductExtensionImpl.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static final String HOURLY_CAP_OVERRIDE_PROPERTY = "com.ibm.ws.usage.metering.hourly.cap";
    private static final long HOURLY_CAP_DEFAULT = 576000000L;
    private static long HOURLY_CAP;
    private boolean enabled = false;
    private RegistrationListener registrationListener;
    protected String optionalMetrics;
    private final boolean sharedHost = false;
    private String capGroupId = null;
    private String capGroupName = null;

    @Override
    public int getProductWeight() {
        return 500;
    }

    @Override
    public String getPatchVersion(String baseVersion) {
        return null;
    }

    @Override
    public Set<MetricDescriptor> getMetricDescriptors(List<Group> groups) {
        Map<String, String> translatedNamesJUM;
        MetricGroupDescriptor mgd;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMetricDescriptors : " + groups));
        }
        HashSet<MetricDescriptor> metricDescriptors = new HashSet<MetricDescriptor>();
        TranslationHelper trHelper = new TranslationHelper();
        boolean hasGroups = groups != null && groups.size() > 0;
        Map<String, String> translatedUnitsMS = trHelper.getTranslatedNames("CWWKR0589");
        Map<String, String> translatedUnitsMB = trHelper.getTranslatedNames("CWWKR0590");
        if (this.isSupported(MetricImpl.Type.PROCESSOR_CORES)) {
            Map<String, String> translatedNamesAP = trHelper.getTranslatedNames("CWWKR0581");
            MetricDescriptor apMetric = new MetricDescriptor(MetricImpl.Type.PROCESSOR_CORES.toString(), translatedNamesAP);
            apMetric.setTranslatedUnits(trHelper.getTranslatedNames("CWWKR0598"));
            apMetric.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.MIN, AggregationMethodDescriptor.SliceAggregationMethod.MAX, AggregationMethodDescriptor.SliceAggregationMethod.LAST);
            apMetric.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.MIN, AggregationMethodDescriptor.RangeAggregationMethod.MAX, AggregationMethodDescriptor.RangeAggregationMethod.LAST);
            metricDescriptors.add(apMetric);
        }
        if (this.isSupported(MetricImpl.Type.CPU_TIME)) {
            Map<String, String> translatedNamesCPU = trHelper.getTranslatedNames("CWWKR0582");
            MetricDescriptor cpuMetric = new MetricDescriptor(MetricImpl.Type.CPU_TIME.toString(), translatedNamesCPU);
            cpuMetric.setTranslatedUnits(translatedUnitsMS);
            cpuMetric.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.MIN, AggregationMethodDescriptor.SliceAggregationMethod.MAX, AggregationMethodDescriptor.SliceAggregationMethod.AVG);
            cpuMetric.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.MIN, AggregationMethodDescriptor.RangeAggregationMethod.MAX, AggregationMethodDescriptor.RangeAggregationMethod.AVG, AggregationMethodDescriptor.RangeAggregationMethod.SUM);
            mgd = new MetricGroupDescriptor();
            mgd.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.SUM);
            mgd.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.SUM, AggregationMethodDescriptor.RangeAggregationMethod.AVG_SUM, AggregationMethodDescriptor.RangeAggregationMethod.MIN_SUM, AggregationMethodDescriptor.RangeAggregationMethod.MAX_SUM);
            mgd.setGroupRollUpMethod(MetricGroupDescriptor.GroupRollUp.SUM);
            cpuMetric.addGroupDescriptor(mgd);
            if (hasGroups) {
                for (Group group : groups) {
                    cpuMetric.addGroupDescriptor(new MetricGroupDescriptor().copyMetricAggregationMethods(mgd).setGroupID(group.getId()));
                }
            }
            metricDescriptors.add(cpuMetric);
        }
        if (this.isSupported(MetricImpl.Type.JAVA_COMMITTED_MEMORY)) {
            Map<String, String> translatedNamesJCM = trHelper.getTranslatedNames("CWWKR0583");
            MetricDescriptor jcmMetric = new MetricDescriptor(MetricImpl.Type.JAVA_COMMITTED_MEMORY.toString(), translatedNamesJCM);
            jcmMetric.setTranslatedUnits(translatedUnitsMB);
            jcmMetric.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.MIN, AggregationMethodDescriptor.SliceAggregationMethod.MAX, AggregationMethodDescriptor.SliceAggregationMethod.LAST);
            jcmMetric.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.MIN, AggregationMethodDescriptor.RangeAggregationMethod.MAX, AggregationMethodDescriptor.RangeAggregationMethod.LAST, AggregationMethodDescriptor.RangeAggregationMethod.AVG);
            mgd = new MetricGroupDescriptor();
            mgd.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.AVG, AggregationMethodDescriptor.SliceAggregationMethod.MIN, AggregationMethodDescriptor.SliceAggregationMethod.MAX);
            mgd.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.AVG_AVG, AggregationMethodDescriptor.RangeAggregationMethod.MIN, AggregationMethodDescriptor.RangeAggregationMethod.MAX);
            mgd.setGroupRollUpMethod(MetricGroupDescriptor.GroupRollUp.AVG);
            jcmMetric.addGroupDescriptor(mgd);
            if (hasGroups) {
                for (Group group : groups) {
                    jcmMetric.addGroupDescriptor(new MetricGroupDescriptor().copyMetricAggregationMethods(mgd).setGroupID(group.getId()));
                }
            }
            metricDescriptors.add(jcmMetric);
        }
        if (this.isSupported(MetricImpl.Type.JAVA_MAX_MEMORY)) {
            Map<String, String> translatedNamesJMaxMem = trHelper.getTranslatedNames("CWWKR0584");
            MetricDescriptor jmaxMetric = new MetricDescriptor(MetricImpl.Type.JAVA_MAX_MEMORY.toString(), translatedNamesJMaxMem);
            jmaxMetric.setTranslatedUnits(translatedUnitsMB);
            jmaxMetric.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.LAST);
            jmaxMetric.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.LAST);
            metricDescriptors.add(jmaxMetric);
        }
        if (this.isSupported(MetricImpl.Type.JAVA_INIT_MEMORY)) {
            Map<String, String> translatedNamesJMinMem = trHelper.getTranslatedNames("CWWKR0585");
            MetricDescriptor jminMetric = new MetricDescriptor(MetricImpl.Type.JAVA_INIT_MEMORY.toString(), translatedNamesJMinMem);
            jminMetric.setTranslatedUnits(translatedUnitsMB);
            jminMetric.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.LAST);
            jminMetric.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.LAST);
            metricDescriptors.add(jminMetric);
        }
        if (this.isSupported(MetricImpl.Type.SERVLET_REQUESTS)) {
            Map<String, String> translatedNamesSR = trHelper.getTranslatedNames("CWWKR0586");
            MetricDescriptor srMetric = new MetricDescriptor(MetricImpl.Type.SERVLET_REQUESTS.toString(), translatedNamesSR);
            srMetric.setTranslatedUnits(trHelper.getTranslatedNames("CWWKR0599"));
            srMetric.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.MIN, AggregationMethodDescriptor.SliceAggregationMethod.MAX, AggregationMethodDescriptor.SliceAggregationMethod.AVG);
            srMetric.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.MIN, AggregationMethodDescriptor.RangeAggregationMethod.MAX, AggregationMethodDescriptor.RangeAggregationMethod.AVG, AggregationMethodDescriptor.RangeAggregationMethod.SUM);
            mgd = new MetricGroupDescriptor();
            mgd.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.SUM);
            mgd.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.SUM, AggregationMethodDescriptor.RangeAggregationMethod.AVG_SUM, AggregationMethodDescriptor.RangeAggregationMethod.MIN_SUM, AggregationMethodDescriptor.RangeAggregationMethod.MAX_SUM);
            mgd.setGroupRollUpMethod(MetricGroupDescriptor.GroupRollUp.SUM);
            srMetric.addGroupDescriptor(mgd);
            if (hasGroups) {
                for (Group group : groups) {
                    srMetric.addGroupDescriptor(new MetricGroupDescriptor().copyMetricAggregationMethods(mgd).setGroupID(group.getId()));
                }
            }
            metricDescriptors.add(srMetric);
        }
        if (this.isSupported(MetricImpl.Type.TOTAL_PHYSICAL_MEMORY)) {
            Map<String, String> translatedNamesTPP = trHelper.getTranslatedNames("CWWKR0587");
            MetricDescriptor tpmMetric = new MetricDescriptor(MetricImpl.Type.TOTAL_PHYSICAL_MEMORY.toString(), translatedNamesTPP);
            tpmMetric.setTranslatedUnits(translatedUnitsMB);
            tpmMetric.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.LAST);
            tpmMetric.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.LAST);
            metricDescriptors.add(tpmMetric);
        }
        if (this.isSupported(MetricImpl.Type.JAVA_USED_MEMORY)) {
            translatedNamesJUM = trHelper.getTranslatedNames("CWWKR0588");
            MetricDescriptor jumMetric = new MetricDescriptor(MetricImpl.Type.JAVA_USED_MEMORY.toString(), translatedNamesJUM);
            jumMetric.setTranslatedUnits(translatedUnitsMB);
            jumMetric.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.MIN, AggregationMethodDescriptor.SliceAggregationMethod.MAX, AggregationMethodDescriptor.SliceAggregationMethod.LAST);
            jumMetric.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.MIN, AggregationMethodDescriptor.RangeAggregationMethod.MAX, AggregationMethodDescriptor.RangeAggregationMethod.LAST, AggregationMethodDescriptor.RangeAggregationMethod.AVG);
            mgd = new MetricGroupDescriptor();
            mgd.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.AVG, AggregationMethodDescriptor.SliceAggregationMethod.MIN, AggregationMethodDescriptor.SliceAggregationMethod.MAX);
            mgd.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.AVG_AVG, AggregationMethodDescriptor.RangeAggregationMethod.MIN, AggregationMethodDescriptor.RangeAggregationMethod.MAX);
            mgd.setGroupRollUpMethod(MetricGroupDescriptor.GroupRollUp.AVG);
            jumMetric.addGroupDescriptor(mgd);
            if (hasGroups) {
                for (Group group : groups) {
                    jumMetric.addGroupDescriptor(new MetricGroupDescriptor().copyMetricAggregationMethods(mgd).setGroupID(group.getId()));
                }
            }
            metricDescriptors.add(jumMetric);
        }
        if (this.isSupported(MetricImpl.Type.JAVA_MEMORY_AFTER_GC)) {
            translatedNamesJUM = trHelper.getTranslatedNames("CWWKR0595");
            MetricDescriptor jmGcMetric = new MetricDescriptor(MetricImpl.Type.JAVA_MEMORY_AFTER_GC.toString(), translatedNamesJUM);
            jmGcMetric.setTranslatedUnits(translatedUnitsMB);
            jmGcMetric.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.MIN, AggregationMethodDescriptor.SliceAggregationMethod.MAX, AggregationMethodDescriptor.SliceAggregationMethod.LAST);
            jmGcMetric.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.MIN, AggregationMethodDescriptor.RangeAggregationMethod.MAX, AggregationMethodDescriptor.RangeAggregationMethod.LAST, AggregationMethodDescriptor.RangeAggregationMethod.AVG);
            mgd = new MetricGroupDescriptor();
            mgd.setSliceAggregationMethods(AggregationMethodDescriptor.SliceAggregationMethod.AVG, AggregationMethodDescriptor.SliceAggregationMethod.MIN, AggregationMethodDescriptor.SliceAggregationMethod.MAX);
            mgd.setRangeAggregationMethods(AggregationMethodDescriptor.RangeAggregationMethod.AVG_AVG, AggregationMethodDescriptor.RangeAggregationMethod.MIN, AggregationMethodDescriptor.RangeAggregationMethod.MAX);
            mgd.setGroupRollUpMethod(MetricGroupDescriptor.GroupRollUp.AVG);
            jmGcMetric.addGroupDescriptor(mgd);
            if (hasGroups) {
                for (Group group : groups) {
                    jmGcMetric.addGroupDescriptor(new MetricGroupDescriptor().copyMetricAggregationMethods(mgd).setGroupID(group.getId()));
                }
            }
            metricDescriptors.add(jmGcMetric);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getMetricDescriptors: " + metricDescriptors.size()));
        }
        return metricDescriptors;
    }

    protected boolean isSupported(MetricImpl.Type metric) {
        boolean isSupported = true;
        if (metric.equals((Object)MetricImpl.Type.JAVA_MEMORY_AFTER_GC)) {
            try {
                UsageImpl.getUsedMemoryAfterLastGc();
            }
            catch (MeteringException e) {
                if (e.getCause() instanceof ClassNotFoundException || e.getCause() instanceof NoSuchMethodException) {
                    isSupported = false;
                }
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".isSupported"), (String)"277", (Object)this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isSupported: " + (Object)((Object)metric) + ":" + isSupported));
        }
        return isSupported;
    }

    @Override
    public MetricCapDescriptor getMetricCapDescriptor() {
        return new MetricCapDescriptor("VIRTUAL_PROCESSOR_CORES", HOURLY_CAP);
    }

    @Override
    public List<Group> getGroups(List<Group> combinedGroups) {
        if (this.capGroupId != null) {
            Group capGroup = new Group(this.capGroupId, this.capGroupName);
            if (!combinedGroups.isEmpty()) {
                capGroup.setParentGroupId(combinedGroups.get(combinedGroups.size() - 1).getId());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getGroups : adding capGroup :" + capGroup));
            }
            combinedGroups.add(capGroup);
        }
        return combinedGroups;
    }

    @Override
    public void setRegistrationListener(RegistrationListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setRegistrationListener : " + listener));
        }
        this.registrationListener = listener;
        MeteringContext context = listener.getMeteringContext();
        this.optionalMetrics = context.get("com.ibm.wsspi.usage.metering.configuredOptionaMetrics") == null ? null : context.get("com.ibm.wsspi.usage.metering.configuredOptionaMetrics").toString();
    }

    @Override
    public void enableUsageDataCollection(boolean enable) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("enableUsageDataCollection : " + enable));
        }
        this.enabled = enable;
        if (enable) {
            this.createUsage();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enableUsageDataCollection");
        }
    }

    @Override
    public void resetUsageDataCollection() {
    }

    @Override
    public Usage getCurrentUsage() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCurrentUsage");
        }
        if (!this.enabled) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCurrentUsage: not enabled");
            }
            return null;
        }
        Usage usage = this.createUsage();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCurrentUsage: " + Util.identity(usage)));
        }
        return usage;
    }

    protected void updateRegistration() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateRegistration : " + this.registrationListener));
        }
        if (this.registrationListener != null) {
            this.registrationListener.updateRegistration();
        }
    }

    protected abstract Usage createUsage();

    protected abstract MeteringMetadata getMeteringMetadata();

    static {
        String hourlyCapOverride = System.getProperty(HOURLY_CAP_OVERRIDE_PROPERTY);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)HOURLY_CAP_OVERRIDE_PROPERTY, (Object)hourlyCapOverride);
        }
        if (hourlyCapOverride != null) {
            try {
                HOURLY_CAP = Integer.parseInt(hourlyCapOverride);
            }
            catch (NumberFormatException nfe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ProductExtensionImpl static method exception caught while trying to parse hourlyCapOverride." + (nfe.getCause() != null ? nfe.getCause() : nfe)));
                }
                HOURLY_CAP = 576000000L;
            }
        } else {
            HOURLY_CAP = 576000000L;
        }
    }
}

