/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.Product;
import com.ibm.ws.usage.metering.common.RegistrationHelper;
import com.ibm.ws.usage.metering.common.Tag;
import com.ibm.ws.usage.metering.common.Util;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;

public class ProductFactory {
    private static final String CLASS_NAME = ProductFactory.class.getName();
    private static final TraceComponent tc = Tr.register(ProductFactory.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");

    public static List<Product> readProducts(File tagsDir, RegistrationHelper helper) {
        File[] tagFiles;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("readProducts: " + tagsDir));
        }
        if ((tagFiles = tagsDir.listFiles(new ExtensionFilter("swidtag"))) == null || tagFiles.length == 0) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readProducts: 0");
            }
            return Collections.emptyList();
        }
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        for (File f : tagFiles) {
            try {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StreamSource(f));
                Tag t = new Tag();
                boolean isPatchTagFile = false;
                while (reader.hasNext()) {
                    String tmpId;
                    if (reader.next() != 1) continue;
                    String field = reader.getLocalName();
                    if ("SoftwareIdentity".equals(field)) {
                        t.setUniqueId(reader.getAttributeValue(null, "tagId"));
                        t.setName(reader.getAttributeValue(null, "name"));
                        String delta = reader.getAttributeValue(null, "patch");
                        if ("true".equals(delta)) {
                            isPatchTagFile = true;
                            t.setVersion(reader.getAttributeValue(null, "version"));
                            continue;
                        }
                        t.setBaseVersion(reader.getAttributeValue(null, "version"));
                        continue;
                    }
                    if (!"Meta".equals(field) || (tmpId = reader.getAttributeValue(null, "persistentId")) == null) continue;
                    t.setPersistentId(tmpId);
                }
                Tag existing = (Tag)tags.get(t.getPersistentId());
                if (existing == null) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("adding : " + Util.identity(t)));
                    }
                    t.setProductExtension(helper.getProductExtension(t.getPersistentId()));
                    t.setRegistrationListener(helper.getRegistrationListener());
                    tags.put(t.getPersistentId(), t);
                    continue;
                }
                if (!isPatchTagFile) continue;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updating uniqueId and version  : " + Util.identity(existing)));
                }
                existing.setUniqueId(t.getUniqueId());
                existing.setVersion(t.getVersion());
            }
            catch (XMLStreamException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".readProducts"), (String)"118");
                Tr.warning((TraceComponent)tc, (String)"PRODUCT_TAGS_CORRUPT_CWWKR0408W", (Object)new Object[]{f.getPath(), e.toString()});
            }
        }
        ArrayList result = new ArrayList(tags.values());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readProducts: " + result.size()));
        }
        return Collections.unmodifiableList(result);
    }

    private static final class ExtensionFilter
    implements FileFilter {
        private final String extension;

        public ExtensionFilter(String string) {
            this.extension = "." + string;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(this.extension);
        }
    }
}

