/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.json.java.JSONObject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.JsonHelper;
import com.ibm.ws.usage.metering.common.MeteringConstants;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.Product;
import com.ibm.ws.usage.metering.common.TaskScheduler;
import com.ibm.ws.usage.metering.common.Util;
import com.ibm.ws.usage.metering.common.exceptions.MeteringErrorCode;
import com.ibm.ws.usage.metering.common.exceptions.MeteringRuntimeException;
import com.ibm.ws.usage.metering.common.exceptions.SSLConfigException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.StringEntity;

public final class RegisterTask
implements Runnable {
    private static final String CLASS_NAME;
    private static final TraceComponent tc;
    private static final String REGISTRATION_INTERVAL_PROPERTY = "com.ibm.ws.usage.metering.registration.retry.interval";
    private static final long DEFAULT_SCHEDULE_DELAY;
    private static final TimeUnit TIMEUNIT;
    private static final String BAD_APIKEY_FAILURE = "400 : Bad Request";
    private static volatile boolean registrationSuccess;
    private Future<?> registerTaskFuture;
    private final MeteringMetadata data;
    private final TaskScheduler scheduler;
    private final List<Product> products;
    private int retryCount = 0;

    public RegisterTask(MeteringMetadata data, TaskScheduler scheduler, List<Product> products) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + Util.identity(this)));
        }
        this.data = data;
        this.scheduler = scheduler;
        this.products = products;
    }

    @Override
    public synchronized void run() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        long scheduleDelay = DEFAULT_SCHEDULE_DELAY;
        TimeUnit scheduleDelayTimeUnit = TIMEUNIT;
        try {
            Response response = this.register(this.data, this.products);
            if (response.responseCode == 200 || response.responseCode == 201) {
                RegisterTask.setRegistrationSuccess(true);
                String urlString = (String)this.data.getProperty(MeteringConstants.Property.URL);
                Tr.info((TraceComponent)tc, (String)"REGISTERED_CWWKR0400I", (Object)new Object[]{"IBM Cloud Private Metering", urlString});
            } else {
                RegisterTask.setRegistrationSuccess(false);
                if (response.responseCode == 401 && BAD_APIKEY_FAILURE.equals(this.data.getTokenFailure())) {
                    Tr.error((TraceComponent)tc, (String)"REGISTRATION_ERROR_WRONG_API_KEY_CWWKR0412E", (Object)new Object[]{"IBM Cloud Private Metering"});
                    scheduleDelay = 0L;
                } else {
                    String responseStr = "responseCode:" + response.responseCode + " responseMessage:" + response.responseMessage + " errorMessage:(" + response.responseErrorMessage + ")";
                    Tr.warning((TraceComponent)tc, (String)"REGISTRATION_BAD_RESPONSE_CWWKR0402W", (Object)new Object[]{"IBM Cloud Private Metering", TimeUnit.MINUTES.convert(scheduleDelay, scheduleDelayTimeUnit), responseStr});
                }
            }
        }
        catch (HttpHostConnectException hce) {
            RegisterTask.setRegistrationSuccess(false);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_EXCEPTION_CWWKR0401W", (Object)new Object[]{"IBM Cloud Private Metering", TimeUnit.MINUTES.convert(scheduleDelay, scheduleDelayTimeUnit), hce.toString()});
        }
        catch (IOException ioe) {
            RegisterTask.setRegistrationSuccess(false);
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".run"), (String)"111", (Object)this);
            if (ioe instanceof SSLHandshakeException) {
                Tr.error((TraceComponent)tc, (String)"REGISTRATION_ERROR_CWWKR0413E", (Object)new Object[]{"IBM Cloud Private Metering"});
                scheduleDelay = 0L;
            } else {
                Tr.warning((TraceComponent)tc, (String)"REGISTRATION_EXCEPTION_CWWKR0401W", (Object)new Object[]{"IBM Cloud Private Metering", TimeUnit.MINUTES.convert(scheduleDelay, scheduleDelayTimeUnit), ioe.toString()});
            }
        }
        catch (SSLConfigException ssle) {
            RegisterTask.setRegistrationSuccess(false);
            if (ssle.getErrorCode() == MeteringErrorCode.INTERNAL_SSL_CONFIG_UNAVAILABLE) {
                scheduleDelay = 5L;
                scheduleDelayTimeUnit = TimeUnit.SECONDS;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Received SSLConfigException with errorcode INTERNAL_SSL_CONFIG_UNAVAILABLE.  Retry in 5 seconds.");
                }
            } else if (ssle.getErrorCode() == MeteringErrorCode.INTERNAL_SSL_SSLEXCEPTION) {
                FFDCFilter.processException((Throwable)ssle, (String)(CLASS_NAME + ".run"), (String)"115", (Object)this);
                Tr.error((TraceComponent)tc, (String)"REGISTRATION_ERROR_CWWKR0413E", (Object)new Object[]{"IBM Cloud Private Metering"});
                scheduleDelay = 0L;
            } else if (ssle.getErrorCode() == MeteringErrorCode.INTERNAL_SSL_SSLEXCEPTION_MISSING_CONFIG) {
                FFDCFilter.processException((Throwable)ssle, (String)(CLASS_NAME + ".run"), (String)"139", (Object)this);
                Tr.error((TraceComponent)tc, (String)"REGISTRATION_ERROR_CWWKR0420E", (Object)new Object[]{"IBM Cloud Private Metering"});
                scheduleDelay = 0L;
            } else {
                Tr.warning((TraceComponent)tc, (String)"REGISTRATION_EXCEPTION_CWWKR0401W", (Object)new Object[]{"IBM Cloud Private Metering", TimeUnit.MINUTES.convert(scheduleDelay, scheduleDelayTimeUnit), ssle.getMessage()});
            }
        }
        catch (MeteringRuntimeException bcre) {
            RegisterTask.setRegistrationSuccess(false);
            FFDCFilter.processException((Throwable)bcre, (String)(CLASS_NAME + ".run"), (String)"126", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_EXCEPTION_CWWKR0401W", (Object)new Object[]{"IBM Cloud Private Metering", TimeUnit.MINUTES.convert(scheduleDelay, scheduleDelayTimeUnit), bcre.getMessage()});
        }
        catch (Throwable t) {
            RegisterTask.setRegistrationSuccess(false);
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".run"), (String)"130", (Object)this);
        }
        if (!registrationSuccess && scheduleDelay > 0L) {
            ++this.retryCount;
            this.registerTaskFuture = this.scheduler.schedule(this, scheduleDelay, scheduleDelayTimeUnit);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response register(MeteringMetadata data, List<Product> products) throws SSLConfigException, IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"register");
        }
        RegisterTask.setRegistrationSuccess(false);
        String token = data.getToken(false, this.retryCount % 12 == 0);
        int responseCode = -1;
        String responseMessage = "";
        String responseErrorMessage = "";
        try (CloseableHttpResponse response = null;){
            URL targetURL = data.getRegistrationURL(token);
            HttpPost httpPost = new HttpPost(targetURL.toString());
            String productJsonString = JsonHelper.buildRegistrationJSON(data, products);
            StringEntity in = new StringEntity(productJsonString);
            in.setContentType("application/json");
            httpPost.setEntity((HttpEntity)in);
            if (token != null) {
                httpPost.setHeader("Authorization", token);
                httpPost.setHeader("Accepts", "application/json");
            } else {
                httpPost.setHeader("hc-access-token", data.getAPIKey());
            }
            response = data.executeRequest((HttpUriRequest)httpPost);
            responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 201) {
                responseMessage = response.getStatusLine().getReasonPhrase();
            } else if (responseCode == 401) {
                responseErrorMessage = this.getResponseError(response);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got a 401 unauthorized; forcing a new access token");
                }
                if ((token = data.getToken(true, false)) != null && token.length() > 0) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Got a new access token. Retrying registration.");
                    }
                    response.close();
                    responseErrorMessage = "";
                    httpPost.removeHeaders("Authorization");
                    httpPost.setHeader("Authorization", token);
                    response = data.executeRequest((HttpUriRequest)httpPost);
                    responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode == 201) {
                        responseMessage = response.getStatusLine().getReasonPhrase();
                    } else {
                        responseErrorMessage = this.getResponseError(response);
                    }
                }
            } else {
                responseErrorMessage = this.getResponseError(response);
            }
        }
        Response piResponse = new Response(responseCode, responseErrorMessage, responseMessage);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("register: " + piResponse));
        }
        return piResponse;
    }

    public synchronized Future<?> reregister() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reregister");
        }
        if (!registrationSuccess) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reregister: null");
            }
            return null;
        }
        RegisterTask.setRegistrationSuccess(false);
        this.retryCount = 0;
        Future<?> future = this.scheduler.submit(this);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("reregister: " + Util.identity(future)));
        }
        return future;
    }

    private static void setRegistrationSuccess(boolean success) {
        registrationSuccess = success;
    }

    public static boolean isRegistrationSuccessful() {
        return registrationSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponseError(CloseableHttpResponse response) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getResponseError : " + response));
        }
        String responseErrorMessage = response.getStatusLine().getReasonPhrase();
        InputStreamReader reader = null;
        ByteArrayOutputStream outputBuffer = null;
        try {
            InputStream inputStream = response.getEntity().getContent();
            reader = new InputStreamReader(inputStream, "UTF-8");
            Header[] headers = response.getHeaders("Content-Type");
            String contentType = "";
            if (headers.length > 0) {
                contentType = headers[0].getValue();
            }
            if (contentType != null && (contentType.contains("json") || contentType.contains("JSON"))) {
                if (inputStream.available() > 1) {
                    JSONObject errorJSON = JSONObject.parse((Reader)reader);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("errorStream JSON Object = " + errorJSON.serialize(true)));
                    }
                    responseErrorMessage = JsonHelper.extractErrorStreamMessages(errorJSON);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"json response entity content empty");
                }
            } else {
                outputBuffer = new ByteArrayOutputStream();
                int result = reader.read();
                while (result != -1) {
                    outputBuffer.write((byte)result);
                    result = reader.read();
                }
                responseErrorMessage = outputBuffer.toString("UTF-8");
                if ("".equals(responseErrorMessage)) {
                    responseErrorMessage = response.getStatusLine().getReasonPhrase();
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getResponseError"), (String)"182", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)e.toString());
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (outputBuffer != null) {
                    outputBuffer.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getResponseError : " + responseErrorMessage));
        }
        return responseErrorMessage;
    }

    public synchronized void cancelRegisterTask() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancelRegisterTask");
        }
        if (this.registerTaskFuture != null && !this.registerTaskFuture.isDone()) {
            this.registerTaskFuture.cancel(true);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cancelRegisterTask: registerTaskFuture");
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancelRegisterTask");
        }
    }

    static {
        TimeUnit timeUnit;
        long defaultRegistrationInterval;
        block4: {
            CLASS_NAME = RegisterTask.class.getName();
            tc = Tr.register(RegisterTask.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
            registrationSuccess = false;
            defaultRegistrationInterval = 5L;
            timeUnit = TimeUnit.MINUTES;
            String registrationIntValProp = System.getProperty(REGISTRATION_INTERVAL_PROPERTY);
            if (registrationIntValProp != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("com.ibm.ws.usage.metering.registration.retry.interval = " + registrationIntValProp));
                }
                try {
                    Long registrationIntervalInMillis = Long.valueOf(registrationIntValProp);
                    defaultRegistrationInterval = registrationIntervalInMillis;
                    timeUnit = TimeUnit.MILLISECONDS;
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(CLASS_NAME + ".<cinit>"), (String)"64");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)nfe.toString());
                }
            }
        }
        DEFAULT_SCHEDULE_DELAY = defaultRegistrationInterval;
        TIMEUNIT = timeUnit;
    }

    private static class Response {
        protected int responseCode;
        protected String responseMessage;
        protected String responseErrorMessage;

        public Response(int responseCode, String responseErrorMessage, String responseMessage) {
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
            this.responseErrorMessage = responseErrorMessage;
        }

        public String toString() {
            return "Response(code=" + this.responseCode + ", message=" + this.responseMessage + ", errorMessage=" + this.responseErrorMessage + ")";
        }
    }
}

