/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.RegisterTask;
import com.ibm.ws.usage.metering.common.TaskScheduler;
import com.ibm.ws.usage.metering.common.UsageTask;
import com.ibm.ws.usage.metering.common.Util;
import com.ibm.ws.usage.metering.common.exceptions.MeteringException;
import com.ibm.ws.usage.metering.common.exceptions.SSLConfigException;
import com.ibm.wsspi.usage.metering.RegistrationListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class SendUsageTask
implements Runnable {
    private static final String CLASS_NAME = SendUsageTask.class.getName();
    private static final TraceComponent tc = Tr.register(SendUsageTask.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static final long RETRY_DELAY_MIN_MS = 5000L;
    private static final long RETRY_DELAY_MAX_MS = 60000L;
    private static final int MAX_RETRIES = 3;
    private static final String MESSAGE_NOT_REGISTERED = "Instance has not been registered.";
    private static String lastFailureMsg = null;
    private static int lastFailureCount = 0;
    private static boolean testMissingRegistration = false;
    private final MeteringMetadata data;
    private final TaskScheduler scheduler;
    private final Queue<JSONObject> queue;
    private final Future<?> blockingTask;
    private final RegistrationListener registrationListener;
    private boolean updateRegistration;
    private boolean overlapErrorInZOSSR;
    private final boolean retry;
    private int retryCount = 0;
    private final long retryDelay = Math.min(60000L, Math.max(5000L, UsageTask.COLLECTION_INTERVAL_MS / 15L));
    private final long lastRetryTime = System.currentTimeMillis() + UsageTask.COLLECTION_INTERVAL_MS - this.retryDelay;

    public SendUsageTask(MeteringMetadata data, TaskScheduler scheduler, Queue<JSONObject> queue, Future<?> blocker, RegistrationListener listener, boolean retry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + Util.identity(this) + ", retry=" + retry + ", retryDelay=" + this.retryDelay));
        }
        this.data = data;
        this.scheduler = scheduler;
        this.queue = queue;
        this.blockingTask = blocker;
        this.registrationListener = listener;
        this.updateRegistration = false;
        this.overlapErrorInZOSSR = false;
        this.retry = retry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        if (RegisterTask.isRegistrationSuccessful()) {
            ArrayList<JSONObject> messages;
            block57: {
                messages = new ArrayList<JSONObject>();
                try {
                    if (this.retry) {
                        this.blockingTask.get(3L, UsageTask.TIMEOUTUNIT);
                    } else {
                        this.blockingTask.get(15L, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException e) {
                    if (this.retry) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"87", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"SEND_USAGE_EXCEPTION_CWWKR0430W", (Object)(e.getCause() != null ? e.getCause().toString() : e.toString()));
                    } else if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SendUsageTask.run(): Interruption occurred while waiting for last usage: " + (e.getCause() != null ? e.getCause() : e)));
                    }
                }
                catch (ExecutionException e) {
                    if (this.retry) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"90", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"SEND_USAGE_EXCEPTION_CWWKR0430W", (Object)(e.getCause() != null ? e.getCause().toString() : e.toString()));
                    } else if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SendUsageTask.run(): ExecutionException occurred while waiting for last usage: " + (e.getCause() != null ? e.getCause() : e)));
                    }
                }
                catch (TimeoutException e) {
                    if (this.retry) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"93", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"SEND_USAGE_EXCEPTION_CWWKR0430W", (Object)(e.getCause() != null ? e.getCause().toString() : e.toString()));
                    }
                    if (!isTraceOn || !tc.isDebugEnabled()) break block57;
                    Tr.debug((TraceComponent)tc, (String)("SendUsageTask.run(): Timeout occurred while waiting for last usage: " + (e.getCause() != null ? e.getCause() : e)));
                }
            }
            Queue<JSONObject> queue = this.queue;
            synchronized (queue) {
                while (this.queue.size() > 0) {
                    messages.add(this.queue.remove());
                }
                if (messages.size() < 1) {
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"run: Nothing to send, canceling");
                    }
                    return;
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SendUsageTask: Sending (" + messages.size() + ") messages"));
                }
                try {
                    JSONObject responseJSON = this.sendMessages(this.data, messages);
                    int responseCode = Integer.parseInt((String)responseJSON.get((Object)"responseCode"));
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SendUsageTask: Message Sent: Response code = " + responseCode));
                    }
                    if (responseCode == 200 || responseCode == 201) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"SendUsageTask: Sent all usage messages successfully!");
                        }
                        SendUsageTask.clearSendUsageFailures();
                    } else if (responseCode == 207 || responseCode == 500) {
                        if (this.updateRegistration) {
                            if (this.registrationListener != null) {
                                if (isTraceOn && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"SendUsageTask: Registration missing; resend registration and requeue messages.");
                                }
                                this.registrationListener.updateRegistration();
                                this.requeueMessages(messages, this.formatFailureMsg(responseJSON) + " : Registration missing", false);
                            } else {
                                if (isTraceOn && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"SendUsageTask: Registration missing; discarding messages since shutting down.");
                                }
                                SendUsageTask.clearSendUsageFailures();
                            }
                        } else if (this.overlapErrorInZOSSR) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("SendUsageTask: " + responseCode + " : overlap error  on zOS. Discarding the messages instead of requeuing them."));
                            }
                            SendUsageTask.clearSendUsageFailures();
                        } else if (responseCode == 207) {
                            JSONArray failuresJSONArray = (JSONArray)responseJSON.get((Object)"failures");
                            if (failuresJSONArray != null && failuresJSONArray.size() > 0) {
                                MeteringException ex = new MeteringException("Bad usage was sent. Response was " + responseCode + " : " + failuresJSONArray.serialize());
                                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".run"), (String)"149", (Object)this);
                                if (isTraceOn && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("SendUsageTask: " + responseCode + " : Detected bad messages. Discarding the messages instead of requeuing them."));
                                }
                                Tr.warning((TraceComponent)tc, (String)"SEND_USAGE_EXCEPTION_CWWKR0430W", (Object)this.formatFailureMsg(responseJSON));
                            }
                            SendUsageTask.clearSendUsageFailures();
                        } else {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"SendUsageTask: Failed to send usage messages!");
                            }
                            this.requeueMessages(messages, this.formatFailureMsg(responseJSON), false);
                        }
                    } else if (responseCode == 410 || responseCode == 429) {
                        if (this.data.getUsageAdjustment() == -1L && this.retryCount == 0) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"SendUsageTask: Requests are too frequent.  Generating a new usage adjustment.");
                            }
                            Random rnd = new Random();
                            this.data.setUsageAdjustment((rnd.nextInt(30) + 3) * 1000);
                        } else if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"SendUsageTask: Requests are too frequent.  Usage adjustment has already been generated.");
                        }
                        this.requeueMessages(messages, this.formatFailureMsg(responseJSON), true);
                    } else {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"SendUsageTask: Failed to send all usage messages!");
                        }
                        this.requeueMessages(messages, this.formatFailureMsg(responseJSON), false);
                    }
                }
                catch (IOException e) {
                    this.requeueMessages(messages, e.getCause() != null ? e.getCause().toString() : e.toString(), false);
                }
                catch (SSLConfigException ssle) {
                    FFDCFilter.processException((Throwable)ssle, (String)(CLASS_NAME + ".run"), (String)"146", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"SEND_USAGE_EXCEPTION_CWWKR0430W", (Object)ssle.getMessage());
                    SendUsageTask.clearSendUsageFailures();
                }
            }
            if (this.data.getResetUsageAdjustment()) {
                this.data.setUsageAdjustment(-1L);
                this.data.setResetUsageAdjustment(false);
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SendUsageTask: Ended: Queue Size(" + this.queue.size() + ")"));
            }
        } else if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SendUsageTask: Detected that registration or re-registration hasn't completed. Abort sending usage data.");
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    private void requeueMessages(Collection<JSONObject> messages, String failure, boolean adjustTime) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        SendUsageTask.logSendUsageFailure(failure, messages.size(), this.retryCount == 0 && messages.size() % 4 == 1);
        for (JSONObject message : messages) {
            this.queue.add(message);
        }
        if (this.retry) {
            if (this.retryCount < 3) {
                boolean nextCollectionOverlap;
                ++this.retryCount;
                long retryTime = this.retryDelay;
                if (adjustTime) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SendUsageTask: Adjusting retry time by " + this.data.getUsageAdjustment()));
                    }
                    retryTime += this.data.getUsageAdjustment();
                }
                boolean bl = nextCollectionOverlap = System.currentTimeMillis() + retryTime > this.lastRetryTime;
                if (nextCollectionOverlap) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The SendUsageTask will not reschedule itself since the parent UsageTask is already scheduled to run in less than " + this.retryDelay + " milliseconds from the next retry."));
                        Tr.debug((TraceComponent)tc, (String)("SendUsageTask: Max retries time reached, queue size = (" + messages.size() + ")"));
                    }
                } else {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SendUsageTask: Retrying in " + retryTime + " ms: Retry count = " + this.retryCount));
                    }
                    this.scheduler.schedule(this, retryTime, TimeUnit.MILLISECONDS);
                }
            } else if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SendUsageTask: Max retries reached, queue size = (" + messages.size() + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject sendMessages(MeteringMetadata data, Collection<JSONObject> messages) throws SSLConfigException, IOException {
        int responseCode;
        JSONObject piResponse;
        boolean isTraceOn;
        block43: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"sendMessages");
            }
            CloseableHttpResponse response = null;
            piResponse = new JSONObject();
            responseCode = -1;
            try {
                InputStream inputStream;
                String token = data.getToken(false, messages.size() % 4 == 1);
                URL targetURL = data.getUsageURL(token);
                HttpPost httpPost = new HttpPost(targetURL.toString());
                StringEntity in = new StringEntity(this.toJSON(messages));
                in.setContentType("application/json");
                httpPost.setEntity((HttpEntity)in);
                if (token != null) {
                    httpPost.setHeader("Authorization", token);
                    httpPost.setHeader("Accepts", "application/json");
                } else {
                    httpPost.setHeader("hc-access-token", data.getAPIKey());
                }
                response = data.executeRequest((HttpUriRequest)httpPost);
                responseCode = response.getStatusLine().getStatusCode();
                if (responseCode == 401) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Got a 401 unauthorized; forcing a new access token");
                    }
                    if ((token = data.getToken(true, false)) != null && token.length() > 0) {
                        response.close();
                        httpPost.removeHeaders("Authorization");
                        httpPost.setHeader("Authorization", token);
                        response = data.executeRequest((HttpUriRequest)httpPost);
                        responseCode = response.getStatusLine().getStatusCode();
                    }
                }
                if (responseCode == 201 || (inputStream = response.getEntity().getContent()) == null) break block43;
                InputStreamReader reader = null;
                ByteArrayOutputStream outputBuffer = null;
                JSONArray failures = null;
                JSONObject element = null;
                String responseStr = null;
                try {
                    reader = new InputStreamReader(inputStream, "UTF-8");
                    outputBuffer = new ByteArrayOutputStream();
                    int result = reader.read();
                    while (result != -1) {
                        outputBuffer.write((byte)result);
                        result = reader.read();
                    }
                    responseStr = outputBuffer.toString("UTF-8");
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendMessages"), (String)"298", (Object)this);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Something went wrong when reading the input stream. The following Exception was thrown: ", (Object)e);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (outputBuffer != null) {
                        outputBuffer.close();
                    }
                }
                if (responseStr != null && (responseStr.startsWith("{") && responseStr.endsWith("}") || responseStr.startsWith("[") && responseStr.endsWith("]"))) {
                    block45: {
                        try {
                            failures = JSONArray.parse((String)responseStr);
                        }
                        catch (ClassCastException cce) {
                            try {
                                element = JSONObject.parse((String)responseStr);
                                failures = new JSONArray();
                                failures.add((Object)element);
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendMessages"), (String)"316", (Object)this);
                                if (isTraceOn && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Something went wrong when parsing the response as a JSONObject. The following Exception was thrown: ", (Object)e);
                                }
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendMessages"), (String)"321", (Object)this);
                            if (!isTraceOn || !tc.isDebugEnabled()) break block45;
                            Tr.debug((TraceComponent)tc, (String)"Something went wrong when parsing the response as a JSONArray. The following Exception was thrown: ", (Object)e);
                        }
                    }
                    if (failures == null) break block43;
                    if ((responseCode == 207 || responseCode == 500) && failures.size() > 0) {
                        try {
                            element = (JSONObject)failures.get(0);
                            Long status = (Long)element.get((Object)"status");
                            if (status != null) {
                                if (status == 400L) {
                                    String message = (String)element.get((Object)"message");
                                    if (MESSAGE_NOT_REGISTERED.equals(message)) {
                                        this.updateRegistration = true;
                                    }
                                } else if (status == 404L) {
                                    this.updateRegistration = true;
                                } else if (status == 409L && data.isZOSSR()) {
                                    if (isTraceOn && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Overlap error detected on zOS");
                                    }
                                    this.overlapErrorInZOSSR = true;
                                }
                            }
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".sendMessages"), (String)"379", (Object)this);
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Something went wrong when parsing the failures. The following Exception was thrown: ", (Object)ex);
                            }
                            Tr.warning((TraceComponent)tc, (String)"SEND_USAGE_EXCEPTION_CWWKR0430W", (Object)(ex.getCause() != null ? ex.getCause() : ex));
                        }
                    }
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("return json error array = " + failures.serialize(true)));
                    }
                    piResponse.put((Object)"failures", (Object)failures);
                    break block43;
                }
                String reason = response.getStatusLine().getReasonPhrase();
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("reason = " + reason + ", errorStream message = " + responseStr));
                }
                if (reason != null && reason.length() > 0) {
                    piResponse.put((Object)"reason", (Object)reason);
                } else {
                    piResponse.put((Object)"reason", (Object)responseStr);
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        piResponse.put((Object)"responseCode", (Object)String.valueOf(responseCode));
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendMessages: responseCode=" + responseCode));
        }
        return piResponse;
    }

    private String toJSON(Collection<JSONObject> messages) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toJSON");
        }
        JSONArray messagesArray = new JSONArray();
        for (JSONObject message : messages) {
            if (testMissingRegistration) {
                message.put((Object)"hostName", (Object)"NeverRegisteredHost");
            }
            messagesArray.add((Object)message);
        }
        if (this.data.logJSON()) {
            this.data.getLogHelper().writeJSON(messagesArray, null);
        }
        String json = messagesArray.serialize(true);
        if (testMissingRegistration) {
            testMissingRegistration = false;
            for (JSONObject message : messages) {
                message.put((Object)"hostName", (Object)this.data.getHostName());
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("toJSON: " + json));
        }
        return json;
    }

    private String formatFailureMsg(JSONObject responseJSON) {
        JSONArray failures;
        StringBuilder failureMsg = new StringBuilder((String)responseJSON.get((Object)"responseCode"));
        String reason = (String)responseJSON.get((Object)"reason");
        if (reason != null) {
            failureMsg.append(" : ").append(reason);
        }
        if ((failures = (JSONArray)responseJSON.get((Object)"failures")) != null && failures.size() > 0) {
            failureMsg.append(" [");
            Iterator elements = failures.iterator();
            while (elements.hasNext()) {
                JSONObject failure = (JSONObject)elements.next();
                failureMsg.append(failure.get((Object)"status"));
                Object message = failure.get((Object)"message");
                if (message != null) {
                    failureMsg.append(" : ");
                    failureMsg.append(message);
                } else {
                    Object type = failure.get((Object)"type");
                    if (type != null) {
                        failureMsg.append(" : ");
                        failureMsg.append(type);
                    }
                }
                if (!elements.hasNext()) continue;
                failureMsg.append(",  ");
            }
            failureMsg.append("]");
        }
        return failureMsg.toString();
    }

    private static synchronized void logSendUsageFailure(String failure, int queueSize, boolean logCachedFailures) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("logSendUsageFailure : " + failure + ", " + logCachedFailures));
        }
        if (failure.equals(lastFailureMsg)) {
            ++lastFailureCount;
            if (logCachedFailures) {
                String warning = failure + " (x" + lastFailureCount + "), queue size = (" + queueSize + ")";
                Tr.warning((TraceComponent)tc, (String)"SEND_USAGE_EXCEPTION_CWWKR0430W", (Object)warning);
                lastFailureCount = 0;
            }
        } else {
            String warning = lastFailureCount > 0 ? lastFailureMsg + " (x" + lastFailureCount + "), " + failure : failure;
            warning = warning + ", queue size = (" + queueSize + ")";
            Tr.warning((TraceComponent)tc, (String)"SEND_USAGE_EXCEPTION_CWWKR0430W", (Object)warning);
            lastFailureMsg = failure;
            lastFailureCount = 0;
        }
    }

    private static synchronized void clearSendUsageFailures() {
        if (lastFailureMsg != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("clearSendUsageFailures : " + lastFailureMsg + ", " + lastFailureCount));
            }
            lastFailureMsg = null;
            lastFailureCount = 0;
        }
    }
}

