/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.json.java.JSONObject;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class ServerEnvironmentUtil {
    private static final String CLASS_NAME;
    private static final TraceComponent tc;
    public static final String VAR_DEFAULTHOSTNAME = "${defaultHostName}";
    public static final String VAR_WLPSERVERNAME = "${wlp.server.name}";
    public static final String ENV_VAR_CONTAINERHOST = "${env.CONTAINER_HOST}";
    public static final String ENV_VAR_VCAP_APPLICATION = "${env.VCAP_APPLICATION}";
    public static final String ENV_VAR_INSTANCE_INDEX = "${env.INSTANCE_INDEX}";
    public static final String ENV_VAR_CF_INSTANCE_INDEX = "${env.CF_INSTANCE_INDEX}";
    private static String serverIP;
    private static String serverHostName;
    private static final String realServerHostName;

    private static void setPreferredIpAndHostName(NetworkInterface nic) {
        block4: {
            Enumeration<InetAddress> addrs = nic.getInetAddresses();
            for (InetAddress addr : Collections.list(addrs)) {
                if (addr.isLinkLocalAddress() || !(addr instanceof Inet4Address) || serverIP != null && addr.getHostAddress().equals(addr.getCanonicalHostName())) continue;
                serverIP = addr.getHostAddress();
                serverHostName = addr.getCanonicalHostName();
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Found serverIP: " + serverIP + ", Found server host: " + serverHostName));
            }
            if (serverIP != null && serverIP.equals(serverHostName)) {
                try {
                    serverHostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("Failed to get the host name from the InetAddress localhost : " + e));
                }
            }
        }
    }

    public static String getServerIP() {
        return serverIP;
    }

    public static String getServerHostName() {
        return serverHostName;
    }

    public static String getRealServerHostName() {
        return realServerHostName;
    }

    public static void updateServerHostName(String envVarContainerHost, String envVarVcapApplication, String envVarDefaultHost) {
        String hostName = envVarContainerHost;
        if (ENV_VAR_CONTAINERHOST.equals(hostName)) {
            if (ENV_VAR_VCAP_APPLICATION.equals(envVarVcapApplication)) {
                hostName = envVarDefaultHost;
            } else {
                try {
                    JSONObject vcap = JSONObject.parse((String)envVarVcapApplication);
                    String applicationName = (String)vcap.get((Object)"application_name");
                    if (applicationName == null) {
                        applicationName = (String)vcap.get((Object)"name");
                    }
                    if (applicationName != null) {
                        hostName = applicationName;
                    }
                }
                catch (IOException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Failed to get the application from the vcap application env var. Setting host name to the default host. Exception was: " + e));
                    }
                    hostName = envVarDefaultHost;
                }
            }
        }
        if (VAR_DEFAULTHOSTNAME.equals(hostName) || hostName.equals("localhost")) {
            hostName = serverHostName;
        }
        serverHostName = hostName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using hostname: " + serverHostName));
        }
    }

    static {
        boolean isTraceOn;
        block10: {
            CLASS_NAME = ServerEnvironmentUtil.class.getName();
            tc = Tr.register(ServerEnvironmentUtil.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
            serverIP = null;
            serverHostName = null;
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            try {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"ServerEnvironmentUtil.cinit");
                }
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                ArrayList<NetworkInterface> p2p = new ArrayList<NetworkInterface>();
                for (NetworkInterface nic : Collections.list(nets)) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("NIC : " + nic));
                        Tr.debug((TraceComponent)tc, (String)("isUp : " + nic.isUp()));
                        Tr.debug((TraceComponent)tc, (String)("isVirtual : " + nic.isVirtual()));
                        Tr.debug((TraceComponent)tc, (String)("isLoopback : " + nic.isLoopback()));
                        Tr.debug((TraceComponent)tc, (String)("isPointToPoint : " + nic.isPointToPoint()));
                    }
                    if (!nic.isUp() || nic.isVirtual() || nic.isLoopback()) continue;
                    if (nic.isPointToPoint()) {
                        p2p.add(nic);
                        continue;
                    }
                    ServerEnvironmentUtil.setPreferredIpAndHostName(nic);
                }
                if (serverIP == null && !p2p.isEmpty()) {
                    for (NetworkInterface nic : p2p) {
                        ServerEnvironmentUtil.setPreferredIpAndHostName(nic);
                    }
                }
                if (serverIP == null && isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No IP address found for the server.");
                }
            }
            catch (SocketException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".<cinit>"), (String)"85");
                if (!isTraceOn || !tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)e.toString());
            }
        }
        realServerHostName = serverHostName;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ServerEnvironmentUtil.cinit");
        }
    }
}

