/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.Product;
import com.ibm.ws.usage.metering.common.ProductExtensionImpl;
import com.ibm.ws.usage.metering.common.Util;
import com.ibm.wsspi.usage.metering.Group;
import com.ibm.wsspi.usage.metering.MetricCapDescriptor;
import com.ibm.wsspi.usage.metering.MetricDescriptor;
import com.ibm.wsspi.usage.metering.ProductExtension;
import com.ibm.wsspi.usage.metering.RegistrationListener;
import com.ibm.wsspi.usage.metering.Usage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Tag
implements Product {
    private static final String CLASS_NAME = Tag.class.getName();
    private static final TraceComponent tc = Tr.register(Tag.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private String version;
    private String baseVersion;
    private String uniqueId;
    private String persistentId;
    private String name;
    private ProductExtension extension;
    private final Map<String, Object> productData = new HashMap<String, Object>();
    private Set<String> productMetricTypes;
    private boolean enabled = false;

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = this.getPatchVersion(this.baseVersion);
        }
        return this.version != null ? this.version : this.baseVersion;
    }

    public void setVersion(String version) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setVersion : " + version));
        }
        this.version = version;
    }

    public void setBaseVersion(String version) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBaseVersion : " + version));
        }
        this.baseVersion = version;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setUniqueId : " + uniqueId));
        }
        this.uniqueId = uniqueId;
    }

    @Override
    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String persistentId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setPersistentId : " + persistentId));
        }
        this.persistentId = persistentId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setName : " + name));
        }
        this.name = name;
    }

    public void setProductExtension(ProductExtension extension) {
        this.extension = extension;
    }

    @Override
    public int getProductWeight() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getProductWeight : " + this.persistentId));
        }
        int weight = 300;
        try {
            if (this.extension != null) {
                weight = this.extension.getProductWeight();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getProductWeight"), (String)"116", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_STACK_PROD_EXCEPTION_CWWKR0435W", (Object)this.name);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProductWeight : " + weight));
        }
        return weight;
    }

    @Override
    public String getPatchVersion(String baseVersion) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPatchVersion : " + this.persistentId + ", " + baseVersion));
        }
        try {
            String patchVersion;
            String string = patchVersion = this.extension != null ? this.extension.getPatchVersion(baseVersion) : null;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getPatchVersion: " + patchVersion));
            }
            return patchVersion;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getPatchVersion"), (String)"138", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_STACK_PROD_EXCEPTION_CWWKR0435W", (Object)this.name);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getPatchVersion: " + null));
            }
            return null;
        }
    }

    @Override
    public Set<String> getApars() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getApars : " + this.persistentId));
        }
        try {
            Set<String> apars;
            Set<String> set = apars = this.extension != null ? this.extension.getApars() : null;
            if (apars == null) {
                apars = Collections.emptySet();
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getApars: " + apars));
            }
            return apars;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getApars"), (String)"163", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_STACK_PROD_EXCEPTION_CWWKR0435W", (Object)this.name);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getApars: " + null));
            }
            return null;
        }
    }

    @Override
    public Set<MetricDescriptor> getMetricDescriptors(List<Group> groups) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMetricDescriptors : " + this.persistentId));
        }
        try {
            Set<MetricDescriptor> metricDescriptors = this.extension != null ? this.extension.getMetricDescriptors(groups) : null;
            this.productMetricTypes = new HashSet<String>();
            if (metricDescriptors != null) {
                for (MetricDescriptor descriptor : metricDescriptors) {
                    this.productMetricTypes.add(descriptor.getType());
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setting productMetricTypes: " + this.productMetricTypes));
                }
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getMetricDescriptors: " + metricDescriptors));
            }
            return metricDescriptors;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getMetricDescriptors"), (String)"198", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_STACK_PROD_EXCEPTION_CWWKR0435W", (Object)this.name);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getMetricDescriptors: " + null));
            }
            return null;
        }
    }

    @Override
    public Set<String> getMetricTypes() {
        if (this.productMetricTypes == null) {
            throw new IllegalStateException("The metric types for product (" + this.name + ") have not been set.");
        }
        return this.productMetricTypes;
    }

    @Override
    public MetricCapDescriptor getMetricCapDescriptor() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMetricCapDescriptor : " + this.persistentId));
        }
        try {
            MetricCapDescriptor descriptor;
            MetricCapDescriptor metricCapDescriptor = descriptor = this.extension != null ? this.extension.getMetricCapDescriptor() : null;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getMetricCapDescriptor: " + descriptor));
            }
            return descriptor;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getMetricCapDescriptor"), (String)"253", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_STACK_PROD_EXCEPTION_CWWKR0435W", (Object)this.name);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getMetricCapDescriptor: " + null));
            }
            return null;
        }
    }

    @Override
    public Map<String, Object> getProductSpecificData() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getProductSpecificData : " + this.persistentId));
        }
        try {
            Map<String, Object> psd;
            Map<String, Object> map = psd = this.extension != null ? this.extension.getProductSpecificData() : this.productData;
            if (psd == null) {
                psd = Collections.emptyMap();
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getProductSpecificData: " + psd));
            }
            return psd;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getProductSpecificData"), (String)"230", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_STACK_PROD_EXCEPTION_CWWKR0435W", (Object)this.name);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getProductSpecificData: " + null));
            }
            return null;
        }
    }

    @Override
    public List<Group> getGroups(List<Group> combinedGroups) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getGroups : " + this.persistentId));
        }
        try {
            List<Group> groups;
            List<Group> list = groups = this.extension != null ? this.extension.getGroups(combinedGroups) : combinedGroups;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getGroups: " + Util.identity(groups)));
            }
            return groups;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getGroups"), (String)"237", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REGISTRATION_STACK_PROD_EXCEPTION_CWWKR0435W", (Object)this.name);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getGroups: " + Util.identity(combinedGroups)));
            }
            return combinedGroups;
        }
    }

    @Override
    public void setRegistrationListener(RegistrationListener listener) {
        boolean isTraceOn;
        block6: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("setRegistrationListener: " + listener));
            }
            try {
                if (this.extension != null) {
                    this.extension.setRegistrationListener(listener);
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"setRegistrationListener: on extension");
                    }
                    return;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setRegistrationListener"), (String)"259", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"STACK_PROD_LISTENER_EXCEPTION_CWWKR0434W", (Object)this.name);
                if (!isTraceOn || !tc.isEntryEnabled()) break block6;
                Tr.exit((TraceComponent)tc, (String)"setRegistrationListener: error setting listener");
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRegistrationListener: no extension present");
        }
    }

    @Override
    public void enableUsageDataCollection(boolean enable) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("enableUsageDataCollection : " + this.persistentId + ", " + enable));
        }
        try {
            this.enabled = enable;
            if (this.extension != null) {
                this.extension.enableUsageDataCollection(enable);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".enableUsageDataCollection"), (String)"280", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0433W", (Object)new Object[]{this.name, e.getCause() != null ? e.getCause().toString() : e.toString()});
            this.enabled = false;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enableUsageDataCollection");
        }
    }

    @Override
    public void resetUsageDataCollection() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resetUsageDataCollection : " + this.persistentId));
        }
        try {
            if (this.extension != null) {
                this.extension.resetUsageDataCollection();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".resetUsageDataCollection"), (String)"302", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0432W", (Object)new Object[]{this.name, e.getCause() != null ? e.getCause().toString() : e.toString()});
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetUsageDataCollection");
        }
    }

    @Override
    public Usage getCurrentUsage() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCurrentUsage : " + this.persistentId));
        }
        if (!this.enabled) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCurrentUsage: not enabled");
            }
            return null;
        }
        try {
            Usage usage;
            Usage usage2 = usage = this.extension != null ? this.extension.getCurrentUsage() : null;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getCurrentUsage: " + Util.identity(usage)));
            }
            return usage;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getCurrentUsage"), (String)"330", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0431W", (Object)new Object[]{this.name, e.getCause() != null ? e.getCause().toString() : e.toString()});
            this.resetUsageDataCollection();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getCurrentUsage: " + null));
            }
            return null;
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(Product o) {
        int compWeight;
        if (this.equals(o)) {
            return 0;
        }
        int thisWeight = this.getProductWeight();
        if (thisWeight != (compWeight = o.getProductWeight())) {
            return thisWeight - compWeight;
        }
        return this.persistentId.compareTo(o.getPersistentId());
    }

    @Override
    public boolean isWebSphere() {
        return this.extension instanceof ProductExtensionImpl;
    }
}

