/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class TranslationHelper {
    private static final String CLASS_NAME = TranslationHelper.class.getName();
    private static final TraceComponent tc = Tr.register(TranslationHelper.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static final String[] LANGUAGES = new String[]{"en", "zh", "ru", "ro", "pl", "ko", "ja", "it", "hu", "fr", "es", "de", "cs"};
    private final Map<Locale, ResourceBundle> resourceBundles = new HashMap<Locale, ResourceBundle>();

    public TranslationHelper() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String language : LANGUAGES) {
            locales.add(new Locale(language));
        }
        locales.add(new Locale("pt", "BR"));
        locales.add(new Locale("zh", "TW"));
        for (Locale locale : locales) {
            try {
                ResourceBundle resourceBundle = TraceNLS.getResourceBundle((String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages", (Locale)locale);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("TranslationHelper: " + locale + " -> " + resourceBundle));
                }
                if (resourceBundle == null) continue;
                this.resourceBundles.put(locale, resourceBundle);
            }
            catch (RuntimeException rex) {
                FFDCFilter.processException((Throwable)rex, (String)(CLASS_NAME + ".<ctor>"), (String)"59", (Object)this, (Object[])new Object[]{locale});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("TranslationHelper: " + locale + " -> " + rex));
            }
        }
    }

    public Map<String, String> getTranslatedNames(String msgKey) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTranslatedNames : " + msgKey));
        }
        HashMap<String, String> translatedNames = new HashMap<String, String>();
        for (Map.Entry<Locale, ResourceBundle> entry : this.resourceBundles.entrySet()) {
            String message = entry.getValue().getString(msgKey);
            if (message == null || message.equals("")) {
                message = msgKey;
            }
            translatedNames.put(entry.getKey().toString(), message);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTranslatedNames : " + translatedNames.size()));
        }
        return translatedNames;
    }
}

