/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.CollectUsageTask;
import com.ibm.ws.usage.metering.common.MeteringConstants;
import com.ibm.ws.usage.metering.common.MetricImpl;
import com.ibm.ws.usage.metering.common.Util;
import com.ibm.ws.usage.metering.common.exceptions.MeteringException;
import com.ibm.wsspi.usage.metering.Metric;
import com.ibm.wsspi.usage.metering.Usage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class UsageImpl
implements Usage {
    private static final String CLASS_NAME;
    private static final TraceComponent tc;
    protected static final MBeanServer SERVER_MBEAN;
    protected static final MemoryMXBean MEMORY_MBEAN;
    protected static final List<GarbageCollectorMXBean> GC_MBEANS;
    private static final long MEGABYTES = 0x100000L;
    private static final String OVERRIDE_PROCESSOR_CORES_SYSTEM_VAR = "USAGE_METERING_PROCESSOR_CORES";
    private static final String OVERRIDE_PROCESSOR_CORES_JVM_VAR = "com.ibm.websphere.usage.metering.processorCores";
    private static boolean ProcessorCoresFromFile;
    private static double ProcessorCores;
    private static final double RUNTIME_AVAILABLE_PROCESSORS;
    private static final int CPU_NS_FACTOR;
    private final String optionalMetrics;
    private static final AtomicLong CPU_TIME;
    private static final AtomicBoolean CPU_TIME_FAILURE;
    private static final AtomicLong TOTAL_SERVLET_REQUESTS;
    private static volatile ObjectName OPER_SYS_QUERY;
    private static final Class<?> garbageCollectorMXBeanClass;
    private static final List<MetricImpl.Type> METRIC_TYPES;
    private final MemoryUsage memoryUsage;
    private Map<String, Object> productSpecificData;
    private Collection<Metric> metrics;

    public static boolean removeMetricType(MetricImpl.Type metric) {
        return METRIC_TYPES.remove((Object)metric);
    }

    protected UsageImpl(String optionalMetrics) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init>: JDK (" + MeteringConstants.JAVA_VENDOR + ") on OS (" + MeteringConstants.OS_NAME + ")"));
        }
        this.optionalMetrics = optionalMetrics;
        this.memoryUsage = MEMORY_MBEAN.getHeapMemoryUsage();
        this.setMetrics(this.collectMetrics());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", this.getMetrics());
        }
    }

    @Override
    public Collection<Metric> getMetrics() {
        return this.metrics;
    }

    protected void setMetrics(Collection<Metric> metrics) {
        this.metrics = metrics;
    }

    @Override
    public String getEnvironmentType() {
        return null;
    }

    @Override
    public Map<String, Object> getProductSpecificData() {
        if (this.productSpecificData == null) {
            this.productSpecificData = new HashMap<String, Object>();
        }
        return this.productSpecificData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Metric> collectMetrics() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"collectMetrics");
        }
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        List<MetricImpl.Type> list = METRIC_TYPES;
        synchronized (list) {
            Iterator<MetricImpl.Type> iterator = METRIC_TYPES.iterator();
            while (iterator.hasNext()) {
                Metric metric = this.getMetric(iterator);
                if (metric == null) continue;
                metrics.add(metric);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"collectMetrics", metrics);
        }
        return metrics;
    }

    private Metric getMetric(Iterator<MetricImpl.Type> iterator) {
        MetricImpl.Type type = iterator.next();
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMetric: " + (Object)((Object)type)));
        }
        MetricImpl metric = null;
        if (this.optionalMetrics != null && !this.optionalMetrics.equals("ALL")) {
            String expr = "(,|\\A)" + type.toString() + "(,|\\Z)";
            if (!(type.isRequired() || !this.optionalMetrics.equals("NONE") && Pattern.compile(expr).matcher(this.optionalMetrics).find())) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("optionalMetrics is configured and does not specify " + type.toString() + " we will not collect usage for " + type.toString()));
                }
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getMetric: " + metric));
                }
                return null;
            }
        }
        switch (type) {
            case PROCESSOR_CORES: {
                if (CollectUsageTask.RequestUsage.threadRequestUsage == null || CollectUsageTask.RequestUsage.threadRequestUsage.get() == null) {
                    if (!isTraceOn || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"RequestUsage.threadRequestUsage is not available. Skipping Processor Coress metric");
                    break;
                }
                if (!ProcessorCoresFromFile) {
                    metric = new MetricImpl(MetricImpl.Type.PROCESSOR_CORES, ProcessorCores);
                    break;
                }
                Double processorCores = UsageImpl.getProcessorCoresFromFilesystem();
                if (processorCores == null || processorCores <= 0.0 || processorCores > RUNTIME_AVAILABLE_PROCESSORS) {
                    if (processorCores != null && isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Processor cores override, " + processorCores + ", out of range; defaulting to runtime available processors : " + RUNTIME_AVAILABLE_PROCESSORS));
                    }
                    processorCores = RUNTIME_AVAILABLE_PROCESSORS;
                }
                if (ProcessorCores != processorCores) {
                    ProcessorCores = processorCores;
                    Tr.info((TraceComponent)tc, (String)"FOUND_PROCESSOR_CORES_CWWKR0427I", (Object)new Object[]{ProcessorCores});
                }
                metric = new MetricImpl(MetricImpl.Type.PROCESSOR_CORES, ProcessorCores);
                break;
            }
            case CPU_TIME: {
                try {
                    long previousTime = CPU_TIME.get();
                    long currentTime = this.getCpuTime();
                    if (currentTime >= 0L) {
                        boolean lastCPUTimeFailue = CPU_TIME_FAILURE.get();
                        CPU_TIME_FAILURE.set(false);
                        CPU_TIME.set(currentTime);
                        if (lastCPUTimeFailue) break;
                        long time = TimeUnit.MILLISECONDS.convert(CPU_TIME.get() - previousTime, TimeUnit.NANOSECONDS);
                        metric = new MetricImpl(MetricImpl.Type.CPU_TIME, time);
                        break;
                    }
                    Tr.info((TraceComponent)tc, (String)"METRIC_NOT_SUPPORTED_CWWKR0410I", (Object)new Object[]{MetricImpl.Type.CPU_TIME, MeteringConstants.OS_NAME, MeteringConstants.JAVA_VENDOR});
                    iterator.remove();
                }
                catch (MeteringException pie) {
                    CPU_TIME_FAILURE.set(true);
                    if (pie.getCause() instanceof AttributeNotFoundException) {
                        Tr.info((TraceComponent)tc, (String)"METRIC_NOT_SUPPORTED_CWWKR0410I", (Object)new Object[]{MetricImpl.Type.CPU_TIME, MeteringConstants.OS_NAME, MeteringConstants.JAVA_VENDOR});
                        iterator.remove();
                        break;
                    }
                    FFDCFilter.processException((Throwable)pie, (String)(CLASS_NAME + ".getMetric"), (String)"173", (Object)this);
                }
                break;
            }
            case TOTAL_PHYSICAL_MEMORY: {
                try {
                    long totalPhysicalMemoryAttr = this.getTotalPhysicalMemory() / 0x100000L;
                    metric = new MetricImpl(MetricImpl.Type.TOTAL_PHYSICAL_MEMORY, totalPhysicalMemoryAttr);
                }
                catch (MeteringException pie) {
                    if (pie.getCause() instanceof AttributeNotFoundException) {
                        Tr.info((TraceComponent)tc, (String)"METRIC_NOT_SUPPORTED_CWWKR0410I", (Object)new Object[]{MetricImpl.Type.TOTAL_PHYSICAL_MEMORY, MeteringConstants.OS_NAME, MeteringConstants.JAVA_VENDOR});
                        iterator.remove();
                        break;
                    }
                    FFDCFilter.processException((Throwable)pie, (String)(CLASS_NAME + ".getMetric"), (String)"186", (Object)this);
                }
                break;
            }
            case JAVA_INIT_MEMORY: {
                metric = new MetricImpl(MetricImpl.Type.JAVA_INIT_MEMORY, this.memoryUsage.getInit() / 0x100000L);
                break;
            }
            case JAVA_USED_MEMORY: {
                metric = new MetricImpl(MetricImpl.Type.JAVA_USED_MEMORY, this.memoryUsage.getUsed() / 0x100000L);
                break;
            }
            case JAVA_COMMITTED_MEMORY: {
                metric = new MetricImpl(MetricImpl.Type.JAVA_COMMITTED_MEMORY, this.memoryUsage.getCommitted() / 0x100000L);
                break;
            }
            case JAVA_MAX_MEMORY: {
                metric = new MetricImpl(MetricImpl.Type.JAVA_MAX_MEMORY, this.memoryUsage.getMax() / 0x100000L);
                break;
            }
            case JAVA_MEMORY_AFTER_GC: {
                try {
                    long usedMemoryAfterLastGc = UsageImpl.getUsedMemoryAfterLastGc() / 0x100000L;
                    metric = new MetricImpl(MetricImpl.Type.JAVA_MEMORY_AFTER_GC, usedMemoryAfterLastGc);
                }
                catch (MeteringException pie) {
                    if (pie.getCause() instanceof ClassNotFoundException || pie.getCause() instanceof NoSuchMethodException) {
                        Tr.info((TraceComponent)tc, (String)"METRIC_NOT_SUPPORTED_CWWKR0410I", (Object)new Object[]{MetricImpl.Type.JAVA_MEMORY_AFTER_GC, MeteringConstants.OS_NAME, MeteringConstants.JAVA_VENDOR});
                        iterator.remove();
                        break;
                    }
                    FFDCFilter.processException((Throwable)pie, (String)(CLASS_NAME + ".getMetric"), (String)"328", (Object)this);
                }
                break;
            }
            case SERVLET_REQUESTS: {
                try {
                    Long total = this.getServletRequestTotal();
                    if (total != null) {
                        if (total < 0L) break;
                        long previousTotal = TOTAL_SERVLET_REQUESTS.get();
                        TOTAL_SERVLET_REQUESTS.set(total);
                        metric = new MetricImpl(MetricImpl.Type.SERVLET_REQUESTS, TOTAL_SERVLET_REQUESTS.get() - previousTotal);
                        break;
                    }
                    if (TOTAL_SERVLET_REQUESTS.get() <= 0L) break;
                    TOTAL_SERVLET_REQUESTS.set(0L);
                }
                catch (MeteringException pie) {
                    FFDCFilter.processException((Throwable)pie, (String)(CLASS_NAME + ".getMetric"), (String)"222", (Object)this);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + (Object)((Object)type) + " is not a known type!");
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getMetric: " + metric));
        }
        return metric;
    }

    protected Long getCpuTime() throws MeteringException {
        try {
            return (Long)SERVER_MBEAN.getAttribute(OPER_SYS_QUERY, "ProcessCpuTime") * (long)CPU_NS_FACTOR;
        }
        catch (Exception e) {
            MeteringException pie = new MeteringException("Failure obtaining ProcessCpuTime from OperatingSystemMXBean.", (Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getCpuTime: " + pie));
            }
            throw pie;
        }
    }

    protected static Long getUsedMemoryAfterLastGc() throws MeteringException {
        List<GarbageCollectorMXBean> gcMxBeans;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsedMemoryAfterLastGc");
        }
        if (garbageCollectorMXBeanClass == null) {
            MeteringException pie = new MeteringException("getLastGcInfo not supported", (Throwable)new ClassNotFoundException("GarbageCollectorMXBean"));
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getUsedMemoryAfterLastGc: " + pie));
            }
            throw pie;
        }
        try {
            gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        }
        catch (Throwable e) {
            MeteringException pie = new MeteringException("Failure obtaining GarbageCollectorMXBeans.", e);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getUsedMemoryAfterLastGc: " + pie));
            }
            throw pie;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of gcMxBeans: " + gcMxBeans.size()));
        }
        Map usageAfterGc = null;
        Long totalUsedAfterGc = 0L;
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            MeteringException pie;
            garbageCollectorMXBeanClass.cast(gcMxBean);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Collecting for: " + gcMxBean.toString()));
            }
            try {
                Object lastGcInfo = garbageCollectorMXBeanClass.getMethod("getLastGcInfo", new Class[0]).invoke((Object)gcMxBean, new Object[0]);
                if (lastGcInfo != null) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("lastGcInfo: " + lastGcInfo.toString()));
                    }
                    usageAfterGc = (Map)lastGcInfo.getClass().getDeclaredMethod("getMemoryUsageAfterGc", new Class[0]).invoke(lastGcInfo, new Object[0]);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("usageAfterGc: " + usageAfterGc.toString()));
                    }
                    Long usedMemoryAfterGC = 0L;
                    Collection values = usageAfterGc.values();
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Number of MemoryUsage values " + values.size()));
                    }
                    for (MemoryUsage memUsage : values) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getting used memory for " + memUsage.toString()));
                        }
                        usedMemoryAfterGC = usedMemoryAfterGC + memUsage.getUsed();
                    }
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("usedMemoryAfterGC: " + usedMemoryAfterGC));
                    }
                    String name = (String)garbageCollectorMXBeanClass.getMethod("getName", new Class[0]).invoke((Object)gcMxBean, new Object[0]);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("name: " + name));
                    }
                    Long endTime = (Long)lastGcInfo.getClass().getDeclaredMethod("getEndTime", new Class[0]).invoke(lastGcInfo, new Object[0]);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("endTime: " + endTime));
                    }
                    totalUsedAfterGc = totalUsedAfterGc + usedMemoryAfterGC;
                    continue;
                }
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("lastGcInfo null for " + gcMxBean.toString()));
            }
            catch (NoSuchMethodException e) {
                pie = new MeteringException("getLastGcInfo not supported", (Throwable)e);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getUsedMemoryAfterLastGc: " + pie));
                }
                throw pie;
            }
            catch (Throwable e) {
                pie = new MeteringException("Failure obtaining the last gc info from GarbageCollectorMXBeans.", e);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getUsedMemoryAfterLastGc: " + pie));
                }
                throw pie;
            }
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("totalUsedAfterGc: " + totalUsedAfterGc));
        }
        return totalUsedAfterGc;
    }

    protected Long getTotalPhysicalMemory() throws MeteringException {
        String totalPhysicalMemory = null;
        if (MeteringConstants.JAVA_VENDOR != null && MeteringConstants.OS_NAME != null) {
            totalPhysicalMemory = MeteringConstants.JAVA_VENDOR.toLowerCase().contains("ibm") ? "TotalPhysicalMemory" : "TotalPhysicalMemorySize";
        }
        try {
            return (Long)SERVER_MBEAN.getAttribute(OPER_SYS_QUERY, totalPhysicalMemory);
        }
        catch (Exception e) {
            MeteringException pie = new MeteringException("Failure obtaining " + totalPhysicalMemory + " from OperatingSystemMXBean.", (Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getTotalPhysicalMemory: " + pie));
            }
            throw pie;
        }
    }

    private static Double getProcessorCoresOverrideFromVars() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        Double processorCores = null;
        String overrideVar = OVERRIDE_PROCESSOR_CORES_SYSTEM_VAR;
        String apOverride = System.getenv(overrideVar);
        if (apOverride == null) {
            overrideVar = OVERRIDE_PROCESSOR_CORES_JVM_VAR;
            apOverride = System.getProperty(overrideVar);
            if (isTraceOn && tc.isDebugEnabled() && apOverride != null) {
                Tr.debug((TraceComponent)tc, (String)("Using jvm variable to override processor cores. New value is: " + apOverride));
            }
        } else if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using system variable to override processor cores. New value is: " + apOverride));
        }
        if (apOverride != null) {
            try {
                processorCores = new Double(apOverride);
                processorCores = UsageImpl.roundToTwoDecimalPlaces(processorCores);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Overriding processor cores to: " + processorCores));
                }
            }
            catch (NumberFormatException nfe) {
                Tr.warning((TraceComponent)tc, (String)"INVALID_PROCESSOR_CORES_CWWKR0426W", (Object)new Object[]{apOverride, overrideVar});
            }
        }
        return processorCores;
    }

    private static Double getProcessorCoresFromFilesystem() {
        Double processorCores;
        boolean isTraceOn;
        block12: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getProcessorCoresFromFilesystem");
            }
            processorCores = null;
            String periodFileLocation = File.separator + "sys" + File.separator + "fs" + File.separator + "cgroup" + File.separator + "cpu" + File.separator + "cpu.cfs_period_us";
            String quotaFileLocation = File.separator + "sys" + File.separator + "fs" + File.separator + "cgroup" + File.separator + "cpu" + File.separator + "cpu.cfs_quota_us";
            File cfsPeriod = new File(periodFileLocation);
            File cfsQuota = new File(quotaFileLocation);
            if (cfsPeriod.exists() || cfsQuota.exists()) {
                ProcessorCoresFromFile = true;
            }
            if (cfsPeriod.exists() && cfsQuota.exists()) {
                try {
                    String quotaContents = UsageImpl.readFile(cfsQuota);
                    double quotaFloat = new Double(quotaContents);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("quotaFloat = " + quotaFloat));
                    }
                    if (!(quotaFloat >= 0.0)) break block12;
                    String periodContents = UsageImpl.readFile(cfsPeriod);
                    double periodFloat = new Double(periodContents);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("periodFloat = " + periodFloat));
                    }
                    processorCores = quotaFloat / periodFloat;
                    processorCores = UsageImpl.roundToTwoDecimalPlaces(processorCores);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Calculated processorCores: " + processorCores + ". period=" + periodFloat + ", quota=" + quotaFloat));
                    }
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getProcessorCoresFromFilesystem"), (String)"569");
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Caught exception: " + e.getMessage() + ". Using number of processors reported by java"));
                    }
                    processorCores = null;
                }
            } else if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Files " + quotaFileLocation + " : " + cfsQuota.exists()));
                Tr.debug((TraceComponent)tc, (String)("Files " + periodFileLocation + " : " + cfsPeriod.exists()));
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProcessorCoresFromFilesystem: " + processorCores));
        }
        return processorCores;
    }

    private static String readFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
        String line = buf.readLine();
        StringBuilder sb = new StringBuilder();
        while (line != null) {
            sb.append(line).append("\n");
            line = buf.readLine();
        }
        buf.close();
        ((InputStream)is).close();
        return sb.toString();
    }

    private static Double roundToTwoDecimalPlaces(Double d) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(2, RoundingMode.DOWN);
        return bd.doubleValue();
    }

    protected abstract Long getServletRequestTotal() throws MeteringException;

    public static void reset() {
    }

    static {
        Class<?> temp;
        CLASS_NAME = UsageImpl.class.getName();
        tc = Tr.register(UsageImpl.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
        SERVER_MBEAN = ManagementFactory.getPlatformMBeanServer();
        MEMORY_MBEAN = ManagementFactory.getMemoryMXBean();
        GC_MBEANS = ManagementFactory.getGarbageCollectorMXBeans();
        CPU_TIME = new AtomicLong();
        CPU_TIME_FAILURE = new AtomicBoolean();
        TOTAL_SERVLET_REQUESTS = new AtomicLong();
        OPER_SYS_QUERY = null;
        METRIC_TYPES = Collections.synchronizedList(new ArrayList<MetricImpl.Type>(Arrays.asList(MetricImpl.Type.values())));
        try {
            OPER_SYS_QUERY = new ObjectName("java.lang", "type", "OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".<cinit>"), (String)"72");
        }
        RUNTIME_AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
        ProcessorCoresFromFile = false;
        Double processorCores = UsageImpl.getProcessorCoresOverrideFromVars();
        if (processorCores == null) {
            processorCores = UsageImpl.getProcessorCoresFromFilesystem();
        }
        if (processorCores == null || processorCores <= 0.0 || processorCores > RUNTIME_AVAILABLE_PROCESSORS) {
            if (processorCores != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processor cores override, " + processorCores + ", out of range; defaulting to runtime available processors : " + RUNTIME_AVAILABLE_PROCESSORS));
            }
            processorCores = RUNTIME_AVAILABLE_PROCESSORS;
        }
        if ((ProcessorCores = processorCores.doubleValue()) != RUNTIME_AVAILABLE_PROCESSORS) {
            Tr.info((TraceComponent)tc, (String)"FOUND_PROCESSOR_CORES_CWWKR0427I", (Object)new Object[]{ProcessorCores});
        }
        try {
            temp = Class.forName("com.ibm.lang.management.GarbageCollectorMXBean", false, null);
            if (Util.MAJOR == 8 && Util.UPDATE <= 192 || Util.MAJOR == 9 || Util.MAJOR == 10 || Util.MAJOR == 11 && MeteringConstants.JAVA_VERSION.contains("internal")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JAVA_MEMORY_AFTER_GC has been disabled for com.ibm.lang.management.GarbageCollectorMXBean : " + Util.MAJOR + ", " + Util.UPDATE));
                }
                temp = null;
            }
        }
        catch (ClassNotFoundException cnf) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"com.ibm.lang.management.GarbageCollectorMXBean not found, trying com.sun.management.GarbageCollectorMXBean next.");
            }
            try {
                temp = Class.forName("com.sun.management.GarbageCollectorMXBean");
            }
            catch (ClassNotFoundException e) {
                Tr.debug((TraceComponent)tc, (String)"No GarbageCollectorMXBean found.");
                temp = null;
            }
        }
        garbageCollectorMXBeanClass = temp;
        int nsFactor = 1;
        if (Util.VENDOR == Util.Vendor.IBM) {
            int majorVersion = Util.MAJOR;
            int minorVersion = Util.MINOR;
            int serviceRelease = Util.SERVICE_RELEASE;
            if (majorVersion <= 7) {
                nsFactor = 100;
            } else if (majorVersion == 8 && minorVersion == 0 && serviceRelease < 5) {
                nsFactor = 100;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"IBM Java level check", (Object)("majorVersion: " + majorVersion + ", minorVersion: " + minorVersion + ", serviceRelease: " + serviceRelease + ", cpuNSFactor: " + nsFactor));
            }
        }
        CPU_NS_FACTOR = nsFactor;
    }
}

