/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.json.java.JSONObject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.usage.metering.common.CollectUsageTask;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.Product;
import com.ibm.ws.usage.metering.common.SendUsageTask;
import com.ibm.ws.usage.metering.common.TaskScheduler;
import com.ibm.ws.usage.metering.common.Util;
import com.ibm.wsspi.usage.metering.RegistrationListener;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class UsageTask
implements Runnable {
    private static final String CLASS_NAME = UsageTask.class.getName();
    private static final TraceComponent tc = Tr.register(UsageTask.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static final String USAGE_INTERVAL_PROPERTY = "com.ibm.ws.usage.metering.usage.interval";
    private static final String MAX_QUEUE_SIZE_PROPERTY = "com.ibm.ws.usage.metering.max.queue.size";
    public static final int MAX_QUEUE_SIZE;
    public static final int DEFAULT_MAX_QUEUE_SIZE = 96;
    public static final long COLLECTION_INTERVAL;
    public static final TimeUnit INTERVALTIMEUNIT;
    public static final long COLLECTION_INTERVAL_MS;
    public static final int PRODUCT_USAGE_COLLECTION_TIMEOUT = 2;
    public static final int SEND_USAGE_TIMEOUT = 3;
    public static final TimeUnit TIMEOUTUNIT;
    private static final long minimumLateThreshhold;
    private static final long lateThreshhold;
    private final MeteringMetadata data;
    private final TaskScheduler scheduler;
    private final List<Product> products;
    private final RegistrationListener registrationListener;
    private final Queue<JSONObject> queue = new LinkedList<JSONObject>();
    private Future<?> usageTaskFuture;
    private Future<?> collectUsageTaskFuture;
    private Future<?> sendUsageTaskFuture;
    private volatile long collectionStartTime = -1L;
    private volatile long collectionEndTime = -1L;

    public UsageTask(MeteringMetadata data, TaskScheduler scheduler, List<Product> products, RegistrationListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + Util.identity(this)));
        }
        this.data = data;
        this.scheduler = scheduler;
        this.products = products;
        this.registrationListener = listener;
    }

    @Override
    public synchronized void run() {
        long delay;
        long currentTime;
        boolean isTraceOn;
        block28: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"run");
            }
            try {
                long timeoutBuffer = TimeUnit.MILLISECONDS.convert(3L, TIMEOUTUNIT);
                if (COLLECTION_INTERVAL_MS < timeoutBuffer) {
                    timeoutBuffer = COLLECTION_INTERVAL_MS / 5L;
                }
                if (this.collectionStartTime == -1L || this.collectionEndTime == -1L) {
                    this.collectionStartTime = System.currentTimeMillis();
                    this.collectionEndTime = this.collectionStartTime + COLLECTION_INTERVAL_MS;
                } else if (this.checkIfLate(this.collectionEndTime)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"UsageTask: running late, resetting");
                    }
                    for (Product p : this.products) {
                        p.resetUsageDataCollection();
                    }
                    this.collectionStartTime = System.currentTimeMillis();
                    this.collectionEndTime = this.collectionStartTime + COLLECTION_INTERVAL_MS;
                } else {
                    long currentCollectionInterval = this.collectionEndTime - this.collectionStartTime;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("collectionStartTime " + Long.valueOf(this.collectionStartTime).toString()));
                        Tr.debug((TraceComponent)tc, (String)("collectionEndTime " + Long.valueOf(this.collectionEndTime).toString()));
                        Tr.debug((TraceComponent)tc, (String)("collectionIntervalMilliseconds " + Long.valueOf(currentCollectionInterval).toString()));
                    }
                    this.collectUsageTaskFuture = this.scheduler.submit(new CollectUsageTask(this.data, this.scheduler, this.products, this.queue, true, this.collectionStartTime, this.collectionEndTime));
                    if (currentCollectionInterval < COLLECTION_INTERVAL_MS && this.isEndOfMonth(this.collectionEndTime)) {
                        try {
                            this.collectUsageTaskFuture.get(3L, TIMEOUTUNIT);
                        }
                        catch (InterruptedException e) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"155", (Object)this);
                            Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0409W", (Object)(e.getCause() != null ? e.getCause().toString() : e.toString()));
                        }
                        catch (ExecutionException e) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("UsageTask.run(): ExecutionException occurred while waiting for usage before midnight: " + (e.getCause() != null ? e.getCause() : e)));
                            }
                        }
                        catch (TimeoutException e) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".run"), (String)"164", (Object)this);
                            Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0409W", (Object)(e.getCause() != null ? e.getCause().toString() : e.toString()));
                        }
                        long beginningOfMonthCollectionInterval = COLLECTION_INTERVAL_MS - currentCollectionInterval;
                        this.collectionStartTime = this.collectionEndTime + 1L;
                        this.collectionEndTime = this.collectionStartTime + beginningOfMonthCollectionInterval - 1L;
                        if (beginningOfMonthCollectionInterval < timeoutBuffer) {
                            this.collectionEndTime += COLLECTION_INTERVAL_MS;
                        }
                    } else {
                        this.sendUsageTaskFuture = this.scheduler.submit(new SendUsageTask(this.data, this.scheduler, this.queue, this.collectUsageTaskFuture, this.registrationListener, true));
                        this.collectionStartTime = this.collectionEndTime + 1L;
                        this.collectionEndTime = this.collectionStartTime + COLLECTION_INTERVAL_MS;
                        if (this.data.getUsageAdjustment() != -1L && !this.data.getResetUsageAdjustment()) {
                            this.collectionEndTime += this.data.getUsageAdjustment();
                            this.data.setResetUsageAdjustment(true);
                        }
                    }
                }
                Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                utcCalendar.setTimeInMillis(this.collectionStartTime);
                int startTimeMonth = utcCalendar.get(2);
                utcCalendar.setTimeInMillis(this.collectionEndTime + timeoutBuffer);
                int endTimeMonth = utcCalendar.get(2);
                if (startTimeMonth != endTimeMonth) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Detected the beginning of a new billing cycle. Splitting the usage interval.");
                        Tr.debug((TraceComponent)tc, (String)("collectionStartTime " + Long.valueOf(this.collectionStartTime).toString()));
                        Tr.debug((TraceComponent)tc, (String)("collectionEndTime was " + Long.valueOf(this.collectionEndTime).toString() + " with timeoutBuffer " + Long.valueOf(timeoutBuffer).toString()));
                    }
                    utcCalendar.setTimeInMillis(this.collectionEndTime + timeoutBuffer);
                    utcCalendar.set(11, 0);
                    utcCalendar.set(12, 0);
                    utcCalendar.set(13, 0);
                    utcCalendar.set(14, 0);
                    this.collectionEndTime = utcCalendar.getTimeInMillis() - 1L;
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".run"), (String)"214", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"USAGE_EXCEPTION_CWWKR0409W", (Object)(t.getCause() != null ? t.getCause().toString() : t.toString()));
                this.collectionStartTime = System.currentTimeMillis();
                this.collectionEndTime = this.collectionStartTime + COLLECTION_INTERVAL_MS;
            }
            currentTime = System.currentTimeMillis();
            delay = this.collectionEndTime - currentTime;
            if (delay < 0L && this.collectUsageTaskFuture != null && !this.collectUsageTaskFuture.isDone()) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"UsageTask: running late, waiting for collection up to late threshold");
                    }
                    this.collectUsageTaskFuture.get(minimumLateThreshhold, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block28;
                    Tr.debug((TraceComponent)tc, (String)("UsageTask: wait for late collection incomplete : " + e));
                }
            }
        }
        this.usageTaskFuture = this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current time " + Long.valueOf(currentTime).toString()));
            Tr.debug((TraceComponent)tc, (String)("delay " + Long.valueOf(delay).toString()));
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    private boolean checkIfLate(long endTime) {
        long currentTime;
        long howLate;
        boolean isLate;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkIfLate: " + endTime));
        }
        boolean bl = isLate = (howLate = (currentTime = System.currentTimeMillis()) - (endTime + lateThreshhold)) > 0L;
        if (isLate) {
            Tr.warning((TraceComponent)tc, (String)"USAGE_LATE_WARNING_CWWKR0438W", (Object)TimeUnit.MINUTES.convert(howLate, TimeUnit.MILLISECONDS));
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkIfLate: " + isLate));
        }
        return isLate;
    }

    private boolean isEndOfMonth(long utcTime) {
        Calendar nextMonth = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        nextMonth.setTimeInMillis(utcTime + 1L);
        return nextMonth.get(11) == 0 && nextMonth.get(12) == 0 && nextMonth.get(13) == 0 && nextMonth.get(14) == 0;
    }

    public synchronized void submitLastUsage(boolean waitForUsage) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"submitLastUsage");
        }
        if (this.collectionStartTime == -1L || this.usageTaskFuture == null) {
            return;
        }
        this.usageTaskFuture.cancel(true);
        if (this.sendUsageTaskFuture != null && !this.sendUsageTaskFuture.isDone()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"a SendUsageTask is currently running. No usage tasks will be submitted.");
            }
        } else {
            long newIntervalEndTime = System.currentTimeMillis();
            if (newIntervalEndTime > this.collectionStartTime && (this.collectUsageTaskFuture == null || this.collectUsageTaskFuture.isDone())) {
                this.collectUsageTaskFuture = this.scheduler.submit(new CollectUsageTask(this.data, this.scheduler, this.products, this.queue, false, this.collectionStartTime, newIntervalEndTime));
            }
            this.sendUsageTaskFuture = this.scheduler.submit(new SendUsageTask(this.data, this.scheduler, this.queue, this.collectUsageTaskFuture, null, false));
        }
        if (waitForUsage) {
            this.waitForUsageTask();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"submitLastUsage");
        }
    }

    public synchronized void cancelUsageTask() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancelUsageTask");
        }
        if (this.usageTaskFuture != null && !this.usageTaskFuture.isDone()) {
            this.usageTaskFuture.cancel(true);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cancelUsageTask: usageTaskFuture");
            }
        }
        if (this.collectUsageTaskFuture != null && !this.collectUsageTaskFuture.isDone()) {
            this.collectUsageTaskFuture.cancel(true);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cancelUsageTask: collectUsageTaskFuture");
            }
        }
        if (this.sendUsageTaskFuture != null && !this.sendUsageTaskFuture.isDone()) {
            this.sendUsageTaskFuture.cancel(true);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cancelUsageTask: sendUsageTaskFuture");
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancelUsageTask");
        }
    }

    public synchronized void waitForUsageTask() {
        boolean isTraceOn;
        block9: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"waitForUsageTask");
            }
            if (this.sendUsageTaskFuture != null) {
                try {
                    this.sendUsageTaskFuture.get(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("waitForUsageTask: Interruption occurred while waiting for last usage: " + (e.getCause() != null ? e.getCause() : e)));
                    }
                }
                catch (ExecutionException e) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("waitForUsageTask: ExecutionException occurred while waiting for last usage: " + (e.getCause() != null ? e.getCause() : e)));
                    }
                }
                catch (TimeoutException e) {
                    if (!isTraceOn || !tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("waitForUsageTask: Timeout occurred while waiting for last usage: " + (e.getCause() != null ? e.getCause() : e)));
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"waitForUsageTask");
        }
    }

    public synchronized boolean isUsageDone() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isUsageDone");
        }
        if (this.sendUsageTaskFuture != null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isUsageDone: " + this.sendUsageTaskFuture.isDone()));
            }
            return this.sendUsageTaskFuture.isDone();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isUsageDone: No usage task scheduled - true");
        }
        return true;
    }

    static {
        TIMEOUTUNIT = TimeUnit.MINUTES;
        minimumLateThreshhold = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
        long defaultUsageInterval = 15L;
        TimeUnit timeUnit = TimeUnit.MINUTES;
        String usageIntValProp = System.getProperty(USAGE_INTERVAL_PROPERTY);
        if (usageIntValProp != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)USAGE_INTERVAL_PROPERTY, (Object)usageIntValProp);
            }
            try {
                Long usageIntervalInMillis = Long.valueOf(usageIntValProp);
                defaultUsageInterval = usageIntervalInMillis;
                timeUnit = TimeUnit.MILLISECONDS;
            }
            catch (NumberFormatException nfe) {
                FFDCFilter.processException((Throwable)nfe, (String)(CLASS_NAME + ".<cinit>"), (String)"63");
            }
        }
        String maxQueueValProp = System.getProperty(MAX_QUEUE_SIZE_PROPERTY);
        Integer maxQueueSize = 96;
        if (maxQueueValProp != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MAX_QUEUE_SIZE_PROPERTY, (Object)maxQueueValProp);
            }
            try {
                maxQueueSize = Integer.valueOf(maxQueueValProp);
                if (maxQueueSize < 1) {
                    maxQueueSize = 96;
                }
            }
            catch (NumberFormatException nfe) {
                maxQueueSize = 96;
                FFDCFilter.processException((Throwable)nfe, (String)(CLASS_NAME + ".<cinit>"), (String)"63");
            }
        }
        COLLECTION_INTERVAL = defaultUsageInterval;
        INTERVALTIMEUNIT = timeUnit;
        COLLECTION_INTERVAL_MS = TimeUnit.MILLISECONDS.convert(COLLECTION_INTERVAL, INTERVALTIMEUNIT);
        lateThreshhold = Math.max(minimumLateThreshhold, COLLECTION_INTERVAL_MS);
        MAX_QUEUE_SIZE = maxQueueSize;
    }
}

