/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.common.exceptions;

import com.ibm.ws.usage.metering.common.TrNLS;

public enum MeteringErrorCode {
    REGISTRATOR_MISSING_APIKEY,
    REGISTRATOR_MISSING_URL,
    REGISTRATOR_INVALID_URL,
    REGISTRATOR_INVALID_PROXY_URL,
    REGISTRATOR_URL_PROTOCOL_NOT_HTTPS,
    INTERNAL_CONFIG_SERVICE_EXCEPTION,
    INTERNAL_REGISTRATOR_MISSING_PATH,
    INTERNAL_MALFORMED_URL_EXCEPTION,
    INTERNAL_SSL_SUPPORT_UNAVAILABLE,
    INTERNAL_SSL_CONFIG_UNAVAILABLE,
    INTERNAL_SSL_CONFIG_SSLREF_AND_TRUSTSTORE_CODEFINED,
    INTERNAL_SSL_CONTEXT_UNAVAILABLE,
    INTERNAL_SSL_FACTORY_UNAVAILABLE,
    INTERNAL_SSL_HELPER_UNAVAILABLE,
    INTERNAL_SSL_PROVIDER_UNAVALABLE,
    INTERNAL_SSL_TLS_12_UNAVAILABLE,
    INTERNAL_SSL_SSLEXCEPTION_MISSING_CONFIG,
    INTERNAL_SSL_SSLEXCEPTION,
    INTERNAL_SSL_EXCEPTION_SSLConfigurationNotAvailableException,
    UNKNOWN;


    public String createMessage() {
        String retVal = "";
        switch (this) {
            case REGISTRATOR_MISSING_APIKEY: {
                retVal = TrNLS.formatMessage(MeteringErrorCode.class, "MISSING_ATTRIBUTE_CWWKR0405E", "apiKey");
                break;
            }
            case REGISTRATOR_MISSING_URL: {
                retVal = TrNLS.formatMessage(MeteringErrorCode.class, "MISSING_ATTRIBUTE_CWWKR0405E", "url");
                break;
            }
            case REGISTRATOR_INVALID_URL: {
                retVal = TrNLS.formatMessage(MeteringErrorCode.class, "REGISTRATOR_INVALID_URL_CWWKR0414E", "url");
                break;
            }
            case REGISTRATOR_URL_PROTOCOL_NOT_HTTPS: {
                retVal = TrNLS.formatMessage(MeteringErrorCode.class, "REGISTRATOR_URL_PROTOCOL_NOT_HTTPS_CWWKR0415E", new Object[0]);
                break;
            }
            case INTERNAL_SSL_SSLEXCEPTION_MISSING_CONFIG: {
                retVal = TrNLS.formatMessage(MeteringErrorCode.class, "REGISTRATION_ERROR_CWWKR0420E", "IBM Cloud Private Metering");
                break;
            }
            case REGISTRATOR_INVALID_PROXY_URL: {
                retVal = TrNLS.formatMessage(MeteringErrorCode.class, "REGISTRATOR_INVALID_URL_CWWKR0414E", "proxyUrl");
                break;
            }
            case INTERNAL_CONFIG_SERVICE_EXCEPTION: {
                retVal = "A problem occured while loading the ConfigService";
                break;
            }
            case INTERNAL_REGISTRATOR_MISSING_PATH: {
                retVal = "path is null";
                break;
            }
            case INTERNAL_SSL_FACTORY_UNAVAILABLE: {
                retVal = "SSLSocketFactory could not be acquired";
                break;
            }
            case INTERNAL_SSL_HELPER_UNAVAILABLE: {
                retVal = "SSLHelper could not be acquired";
                break;
            }
            case INTERNAL_SSL_PROVIDER_UNAVALABLE: {
                retVal = "SSLProvider could not be acquired";
                break;
            }
            case INTERNAL_SSL_TLS_12_UNAVAILABLE: {
                retVal = "Unable to find a Provider with a SSLContext Service supporting TLSv1.2";
                break;
            }
            case INTERNAL_SSL_SSLEXCEPTION: {
                retVal = "SSLException has been raised";
                break;
            }
            case INTERNAL_SSL_EXCEPTION_SSLConfigurationNotAvailableException: {
                retVal = "SSLConfigurationNotAvailableException has been raised";
                break;
            }
            default: {
                retVal = super.toString();
            }
        }
        return retVal;
    }
}

