/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.usage.metering.common.AdminUIURLInfo;
import com.ibm.ws.usage.metering.common.ServerEnvironmentUtil;
import com.ibm.wsspi.kernel.feature.LibertyFeature;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.usage.metering.RegistrationListener;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RuntimeUpdateListener.class}, configurationPid={"com.ibm.ws.http"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class AdminUIURLInfoImpl
implements AdminUIURLInfo,
RuntimeUpdateListener {
    private static final TraceComponent tc = Tr.register(AdminUIURLInfoImpl.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static final String DEFAULT_HTTP_ENDPOINT_ID = "defaultHttpEndpoint";
    private static final String ENPOINT_FPID_ALIAS = "httpEndpoint";
    private static final String DEFAULT_HOSTNAME = "_defaultHostName";
    private static final String LOCALHOST = "localhost";
    private static final String WILDCARD = "*";
    protected static final String ADMIN_CENTER = "adminCenter";
    private String resolvedHost;
    private int httpsPort;
    private boolean isAdminCenterEnabled;
    private boolean featuresUpdated;
    private boolean adminFeatureChanged;
    private ServiceRegistration<AdminUIURLInfo> serviceReg;
    private RegistrationListener registrationListener;
    static final long serialVersionUID = 4536658063907650275L;

    @Activate
    protected synchronized void activate(ComponentContext ctx, Map<String, Object> config) {
        String httpEndpointId = (String)config.get("id");
        if (DEFAULT_HTTP_ENDPOINT_ID.equals(httpEndpointId)) {
            this.serviceReg = ctx.getBundleContext().registerService(AdminUIURLInfo.class, (Object)this, new Hashtable<String, Object>(config));
            this.modified(config);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The AdminUIURLInfoImpl service has been registered.", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AdminCenter has not been detected. The AdminUIURLInfoImpl service has NOT been registered.", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Modified
    protected synchronized void modified(Map<String, Object> config) {
        String host = (String)config.get("host");
        String cfgDefaultHost = (String)config.get(DEFAULT_HOSTNAME);
        if (host == null || cfgDefaultHost == null) {
            return;
        }
        boolean updateRegistration = false;
        try {
            int newHttpsPort;
            String newResolvedHost = ServerEnvironmentUtil.getServerIP();
            if (newResolvedHost == null) {
                newResolvedHost = WILDCARD.equals(host) ? LOCALHOST : host;
            }
            if (this.resolvedHost == null || !this.resolvedHost.equals(newResolvedHost)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New host found: " + newResolvedHost + ". Trigger registration update is true."), (Object[])new Object[0]);
                }
                this.resolvedHost = newResolvedHost;
                updateRegistration = true;
            }
            if (this.httpsPort != (newHttpsPort = MetatypeUtils.parseInteger((Object)ENPOINT_FPID_ALIAS, (String)"httpsPort", (Object)config.get("httpsPort"), (int)-1))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New port found: " + newHttpsPort + ". Trigger registration update is true."), (Object[])new Object[0]);
                }
                this.httpsPort = newHttpsPort;
                updateRegistration = true;
            }
            if (this.registrationListener != null && updateRegistration && (this.featuresUpdated || !this.adminFeatureChanged)) {
                this.registrationListener.updateRegistration();
            }
        }
        catch (Exception newResolvedHost) {
            FFDCFilter.processException((Throwable)newResolvedHost, (String)"com.ibm.ws.usage.metering.liberty.AdminUIURLInfoImpl", (String)"137", (Object)this, (Object[])new Object[]{config});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"AdminUIURLInfoImpl encountered an exception when resolving the adminCenter url. The following exception was thrown: ", (Object[])new Object[]{e});
            }
            this.resolvedHost = null;
            this.httpsPort = -1;
        }
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext ctx, int reason) {
        this.resolvedHost = null;
        this.httpsPort = -1;
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
        }
    }

    @Override
    public synchronized String getAdminUIURL() {
        this.featuresUpdated = false;
        this.adminFeatureChanged = false;
        if (this.isAdminCenterEnabled && this.resolvedHost != null && this.httpsPort != -1) {
            return "https://" + this.resolvedHost + ":" + this.httpsPort + "/" + ADMIN_CENTER;
        }
        return null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected synchronized void setRegistrationListener(RegistrationListener listener) {
        this.registrationListener = listener;
    }

    protected synchronized void unsetRegistrationListener(RegistrationListener listener) {
        this.registrationListener = null;
    }

    @Trivial
    @Reference(name="features", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setLibertyFeature(ServiceReference<LibertyFeature> feature) {
        String featureName = (String)feature.getProperty("ibm.featureName");
        if (featureName != null) {
            if (featureName.startsWith(ADMIN_CENTER)) {
                this.isAdminCenterEnabled = true;
                this.adminFeatureChanged = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setLibertyFeature: " + featureName + " (enabling adminCenter for registration)"), (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setLibertyFeature: " + featureName), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLibertyFeature: null name : " + feature), (Object[])new Object[0]);
        }
    }

    @Trivial
    protected synchronized void unsetLibertyFeature(ServiceReference<LibertyFeature> feature) {
        String featureName = (String)feature.getProperty("ibm.featureName");
        if (featureName != null) {
            if (featureName.startsWith(ADMIN_CENTER)) {
                this.isAdminCenterEnabled = false;
                this.adminFeatureChanged = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("unsetLibertyFeature: " + featureName + " (removing adminCenter from registration)"), (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unsetLibertyFeature: " + featureName), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetLibertyFeature: null name : " + feature), (Object[])new Object[0]);
        }
    }

    public synchronized void notificationCreated(RuntimeUpdateManager manager, RuntimeUpdateNotification notification) {
        if (notification.getName() == "FeatureBundlesProcessed") {
            this.featuresUpdated = true;
            if (this.adminFeatureChanged && this.serviceReg != null && this.registrationListener != null) {
                this.registrationListener.updateRegistration();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updateRegistration skipped : " + this.adminFeatureChanged + ", " + this.serviceReg + ", " + this.registrationListener), (Object[])new Object[0]);
            }
        }
    }
}

