/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.liberty;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.extension.IFixUtils;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.Problem;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.ProductExtensionImpl;
import com.ibm.ws.usage.metering.liberty.LibertyUsageImpl;
import com.ibm.wsspi.kernel.feature.LibertyFeature;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.usage.metering.ProductExtension;
import com.ibm.wsspi.usage.metering.Usage;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ProductExtension.class, RuntimeUpdateListener.class}, immediate=false, property={"service.vendor=IBM", "ibm.persistent.id=a841fc2c9dbe4da3b2509f12083b5f5e,055f049e2f884d1786f0a1cb6821ba1c,f6cc0cd5c6b846a7b33538f2ae21a8ba,e0ebc48e003b47dc829bcdc8efed4fb0,762ac8ef540b4babb7ad8783ceb6dc2e,fbf6a96d49214c0abc6a3bc5da6e48cd,3e5b4c633588442ba04a89370ebc9832,ef7a21c852c84057b793225e72816438"})
public class LibertyProductExtension
extends ProductExtensionImpl
implements RuntimeUpdateListener {
    private static final com.ibm.ejs.ras.TraceComponent tc = Tr.register(LibertyProductExtension.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    protected static final String USAGE_METERING = "usageMetering";
    private final AtomicReference<VariableRegistry> _var;
    private MeteringMetadata data;
    private boolean featuresChanged;
    private boolean meteringFeatureChanged;
    private boolean adminFeatureChanged;
    private final Set<String> features;
    private Set<String> iFixSet;
    static final long serialVersionUID = 8344856235888485863L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public LibertyProductExtension() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this._var = new AtomicReference();
        this.features = new TreeSet<String>();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Set<String> getApars() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getApars", (Object)new Object[0]);
        }
        String installDirectory = this._var.get().resolveString("${wlp.install.dir}");
        if (this.iFixSet == null) {
            HashSet<String> allFixes = new HashSet<String>();
            Set ifixInfoSet = IFixUtils.getInstalledIFixes((File)new File(installDirectory), (CommandConsole)new EmptyConsole());
            for (IFixInfo info : ifixInfoSet) {
                for (Problem p : info.getResolves().getProblems()) {
                    allFixes.add(p.getDisplayId());
                }
            }
            this.iFixSet = Collections.unmodifiableSet(allFixes);
        }
        Set<String> set = this.iFixSet;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            set = set;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getApars", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Map<String, Object> getProductSpecificData() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getProductSpecificData", (Object)new Object[0]);
        }
        HashMap<String, Object> productSpecificData = new HashMap<String, Object>();
        productSpecificData.put("Runtime", "Liberty");
        productSpecificData.put("Features", new TreeSet<String>(this.features));
        this.featuresChanged = false;
        this.meteringFeatureChanged = false;
        this.adminFeatureChanged = false;
        HashMap<String, Object> hashMap = productSpecificData;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashMap = hashMap;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getProductSpecificData", hashMap);
        }
        return hashMap;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @Reference(name="features", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLibertyFeature(ServiceReference<LibertyFeature> feature) {
        String featureName = (String)feature.getProperty("ibm.featureName");
        if (featureName != null) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("setLibertyFeature: adding " + featureName));
            }
            this.features.add(featureName);
            if (featureName.startsWith(USAGE_METERING)) {
                this.meteringFeatureChanged = true;
            } else if (featureName.startsWith("adminCenter")) {
                this.adminFeatureChanged = true;
            }
            this.featuresChanged = true;
        } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("setLibertyFeature: null name : " + feature));
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void unsetLibertyFeature(ServiceReference<LibertyFeature> feature) {
        String featureName = (String)feature.getProperty("ibm.featureName");
        if (featureName != null) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("unsetLibertyFeature: removing " + featureName));
            }
            this.features.remove(featureName);
            if (featureName.startsWith(USAGE_METERING)) {
                this.meteringFeatureChanged = true;
            } else if (featureName.startsWith("adminCenter")) {
                this.adminFeatureChanged = true;
            }
            this.featuresChanged = true;
        } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("unsetLibertyFeature: null name : " + feature));
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @Reference(name="variableRegistry")
    protected void setVariableRegistry(VariableRegistry variableRegisry) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"setVariableRegistry", (Object)new Object[]{variableRegisry});
        }
        this._var.set(variableRegisry);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"setVariableRegistry");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void unsetVariableRegistry(VariableRegistry variableRegisry) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetVariableRegistry", (Object)new Object[]{variableRegisry});
        }
        this._var.set(null);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetVariableRegistry");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @Reference
    protected void setMeteringInfo(MeteringMetadata data) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"setMeteringInfo", (Object)new Object[]{data});
        }
        this.data = data;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"setMeteringInfo");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void unsetMeteringInfo(MeteringMetadata data) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetMeteringInfo", (Object)new Object[]{data});
        }
        this.data = null;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetMeteringInfo");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected Usage createUsage() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"createUsage", (Object)new Object[0]);
        }
        LibertyUsageImpl libertyUsageImpl = new LibertyUsageImpl(this.optionalMetrics);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            libertyUsageImpl = libertyUsageImpl;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"createUsage", (Object)libertyUsageImpl);
        }
        return libertyUsageImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected MeteringMetadata getMeteringMetadata() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getMeteringMetadata", (Object)new Object[0]);
        }
        MeteringMetadata meteringMetadata = this.data;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            meteringMetadata = meteringMetadata;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getMeteringMetadata", (Object)meteringMetadata);
        }
        return meteringMetadata;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void notificationCreated(RuntimeUpdateManager manager, RuntimeUpdateNotification notification) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"notificationCreated", (Object)new Object[]{manager, notification});
        }
        if (notification.getName() == "FeatureBundlesProcessed") {
            if (this.featuresChanged && !this.meteringFeatureChanged && !this.adminFeatureChanged) {
                this.updateRegistration();
            } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("updateRegistration skipped : " + this.featuresChanged + ", " + this.meteringFeatureChanged + ", " + this.adminFeatureChanged));
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"notificationCreated");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class EmptyConsole
    implements CommandConsole {
        static final long serialVersionUID = -1253046365392310256L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public boolean isInputStreamAvailable() {
            return false;
        }

        public String readMaskedText(String prompt) {
            return null;
        }

        public String readText(String prompt) {
            return null;
        }

        public void printInfoMessage(String message) {
        }

        public void printlnInfoMessage(String message) {
        }

        public void printErrorMessage(String errorMessage) {
        }

        public void printlnErrorMessage(String errorMessage) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register(EmptyConsole.class, (String)LibertyProductExtension.USAGE_METERING, (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
        }
    }
}

