/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.liberty;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.usage.metering.common.UsageImpl;
import com.ibm.ws.usage.metering.common.exceptions.MeteringException;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class LibertyUsageImpl
extends UsageImpl {
    private static final String CLASS_NAME = LibertyUsageImpl.class.getName();
    private static final TraceComponent tc = Tr.register(LibertyUsageImpl.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static volatile ObjectName SERVLET_QUERY = null;
    static final long serialVersionUID = -8030752376267598745L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected LibertyUsageImpl(String optionalMetrics) {
        super(optionalMetrics);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{optionalMetrics});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected Long getServletRequestTotal() throws MeteringException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServletRequestTotal");
        }
        Set<ObjectInstance> servletBeans = UsageImpl.SERVER_MBEAN.queryMBeans(SERVLET_QUERY, null);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Servlet MBeans found: " + servletBeans.size()));
        }
        Long total = null;
        try {
            if (servletBeans != null && servletBeans.size() > 0) {
                total = 0L;
                for (ObjectInstance oi : servletBeans) {
                    Object o = UsageImpl.SERVER_MBEAN.getAttribute(oi.getObjectName(), "RequestCount");
                    if (o == null || !(o instanceof Long)) continue;
                    total = total + (Long)o;
                }
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.usage.metering.liberty.LibertyUsageImpl", (String)"72", (Object)this, (Object[])new Object[0]);
            MeteringException ex = new MeteringException("Failure obtaining RequestCount from Servlet MBeans.", (Throwable)e);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getServletRequestTotal: " + ex));
            }
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getServletRequestTotal: " + total));
        }
        return total;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    static {
        try {
            SERVLET_QUERY = new ObjectName("WebSphere:type=ServletStats,name=*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            void e;
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.usage.metering.liberty.LibertyUsageImpl", (String)"46", null, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".<cinit>"), (String)"72");
        }
    }
}

