/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.liberty;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigurationNotAvailableException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.usage.metering.common.AdminUIURLInfo;
import com.ibm.ws.usage.metering.common.LogHelper;
import com.ibm.ws.usage.metering.common.MeteringConstants;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.ServerEnvironmentUtil;
import com.ibm.ws.usage.metering.common.exceptions.MeteringErrorCode;
import com.ibm.ws.usage.metering.common.exceptions.SSLConfigException;
import com.ibm.ws.usage.metering.common.exceptions.ValidationException;
import com.ibm.ws.usage.metering.liberty.LibertyLogHelper;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import com.ibm.wsspi.ssl.SSLConfiguration;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={}, configurationPid={"com.ibm.ws.usage.metering"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class MeteringMetadataImpl
extends MeteringMetadata {
    private static final String CLASS_NAME = MeteringMetadataImpl.class.getName();
    private static final TraceComponent _tc = Tr.register(MeteringMetadataImpl.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private static final String SSL_ALLOW_ALL_HOSTNAMES_PROPERTY = "com.ibm.ws.usage.metering.clientSSL.allow.all.hostnames";
    private static final boolean SSL_ALLOW_ALL_HOSTNAMES;
    ServiceRegistration<MeteringMetadata> registration;
    private final AtomicReference<VariableRegistry> _var = new AtomicReference();
    private final AtomicReference<WsLocationAdmin> _locAdmin = new AtomicReference();
    private SSLSupport _sslSupport = null;
    private SSLConfiguration _sslCfg = null;
    private String _sslAlias = null;
    private SSLConnectionSocketFactory ssl;
    private String installDirectory;
    private String instanceIdentifier;
    private AdminUIURLInfo adminUIURLInfo;
    private static final LogHelper logHelper;
    static final long serialVersionUID = 827025945825982239L;

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(ComponentContext ctx, Map<String, Object> config) {
        this.setConfig(config);
        ServerEnvironmentUtil.updateServerHostName(this.getVar("${env.CONTAINER_HOST}"), this.getVar("${env.VCAP_APPLICATION}"), this.getVar("${defaultHostName}"));
        try {
            this.validate();
            this.registration = ctx.getBundleContext().registerService(MeteringMetadata.class, (Object)this, new Hashtable<String, Object>(config));
            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"The MeteringMetadataImpl service has been registered.", (Object[])new Object[0]);
            }
        }
        catch (ValidationException validationException) {
            void ve;
            FFDCFilter.processException((Throwable)validationException, (String)"com.ibm.ws.usage.metering.liberty.MeteringMetadataImpl", (String)"117", (Object)this, (Object[])new Object[]{ctx, config});
            Tr.error((TraceComponent)_tc, (String)"REGISTRATION_FATAL_ERROR_CWWKR0403E", (Object[])new Object[]{"IBM Cloud Private Metering", ve.getMessage()});
            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Configuration Validation failed. The MeteringMetadaImpl service will not register.", (Object[])new Object[0]);
            }
            this.setValid(false);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.closeHttpClient();
    }

    @Reference(name="variableRegistry")
    protected void setVariableRegistry(VariableRegistry variableRegisry) {
        this._var.set(variableRegisry);
    }

    protected void unsetVariableRegistry(VariableRegistry variableRegisry) {
        this._var.set(null);
    }

    @Reference(name="locationAdmin")
    protected void setLocationAdmin(WsLocationAdmin locAdmin) {
        this._locAdmin.set(locAdmin);
    }

    protected void unsetLocationAdmin(WsLocationAdmin locAdmin) {
        this._locAdmin.set(null);
    }

    @Reference(name="ssl", target="(id=unbound)")
    protected void setSSL(SSLConfiguration ref) {
        this._sslCfg = ref;
        this._sslAlias = this._sslCfg.getAlias();
        this.ssl = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"SSLConfiguration reference has been received.", (Object[])new Object[]{"_sslCfg", this._sslCfg, "_sslAlias", this._sslAlias});
        }
    }

    protected void unsetSSL(SSLConfiguration ref) {
        this._sslCfg = null;
        this._sslAlias = null;
        this.ssl = null;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"SSLConfiguration reference has been removed.", (Object[])new Object[]{ref});
        }
    }

    @Reference(service=SSLSupport.class)
    protected void setSSLSupport(SSLSupport ref) {
        this._sslSupport = ref;
        this.ssl = null;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"SSLSupport reference has been received.", (Object[])new Object[]{"_sslSupport", this._sslSupport});
        }
    }

    protected void unsetSSLSupport(SSLSupport ref) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"SSLSupport reference has been removed.", (Object[])new Object[]{ref});
        }
        this._sslSupport = null;
        this.ssl = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected synchronized void setAdminUIURLInfo(AdminUIURLInfo info) {
        this.adminUIURLInfo = info;
    }

    protected synchronized void unsetAdminUIURLInfo(AdminUIURLInfo info) {
        this.adminUIURLInfo = null;
    }

    @Override
    public synchronized String getInstanceIdentifier() {
        VariableRegistry vars;
        if (!(this.instanceIdentifier != null && this.isValid() || (vars = this._var.get()) == null)) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getServerName());
            builder.append('@');
            String userDir = vars.resolveString("${wlp.user.dir}");
            if (!userDir.startsWith("/")) {
                userDir = "/" + userDir;
            }
            builder.append(userDir);
            this.instanceIdentifier = builder.toString();
        }
        return this.instanceIdentifier;
    }

    @Override
    public synchronized String getInstallDirectory() {
        VariableRegistry vars;
        if (!(this.installDirectory != null && this.isValid() || (vars = this._var.get()) == null)) {
            this.installDirectory = vars.resolveString("${wlp.install.dir}");
            if (!this.installDirectory.startsWith("/")) {
                this.installDirectory = "/" + this.installDirectory;
            }
        }
        return this.installDirectory;
    }

    /*
     * WARNING - void declaration
     */
    public String getServerName() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        String serverName = this.getVar("${env.VCAP_APPLICATION}");
        if ("${env.VCAP_APPLICATION}".equals(serverName)) {
            serverName = this.getDockerContainerIdFromFilesystem();
        } else {
            try {
                JSONObject vcap = JSONObject.parse((String)serverName);
                serverName = (String)vcap.get((Object)"application_id");
                if (serverName != null) {
                    String index = this.getVar("${env.INSTANCE_INDEX}");
                    if ("${env.INSTANCE_INDEX}".equals(index)) {
                        index = this.getVar("${env.CF_INSTANCE_INDEX}");
                        if ("${env.CF_INSTANCE_INDEX}".equals(index)) {
                            if (isTraceOn && _tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Detected Cloudfoundary and found an applciaton id, but failed to find an instance index.", (Object[])new Object[0]);
                            }
                            Tr.error((TraceComponent)_tc, (String)"NONUNIQUE_SERVER_ID_CWWKR0440E", (Object[])new Object[0]);
                        } else {
                            serverName = serverName + "_" + index;
                        }
                    } else {
                        serverName = serverName + "_" + index;
                    }
                }
            }
            catch (IOException vcap) {
                void e;
                FFDCFilter.processException((Throwable)vcap, (String)"com.ibm.ws.usage.metering.liberty.MeteringMetadataImpl", (String)"275", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getServerName"), (String)"274", (Object)this);
                if (isTraceOn && _tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Failed to parse VCAP_APPLICATION into a JSONObject. A unigue cloud foundary instance id cannot be determined. Exception was: " + e.getMessage()), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)_tc, (String)"NONUNIQUE_SERVER_ID_CWWKR0440E", (Object[])new Object[0]);
            }
        }
        if (serverName == null) {
            serverName = this.getVar("${wlp.server.name}");
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Using server name: " + serverName), (Object[])new Object[0]);
        }
        return serverName;
    }

    @ManualTrace
    public String getVar(String varName) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && _tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("getVar: " + varName), (Object[])new Object[0]);
        }
        String value = null;
        VariableRegistry vars = this._var.get();
        if (vars != null) {
            value = vars.resolveString(varName);
        }
        if (isTraceOn && _tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("getVar: " + value));
        }
        return value;
    }

    @Override
    public synchronized String getAdminUIURL() {
        if (this.adminUIURLInfo != null) {
            return this.adminUIURLInfo.getAdminUIURL();
        }
        return null;
    }

    @Override
    public HttpClientBuilder setSSLConnectionSocketFactory(HttpClientBuilder httpClientBuilder) throws SSLConfigException {
        JSSEHelper jsseHelper = this._sslSupport.getJSSEHelper();
        String sslAlias = this._sslAlias;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"SSL Configuration:", (Object[])new Object[]{"sslSupport", this._sslSupport, "sslConfig", this._sslCfg, "sslAlias", sslAlias});
        }
        if (jsseHelper == null || !jsseHelper.doesSSLConfigExist(sslAlias)) {
            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("The JSSEHelper has reported that SSL Config for " + this._sslAlias + " does not yet exist."), (Object[])new Object[0]);
            }
            throw new SSLConfigException(MeteringErrorCode.INTERNAL_SSL_CONFIG_UNAVAILABLE);
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("The JSSEHelper has reported that SSL Config for " + this._sslAlias + " does exist."), (Object[])new Object[0]);
        }
        if (this.ssl == null || !this.isValid()) {
            Object factory = null;
            try {
                SSLContext sslCtx = jsseHelper.getSSLContext(sslAlias, new HashMap(), null, false);
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("sslCtx (sslAlias: " + sslAlias + ")"), (Object[])new Object[]{sslCtx});
                }
                if (sslCtx == null) {
                    throw new SSLConfigException(MeteringErrorCode.INTERNAL_SSL_CONTEXT_UNAVAILABLE).setSslConfigName(sslAlias);
                }
                httpClientBuilder = SSL_ALLOW_ALL_HOSTNAMES ? httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslCtx, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER)) : httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslCtx));
            }
            catch (SSLConfigurationNotAvailableException sslCtx) {
                FFDCFilter.processException((Throwable)sslCtx, (String)"com.ibm.ws.usage.metering.liberty.MeteringMetadataImpl", (String)"363", (Object)this, (Object[])new Object[]{httpClientBuilder});
                throw new SSLConfigException(MeteringErrorCode.INTERNAL_SSL_EXCEPTION_SSLConfigurationNotAvailableException).setSslConfigName(sslAlias);
            }
            catch (SSLException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.usage.metering.liberty.MeteringMetadataImpl", (String)"365", (Object)this, (Object[])new Object[]{httpClientBuilder});
                throw new SSLConfigException(MeteringErrorCode.INTERNAL_SSL_SSLEXCEPTION).setSslConfigName(sslAlias);
            }
            this.ssl = factory;
        }
        return httpClientBuilder;
    }

    @Override
    public long getStartTimeNano() {
        return TimestampUtils.getStartTimeNano();
    }

    @Override
    @Sensitive
    protected String getAPIKey() {
        String apiKey = null;
        SerializableProtectedString protectedAPIKey = (SerializableProtectedString)this.getProperty(MeteringConstants.Property.API_KEY);
        if (protectedAPIKey != null) {
            apiKey = new String(protectedAPIKey.getChars());
        }
        return this.decode(apiKey);
    }

    @Override
    @Sensitive
    protected String getProxyPassword() {
        String password = null;
        SerializableProtectedString proxyPassword = (SerializableProtectedString)this.getProperty(MeteringConstants.Property.PROXY_PASSWORD);
        if (proxyPassword != null) {
            password = new String(proxyPassword.getChars());
        }
        return this.decode(password);
    }

    @Override
    public String getOptionalMetricConfiguration() {
        return (String)this.getProperty(MeteringConstants.Property.OPTIONAL_METRICS);
    }

    @Override
    protected String getTrustStorePassword() {
        return null;
    }

    @Override
    protected boolean isZOSSR() {
        return false;
    }

    @Override
    public LogHelper getLogHelper() {
        return logHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        String sslAllowAllHostsProp = System.getProperty(SSL_ALLOW_ALL_HOSTNAMES_PROPERTY);
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)SSL_ALLOW_ALL_HOSTNAMES_PROPERTY, (Object[])new Object[]{sslAllowAllHostsProp});
        }
        SSL_ALLOW_ALL_HOSTNAMES = sslAllowAllHostsProp == null || sslAllowAllHostsProp.equals("true");
        logHelper = new LibertyLogHelper();
    }
}

