/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.usage.metering.common.InstalledProductInfo;
import com.ibm.ws.usage.metering.common.MeteringMetadata;
import com.ibm.ws.usage.metering.common.MeteringTask;
import com.ibm.ws.usage.metering.common.Product;
import com.ibm.ws.usage.metering.common.RegistrationHelper;
import com.ibm.ws.usage.metering.common.Tag;
import com.ibm.ws.usage.metering.common.TaskScheduler;
import com.ibm.ws.usage.metering.common.exceptions.MeteringException;
import com.ibm.ws.usage.metering.liberty.LibertyInstalledProductInfo;
import com.ibm.ws.usage.metering.liberty.TaskFuture;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import com.ibm.wsspi.usage.metering.MeteringContext;
import com.ibm.wsspi.usage.metering.ProductExtension;
import com.ibm.wsspi.usage.metering.RegistrationListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, service={ServerQuiesceListener.class, RegistrationListener.class}, property={"service.vendor=IBM"})
public class MeteringService
implements RegistrationHelper,
ServerQuiesceListener,
RegistrationListener {
    private static final String CLASS_NAME = MeteringService.class.getName();
    private static final TraceComponent tc = Tr.register(MeteringService.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private final ConcurrentServiceReferenceMap<String, ProductExtension> extensions = new ConcurrentServiceReferenceMap("extensions");
    private TaskScheduler scheduler;
    private MeteringMetadata data;
    private MeteringTask processorTask;
    private Future<?> processorTaskFuture;
    volatile boolean isServerStarted;
    volatile boolean isServiceStarted;
    volatile boolean isActivated;
    volatile boolean isServerStopping;
    static final long serialVersionUID = 6737738744645456668L;

    @Activate
    protected void activate(ComponentContext ctx) {
        this.isActivated = true;
        this.extensions.activate(ctx);
        this.startService();
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        if (!this.isServerStopping) {
            this.cleanupTasks();
        }
        this.isActivated = false;
        this.extensions.deactivate(ctx);
    }

    @Reference
    protected synchronized void setTaskScheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected synchronized void unsetTaskScheduler(TaskScheduler scheduler) {
        this.scheduler = null;
    }

    @Reference
    protected void setMeteringInfo(MeteringMetadata data) {
        this.data = data;
    }

    protected void unsetMeteringInfo(MeteringMetadata data) {
        this.data = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected synchronized void setServerStarted(ServerStarted serverStarted) {
        this.isServerStarted = true;
        this.startService();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The Metering service has started.", (Object[])new Object[0]);
        }
    }

    protected void unsetServerStarted(ServerStarted serverStarted) {
        this.isServerStarted = false;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void startService() {
        if (this.isServiceStarted || !this.isActivated || !this.isServerStarted) {
            return;
        }
        try {
            Map productInfos = ProductInfo.getAllProductInfo();
            ArrayList<InstalledProductInfo> infos = new ArrayList<InstalledProductInfo>();
            for (ProductInfo info : productInfos.values()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ProductInfo(Name, Id, Edition, Version): " + info.getDisplayName() + ", " + info.getId() + ", " + info.getEdition() + ", " + info.getVersion()), (Object[])new Object[0]);
                }
                infos.add(new LibertyInstalledProductInfo(info, "tags"));
            }
            this.processorTask = new MeteringTask(this.data, this.scheduler, this, infos);
            this.processorTaskFuture = this.scheduler.submit(this.processorTask);
        }
        catch (ProductInfoParseException productInfos) {
            void e;
            FFDCFilter.processException((Throwable)productInfos, (String)"com.ibm.ws.usage.metering.liberty.MeteringService", (String)"146", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"BAD_PRODUCT_VERSION_FILES_CWWKR0406E", (Object[])new Object[]{e.toString()});
        }
        catch (DuplicateProductInfoException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.usage.metering.liberty.MeteringService", (String)"148", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"BAD_PRODUCT_VERSION_FILES_CWWKR0406E", (Object[])new Object[]{e.toString()});
        }
        catch (ProductInfoReplaceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.usage.metering.liberty.MeteringService", (String)"150", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"BAD_PRODUCT_VERSION_FILES_CWWKR0406E", (Object[])new Object[]{e.toString()});
        }
        this.isServiceStarted = true;
    }

    @Override
    @Trivial
    @ManualTrace
    public List<Product> createNonTagProducts(List<InstalledProductInfo> productInfos) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createNonTagProducts: " + productInfos), (Object[])new Object[0]);
        }
        for (InstalledProductInfo productInfo : productInfos) {
            if (!"com.ibm.websphere.appserver".equals(productInfo.getId())) continue;
            if ("EARLY_ACCESS".equals(productInfo.getEdition())) {
                List<Product> products = MeteringService.createBetaProducts(productInfo, this);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("createNonTagProducts: " + products.size()));
                }
                return products;
            }
            if (!"BASE_ILAN".equals(productInfo.getEdition())) continue;
            List<Product> products = MeteringService.createBaseILANProducts(productInfo, this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("createNonTagProducts: " + products.size()));
            }
            return products;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createNonTagProducts: 0; not beta or ILAN");
        }
        return Collections.emptyList();
    }

    @Override
    @Trivial
    @ManualTrace
    public Product createEmbeddedWebSphereProduct(List<InstalledProductInfo> productInfos) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createEmbeddedWebSphereProduct: " + productInfos), (Object[])new Object[0]);
        }
        for (InstalledProductInfo productInfo : productInfos) {
            if (!"com.ibm.websphere.appserver".equals(productInfo.getId())) continue;
            Tag t = new Tag();
            t.setName("WebSphere Application Server Liberty (embedded)");
            t.setVersion(productInfo.getVersion());
            t.setProductExtension(this.getProductExtension("fbf6a96d49214c0abc6a3bc5da6e48cd"));
            t.setRegistrationListener(this.getRegistrationListener());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("createEmbeddedWebSphereProduct: " + t));
            }
            return t;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createEmbeddedWebSphereProduct: null; unable to find installed product info");
        }
        return null;
    }

    @Trivial
    @ManualTrace
    private static List<Product> createBetaProducts(InstalledProductInfo productInfo, RegistrationHelper helper) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createBetaProducts: " + productInfo), (Object[])new Object[0]);
        }
        Tag t = new Tag();
        t.setName("WebSphere Application Server Liberty beta");
        t.setVersion(productInfo.getVersion());
        t.setUniqueId("ibm.com-fbf6a96d49214c0abc6a3bc5da6e48cd-" + productInfo.getVersion());
        t.setPersistentId("fbf6a96d49214c0abc6a3bc5da6e48cd-beta");
        t.setProductExtension(helper.getProductExtension("fbf6a96d49214c0abc6a3bc5da6e48cd"));
        t.setRegistrationListener(helper.getRegistrationListener());
        ArrayList<Tag> result = new ArrayList<Tag>();
        result.add(t);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createBetaProducts: " + result.size()));
        }
        return Collections.unmodifiableList(result);
    }

    @Trivial
    @ManualTrace
    private static List<Product> createBaseILANProducts(InstalledProductInfo productInfo, RegistrationHelper helper) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createBaseILANProducts: " + productInfo), (Object[])new Object[0]);
        }
        Tag t = new Tag();
        t.setName("WebSphere Application Server Liberty (ILAN)");
        t.setVersion(productInfo.getVersion());
        t.setUniqueId("ibm.com-fbf6a96d49214c0abc6a3bc5da6e48cd-" + productInfo.getVersion());
        t.setPersistentId("fbf6a96d49214c0abc6a3bc5da6e48cd-ILAN");
        t.setProductExtension(helper.getProductExtension("fbf6a96d49214c0abc6a3bc5da6e48cd"));
        t.setRegistrationListener(helper.getRegistrationListener());
        ArrayList<Tag> result = new ArrayList<Tag>();
        result.add(t);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createBaseILANProducts: " + result.size()));
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="extensions", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setExtension(ServiceReference<ProductExtension> ref) {
        String persistentIdProperty = (String)ref.getProperty("ibm.persistent.id");
        if (persistentIdProperty != null) {
            String[] persistentIds = persistentIdProperty.split(",");
            ConcurrentServiceReferenceMap<String, ProductExtension> concurrentServiceReferenceMap = this.extensions;
            synchronized (concurrentServiceReferenceMap) {
                for (String persistentId : persistentIds) {
                    ServiceReference existing = this.extensions.getReference((Object)persistentId);
                    if (existing == null || ref.compareTo((Object)existing) > 0) {
                        this.extensions.putReference((Object)persistentId, ref);
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(persistentId + " has reference with higher service ranking : " + existing), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetExtension(ServiceReference<ProductExtension> ref) {
        ConcurrentServiceReferenceMap<String, ProductExtension> concurrentServiceReferenceMap = this.extensions;
        synchronized (concurrentServiceReferenceMap) {
            Iterator references = this.extensions.references().iterator();
            while (references.hasNext()) {
                if (!((ServiceReference)references.next()).equals(ref)) continue;
                references.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProductExtension getProductExtension(String persistentId) {
        ConcurrentServiceReferenceMap<String, ProductExtension> concurrentServiceReferenceMap = this.extensions;
        synchronized (concurrentServiceReferenceMap) {
            return (ProductExtension)this.extensions.getService((Object)persistentId);
        }
    }

    public synchronized void serverStopping() {
        this.isServerStopping = true;
        this.cleanupTasks();
    }

    @Override
    @Trivial
    @ManualTrace
    public MeteringContext getMeteringContext() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMeteringContext", (Object[])new Object[0]);
        }
        MeteringContext context = this.data.getMeteringContext();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getMeteringContext : " + context));
        }
        return context;
    }

    @Override
    @Trivial
    @ManualTrace
    public synchronized void updateRegistration() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateRegistration", (Object[])new Object[0]);
        }
        if (!this.isServiceStarted || this.processorTaskFuture == null || !this.processorTaskFuture.isDone()) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateRegistration : initial registration has not been submitted; update ignored");
            }
            return;
        }
        if (this.isServerStopping || this.processorTaskFuture.isCancelled()) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateRegistration : metering service or server is stopping; update ignored");
            }
            return;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"updateRegistration : initial registration previously submitted; updating registration", (Object[])new Object[0]);
        }
        this.processorTask.reregister();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateRegistration");
        }
    }

    @Override
    public RegistrationListener getRegistrationListener() {
        return this;
    }

    protected void cleanupTasks() {
        this.scheduler.shuttingDown();
        if (this.processorTaskFuture != null) {
            if (!this.processorTaskFuture.isDone()) {
                this.processorTaskFuture.cancel(true);
            } else {
                this.processorTask.submitLastUsage(true);
            }
        }
        if (this.processorTask != null) {
            this.processorTask.cleanupTasks();
        }
        this.shutdownTaskScheduler();
    }

    private void shutdownTaskScheduler() {
        List<?> scheduledTasks = this.scheduler.shutdownTaskScheduler();
        if (scheduledTasks != null && !scheduledTasks.isEmpty()) {
            for (TaskFuture tf : scheduledTasks) {
                MeteringException ex = new MeteringException("During the deactivation of the usageMetering feature, task " + tf.getType() + " was not properly stopped or cancelled. If the server is not already stopping, it is recommended to restart the server.");
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".run"), (String)"285");
                Tr.warning((TraceComponent)tc, (String)"SHUTDOWN_TASK_SCHEDULER_WARNING_CWWKR0437W", (Object[])new Object[]{tf.getType()});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Date of task submission " + new Date(tf.getSubmissionTime())), (Object[])new Object[0]);
            }
        }
    }
}

