/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.usage.metering.liberty;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.usage.metering.common.TaskScheduler;
import com.ibm.ws.usage.metering.liberty.TaskFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
@Component(service={TaskScheduler.class})
public class TaskSchedulerImpl
implements TaskScheduler {
    private static final TraceComponent tc = Tr.register(TaskSchedulerImpl.class, (String)"usageMetering", (String)"com.ibm.ws.usage.metering.common.resources.MeteringMessages");
    private final AtomicReference<ScheduledExecutorService> _executorService;
    private volatile List<TaskFuture> tasks;
    private boolean blockTasks;
    private boolean shuttingDown;
    static final long serialVersionUID = -4645601042573632259L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public TaskSchedulerImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this._executorService = new AtomicReference();
        this.blockTasks = false;
        this.shuttingDown = false;
        this.tasks = Collections.synchronizedList(new ArrayList());
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @Reference(name="executorService")
    protected void setExecutorService(ScheduledExecutorService executorService) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setExecutorService", (Object)new Object[]{executorService});
        }
        this._executorService.set(executorService);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setExecutorService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void unsetExecutorService(ScheduledExecutorService executorService) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetExecutorService", (Object)new Object[]{executorService});
        }
        this._executorService.set(null);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetExecutorService");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Future<?> submit(Runnable r) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"submit", (Object)new Object[]{r});
        }
        if (this.blockTasks) {
            Future<?> future = null;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                future = future;
                Tr.exit((TraceComponent)tc, (String)"submit", future);
            }
            return future;
        }
        ExecutorService exec = this._executorService.get();
        Future<?> future = exec.submit(r);
        this.tasks.add(new TaskFuture(future, r.getClass().getSimpleName(), System.currentTimeMillis()));
        Future<?> future2 = future;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            future2 = future2;
            Tr.exit((TraceComponent)tc, (String)"submit", future2);
        }
        return future2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public ScheduledFuture<?> schedule(Runnable r, long delay, TimeUnit unit) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"schedule", (Object)new Object[]{r, delay, unit});
        }
        if (this.blockTasks) {
            ScheduledFuture<?> scheduledFuture = null;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                scheduledFuture = scheduledFuture;
                Tr.exit((TraceComponent)tc, (String)"schedule", scheduledFuture);
            }
            return scheduledFuture;
        }
        this.removeFinishedTasks();
        ScheduledFuture<?> future = this._executorService.get().schedule(r, delay, unit);
        this.tasks.add(new TaskFuture(future, r.getClass().getSimpleName(), System.currentTimeMillis()));
        ScheduledFuture<?> scheduledFuture = future;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            scheduledFuture = scheduledFuture;
            Tr.exit((TraceComponent)tc, (String)"schedule", scheduledFuture);
        }
        return scheduledFuture;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks) throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invokeAll", (Object)new Object[]{tasks});
        }
        List<Future<T>> list = this._executorService.get().invokeAll(tasks);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            list = list;
            Tr.exit((TraceComponent)tc, (String)"invokeAll", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invokeAll", (Object)new Object[]{tasks, timeout, unit});
        }
        List<Future<T>> list = this._executorService.get().invokeAll(tasks, timeout, unit);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            list = list;
            Tr.exit((TraceComponent)tc, (String)"invokeAll", list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public List<TaskFuture> shutdownTaskScheduler() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdownTaskScheduler", (Object)new Object[0]);
        }
        this.blockTasks = true;
        List<TaskFuture> list = this.tasks;
        synchronized (list) {
            for (TaskFuture tf : this.tasks) {
                if (tf.getFuture().isDone()) continue;
                tf.getFuture().cancel(true);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Canceled task: " + tf.getType()));
            }
        }
        this.removeFinishedTasks();
        List<TaskFuture> list2 = this.tasks;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            list2 = list2;
            Tr.exit((TraceComponent)tc, (String)"shutdownTaskScheduler", list2);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void removeFinishedTasks() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeFinishedTasks", (Object)new Object[0]);
        }
        ArrayList<TaskFuture> finishedTasks = new ArrayList<TaskFuture>();
        List<TaskFuture> list = this.tasks;
        synchronized (list) {
            for (TaskFuture tf : this.tasks) {
                if (!tf.getFuture().isDone()) continue;
                finishedTasks.add(tf);
            }
        }
        this.tasks.removeAll(finishedTasks);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of running or scheduledd tasks: " + this.tasks.size()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeFinishedTasks");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void shuttingDown() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shuttingDown", (Object)new Object[0]);
        }
        this.shuttingDown = true;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shuttingDown");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean isShuttingDown() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isShuttingDown", (Object)new Object[0]);
        }
        boolean bl = this.shuttingDown;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((TraceComponent)tc, (String)"isShuttingDown", (Object)bl);
        }
        return bl;
    }
}

