/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.servlet.request.HttpServletRequestProxy;
import com.ibm.websphere.servlet.response.HttpServletResponseProxy;
import com.ibm.websphere.servlet.response.StoredResponse;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletRequestWrapper;
import com.ibm.wsspi.webcontainer.servlet.IServletResponseWrapper;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;

public class ServletUtil {
    protected static Logger logger = Logger.getLogger("com.ibm.wsspi.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.ServletUtil";
    protected static TraceNLS nls = TraceNLS.getTraceNLS(ServletUtil.class, (String)"com.ibm.ws.webcontainer.resources.Messages");

    public static IExtendedRequest unwrapRequest(ServletRequest req) {
        return ServletUtil.unwrapRequest(req, IExtendedRequest.class);
    }

    public static <T extends ServletRequest, V extends ServletRequest> T unwrapRequest(V req, Class<T> requestClass) {
        return ServletUtil.unwrapRequest(req, requestClass, false);
    }

    public static <T extends ServletRequest, V extends ServletRequest> T unwrapRequest(V req, Class<T> requestClass, boolean logWarning) {
        Object r = req;
        while (!requestClass.isInstance(r)) {
            if (logWarning && logger.isLoggable(Level.WARNING)) {
                logger.logp(Level.WARNING, CLASS_NAME, "unwrapRequest", MessageFormat.format(nls.getString("servletrequestwrapper.is.not.an.instance.of.so.wrapped.logic.may.be.bypassed", "ServletRequestWrapper [{0}] is not an instance of [{1}] so wrapped logic may be bypassed."), r, requestClass));
            }
            if (r instanceof ServletRequestWrapper) {
                r = ((ServletRequestWrapper)r).getRequest();
                continue;
            }
            if (r instanceof HttpServletRequestProxy) {
                r = ((HttpServletRequestProxy)r).getRequest();
                continue;
            }
            if (r instanceof IServletRequestWrapper) {
                r = ((IServletRequestWrapper)r).getWrappedRequest();
                continue;
            }
            throw new RuntimeException("SRV.8.2: RequestWrapper objects must extend ServletRequestWrapper or HttpServletRequestWrapper");
        }
        return (T)r;
    }

    public static ServletResponse unwrapResponse(ServletResponse res) {
        return ServletUtil.unwrapResponse(res, Response.class);
    }

    public static ServletResponse unwrapResponse(ServletResponse res, Class className) {
        ServletResponse r = res;
        boolean gotCurrentThreadsIExtendedResponse = false;
        while (!className.isInstance(r)) {
            WebContainerRequestState reqState;
            if (r instanceof ServletResponseWrapper) {
                r = ((ServletResponseWrapper)r).getResponse();
                continue;
            }
            if (r instanceof HttpServletResponseProxy) {
                r = ((HttpServletResponseProxy)r).getResponse();
                continue;
            }
            if (r instanceof IServletResponseWrapper) {
                r = ((IServletResponseWrapper)r).getWrappedResponse();
                continue;
            }
            if (!gotCurrentThreadsIExtendedResponse && (reqState = WebContainerRequestState.getInstance(false)) != null) {
                r = reqState.getCurrentThreadsIExtendedResponse();
                gotCurrentThreadsIExtendedResponse = true;
                continue;
            }
            throw new RuntimeException("SRV.8.2: ResponseWrapper objects must extend either ServletResponseWrapper or HttpServletResponseWrapper");
        }
        return r;
    }

    public static ServletResponse unwrapResponseKeepGoing(ServletResponse res, Class className) {
        ServletResponse r = res;
        ServletResponse deepestResponse = null;
        while (r != null) {
            if (className.isInstance(r)) {
                deepestResponse = r;
            }
            if (r instanceof ServletResponseWrapper) {
                r = ((ServletResponseWrapper)r).getResponse();
                continue;
            }
            if (r instanceof HttpServletResponseProxy) {
                r = ((HttpServletResponseProxy)r).getResponse();
                continue;
            }
            if (r instanceof IServletResponseWrapper) {
                r = ((IServletResponseWrapper)r).getWrappedResponse();
                continue;
            }
            return deepestResponse;
        }
        return deepestResponse;
    }

    public static void main(String[] args) {
        StoredResponse storedResponse = new StoredResponse(new StoredResponse(null, true), true);
        ServletUtil.unwrapResponseKeepGoing(storedResponse, IExtendedResponse.class);
    }
}

