/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.tm.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.common.impl.WSATParticipantState;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.WebClient;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ParticipantResource
implements XAResource {
    private static final String CLASS_NAME = ParticipantResource.class.getName();
    private static final TraceComponent TC = Tr.register(ParticipantResource.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private WSATParticipant participant;
    private long timeoutMillis;
    private long defaultTimeout;
    static final long serialVersionUID = -6275350799451982374L;

    public ParticipantResource(WSATParticipant participant) {
        this.timeoutMillis = this.defaultTimeout = AccessController.doPrivileged(new PrivilegedAction<Long>(){
            static final long serialVersionUID = 4155717537802185215L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Long run() {
                return Long.parseLong(System.getProperty("com.ibm.ws.wsat.asyncResponseTimeout", "30000"));
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.tm.impl.ParticipantResource$1", 1.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
            }
        }).longValue();
        this.participant = participant;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int vote;
        block6: {
            vote = 3;
            WebClient webClient = WebClient.getWebClient(this.participant, this.participant.getCoordinator());
            try {
                this.participant.setState(WSATParticipantState.PREPARE);
                webClient.prepare();
                WSATParticipantState state = this.participant.waitResponse(this.timeoutMillis, WSATParticipantState.PREPARED, WSATParticipantState.READONLY, WSATParticipantState.ABORTED);
                if (state == WSATParticipantState.PREPARED) {
                    vote = 0;
                    break block6;
                }
                if (state == WSATParticipantState.READONLY) {
                    vote = 3;
                    break block6;
                }
                if (state == WSATParticipantState.ABORTED) {
                    throw new XAException(104);
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)"Unexpected response state: {0}", (Object[])new Object[]{state});
                }
                throw new XAException(106);
            }
            catch (WSATException state) {
                FFDCFilter.processException((Throwable)state, (String)"com.ibm.ws.wsat.tm.impl.ParticipantResource", (String)"78", (Object)this, (Object[])new Object[]{xid});
                throw new XAException(100);
            }
        }
        return vote;
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        WebClient webClient = WebClient.getWebClient(this.participant, this.participant.getCoordinator());
        try {
            this.participant.setState(WSATParticipantState.COMMIT);
            webClient.commit();
            WSATParticipantState state = this.participant.waitResponse(this.timeoutMillis, WSATParticipantState.COMMITTED);
            if (state != WSATParticipantState.COMMITTED) {
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)"Unexpected response state: {0}", (Object[])new Object[]{state});
                }
                throw new XAException(106);
            }
        }
        catch (WSATException state) {
            FFDCFilter.processException((Throwable)state, (String)"com.ibm.ws.wsat.tm.impl.ParticipantResource", (String)"112", (Object)this, (Object[])new Object[]{xid, onePhase});
            throw new XAException(100);
        }
        finally {
            this.participant.remove();
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        WebClient webClient = WebClient.getWebClient(this.participant, this.participant.getCoordinator());
        try {
            this.participant.setState(WSATParticipantState.ROLLBACK);
            webClient.rollback();
            WSATParticipantState state = this.participant.waitResponse(this.timeoutMillis, WSATParticipantState.ABORTED);
            if (state != WSATParticipantState.ABORTED) {
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)"Unexpected response state: {0}", (Object[])new Object[]{state});
                }
                throw new XAException(106);
            }
        }
        catch (WSATException state) {
            FFDCFilter.processException((Throwable)state, (String)"com.ibm.ws.wsat.tm.impl.ParticipantResource", (String)"137", (Object)this, (Object[])new Object[]{xid});
            throw new XAException(100);
        }
        finally {
            this.participant.remove();
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        throw new XAException("Recovery not implemented");
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
    }

    @Override
    public boolean isSameRM(XAResource arg0) throws XAException {
        return arg0 instanceof ParticipantResource;
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeoutMillis = timeout == 0 ? this.defaultTimeout : (long)(timeout * 1000);
        return true;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return (int)(this.timeoutMillis / 1000L);
    }
}

