/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.wsoc.cdi.ServiceManager;
import com.ibm.ws.wsoc.injection.InjectionProvider;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class InjectionImpl
implements InjectionProvider {
    private static final TraceComponent tc = Tr.register(InjectionImpl.class, (String)"websockets", null);
    static final long serialVersionUID = 1766312754945739748L;

    /*
     * WARNING - void declaration
     */
    public <T> T getManagedEndpointInstance(Class<T> endpointClass, ConcurrentHashMap map) throws InstantiationException {
        BeanManager manager = ServiceManager.getCurrentBeanManager();
        if (manager != null) {
            block15: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Bean Manager is not null. Assuming CDI is enabled.  Bean Manager: " + manager), (Object[])new Object[0]);
                }
                try {
                    Set set = manager.getBeans(endpointClass, new Annotation[0]);
                    if (set != null) {
                        Bean bean = null;
                        if (set.size() == 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Unable to resolve any Web Beans of type: " + endpointClass), (Object[])new Object[0]);
                            }
                        } else if (set.size() > 1) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("More than one bean available for type: " + endpointClass), (Object[])new Object[0]);
                            }
                        } else {
                            bean = (Bean)set.iterator().next();
                        }
                        if (bean != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("got bean of: " + bean), (Object[])new Object[0]);
                            }
                            CreationalContext c = manager.createCreationalContext((Contextual)bean);
                            Object ep = manager.getReference(bean, endpointClass, c);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("InjectionImpl: create a context of, hc: " + c.hashCode()), (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("InjectionImpl: using a key of: " + ep), (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("InjectionImpl: using a key of, hc: " + ep.hashCode()), (Object[])new Object[0]);
                            }
                            map.put(ep, c);
                            return (T)ep;
                        }
                    }
                }
                catch (Throwable set) {
                    void t;
                    FFDCFilter.processException((Throwable)set, (String)"com.ibm.ws.wsoc.cdi.InjectionImpl", (String)"84", (Object)this, (Object[])new Object[]{endpointClass, map});
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception while trying to instantiate a bean using CDI: " + t), (Object[])new Object[0]);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"could create the bean via the CDI service.  Will create the instance withougt CDI.", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public void releaseCC(Object key, ConcurrentHashMap map) {
        CreationalContext cc = null;
        cc = (CreationalContext)map.remove(key);
        if (cc != null) {
            cc.release();
        }
    }

    public boolean activateAppContext(ComponentMetaData cmd) {
        Class<ApplicationScoped> scopeType = ApplicationScoped.class;
        ContextsService service = this.getService();
        Context ctx = this.getCurrentContext(service, scopeType);
        if (ctx != null && ctx.isActive()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"app context alreaady active", (Object[])new Object[0]);
            }
            return false;
        }
        if (service == null) {
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"app context not active, attempt activate", (Object[])new Object[0]);
        }
        service.activateContext(scopeType);
        return true;
    }

    public boolean deActivateAppContext() {
        Class<ApplicationScoped> scopeType = ApplicationScoped.class;
        ContextsService service = this.getService();
        Context ctx = this.getCurrentContext(service, scopeType);
        if (ctx != null && ctx.isActive()) {
            service.deActivateContext(scopeType);
            return true;
        }
        return false;
    }

    public void startSesContext(HttpSession httpSession) {
        Class<SessionScoped> scopeType = SessionScoped.class;
        ContextsService service = this.getService();
        if (service == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("attempt activate of session scope using httpSession: " + httpSession), (Object[])new Object[0]);
        }
        service.startContext(scopeType, (Object)httpSession);
    }

    public boolean deActivateSesContext() {
        Class<SessionScoped> scopeType = SessionScoped.class;
        ContextsService service = this.getService();
        Context ctx = this.getCurrentContext(service, scopeType);
        if (ctx != null && ctx.isActive()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attempt Deactivate of session scope", (Object[])new Object[0]);
            }
            service.deActivateContext(scopeType);
            return true;
        }
        if (ctx != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("will not deactivate session scope. ctx is:" + ctx + " ctx.isActive is: " + ctx.isActive()), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"will not deactivate session scope. ctx is null", (Object[])new Object[0]);
        }
        return false;
    }

    private ContextsService getService() {
        ContextsService service = null;
        WebBeansContext wbc = WebBeansContext.getInstance();
        if (wbc != null) {
            service = wbc.getContextsService();
        }
        if (service == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"service is null", (Object[])new Object[0]);
        }
        return service;
    }

    private Context getCurrentContext(ContextsService service, Class<? extends Annotation> scopeType) {
        Context ctx = null;
        if (service != null) {
            ctx = service.getCurrentContext(scopeType);
            if (ctx != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("service is: " + service + " ctx is: " + ctx + " ctx.isActive is: " + ctx.isActive()), (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("activateAppContext service is: " + service + " activateAppContext ctx is null"), (Object[])new Object[0]);
            }
        }
        return ctx;
    }
}

