/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.utils.ServerInfo;
import io.openliberty.microprofile.openapi20.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.validation.OASValidator;
import io.openliberty.microprofile.openapi20.validation.ValidatorUtils;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.io.info.InfoReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.servers.Server;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIUtils {
    private static final TraceComponent tc = Tr.register(OpenAPIUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = 6519573368376504549L;

    @Trivial
    public static OpenAPI createBaseOpenAPIDocument() {
        OpenAPIImpl openAPI = new OpenAPIImpl();
        openAPI.setOpenapi("3.0.3");
        openAPI.paths((Paths)new PathsImpl());
        openAPI.info(new InfoImpl().title("Generated API").version("1.0"));
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)"Created base OpenAPI document", (Object[])new Object[0]);
        }
        return openAPI;
    }

    @Trivial
    @FFDCIgnore(value={IOException.class})
    public static String getOpenAPIDocument(OpenAPI openAPIModel, Format format) {
        String oasResult;
        block3: {
            oasResult = null;
            if (openAPIModel != null) {
                try {
                    oasResult = OpenApiSerializer.serialize((OpenAPI)openAPIModel, (Format)format);
                }
                catch (IOException e) {
                    if (!LoggingUtils.isEventEnabled(tc)) break block3;
                    Tr.event((TraceComponent)tc, (String)("Failed to serialize OpenAPI document: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return oasResult;
    }

    @Trivial
    public static void validateDocument(OpenAPI document) {
        OASValidator validator = new OASValidator();
        OASValidationResult result = validator.validate(document);
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarnings = new StringBuilder();
        if (result.hasEvents()) {
            String warnings;
            result.getEvents().stream().forEach(v -> {
                String message = ValidatorUtils.formatMessage("validationMessage", v.message, v.location);
                if (v.severity == OASValidationResult.ValidationEvent.Severity.ERROR) {
                    sbError.append("\n - " + message);
                } else if (v.severity == OASValidationResult.ValidationEvent.Severity.WARNING) {
                    sbWarnings.append("\n - " + message);
                }
            });
            String errors = sbError.toString();
            if (!errors.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_ERROR", (Object[])new Object[]{errors + "\n"});
            }
            if (!(warnings = sbWarnings.toString()).isEmpty()) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_WARNING", (Object[])new Object[]{warnings + "\n"});
            }
        }
    }

    @Trivial
    public static boolean containsServersDefinition(OpenAPI openAPIModel) {
        boolean containsServers = false;
        if (openAPIModel != null && openAPIModel.getServers() != null && openAPIModel.getServers().size() > 0) {
            containsServers = true;
        }
        return containsServers;
    }

    public static List<Server> getOpenAPIModelServers(ServerInfo serverInfo, String applicationPath) {
        String port;
        ArrayList<Server> servers = new ArrayList<Server>();
        int httpPort = serverInfo.getHttpPort();
        int httpsPort = serverInfo.getHttpsPort();
        String host = serverInfo.getHost();
        if (httpPort > 0) {
            port = httpPort == 80 ? "" : ":" + httpPort;
            String url = "http://" + host + port;
            if (applicationPath != null) {
                url = url + applicationPath;
            }
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Adding OpenAPI model server: " + url), (Object[])new Object[0]);
            }
            Server server = OASFactory.createServer();
            server.setUrl(url);
            servers.add(server);
        }
        if (httpsPort > 0) {
            port = httpsPort == 443 ? "" : ":" + httpsPort;
            String secureUrl = "https://" + host + port;
            if (applicationPath != null) {
                secureUrl = secureUrl + applicationPath;
            }
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Adding OpenAPI model server: " + secureUrl), (Object[])new Object[0]);
            }
            Server secureServer = OASFactory.createServer();
            secureServer.setUrl(secureUrl);
            servers.add(secureServer);
        }
        return servers;
    }

    public static boolean isDefaultOpenApiModel(OpenAPI model) {
        boolean isDefault = false;
        if (model.getOpenapi().equals("3.0.3") && model.getInfo() != null && model.getInfo().getContact() == null && model.getInfo().getDescription() == null && model.getInfo().getLicense() == null && model.getInfo().getTermsOfService() == null && model.getInfo().getTitle().equals("Generated API") && model.getInfo().getVersion().equals("1.0") && model.getPaths() != null && model.getPaths().getPathItems() == null && model.getComponents() == null && model.getExtensions() == null && model.getExternalDocs() == null && model.getSecurity() == null && model.getServers() == null && model.getTags() == null) {
            isDefault = true;
        }
        return isDefault;
    }

    private OpenAPIUtils() {
    }

    public static OpenAPI shallowCopy(OpenAPI model) {
        OpenAPI result = OASFactory.createOpenAPI();
        result.setOpenapi(model.getOpenapi());
        result.setComponents(model.getComponents());
        result.setExtensions(model.getExtensions());
        result.setExternalDocs(model.getExternalDocs());
        result.setInfo(model.getInfo());
        result.setPaths(model.getPaths());
        result.setSecurity(model.getSecurity());
        result.setServers(model.getServers());
        result.setTags(model.getTags());
        return result;
    }

    @FFDCIgnore(value={JsonProcessingException.class})
    public static Info getConfiguredInfo(Config config) {
        Optional infoJson = config.getOptionalValue("mp.openapi.extensions.liberty.merged.info", String.class);
        if (!infoJson.isPresent()) {
            return null;
        }
        try {
            JsonNode infoNode = new ObjectMapper().readTree((String)infoJson.get());
            Info info = InfoReader.readInfo((JsonNode)infoNode);
            if (info.getTitle() != null && info.getVersion() != null) {
                return info;
            }
            Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_INFO_INVALID_CWWKO1664W", (Object[])new Object[]{"mp.openapi.extensions.liberty.merged.info", infoJson.get()});
            return null;
        }
        catch (JsonProcessingException ex) {
            Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_INFO_PARSE_ERROR_CWWKO1665W", (Object[])new Object[]{"mp.openapi.extensions.liberty.merged.info", infoJson.get(), ex.toString()});
            return null;
        }
    }

    public static <T> boolean allEqual(Collection<? extends T> collection, BiPredicate<? super T, ? super T> comparator) {
        Iterator<T> i = collection.iterator();
        if (!i.hasNext()) {
            return true;
        }
        T first = i.next();
        while (i.hasNext()) {
            if (OpenAPIUtils.equals(first, i.next(), comparator)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T a, T b, BiPredicate<? super T, ? super T> comparator) {
        if (a == null) {
            return b == null;
        }
        return b == null ? false : comparator.test(a, b);
    }

    @Trivial
    public static <K, V> Map<K, V> notNull(Map<K, V> in) {
        if (in == null) {
            return Collections.emptyMap();
        }
        return in;
    }

    @Trivial
    public static <V> List<V> notNull(List<V> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        return in;
    }
}

