/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.onlog4j;

import com.ibm.bi.logging.onlog4j.FileForcedConfigurationFactory;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.BasicContextSelector;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    static final String CFG_FILE_RELATIVE = "../configuration/data/logging/log4j2.xml";
    private final String LOGS_FOLDER_RELATIVE = "../logs";
    private static final Logger STATUSLOGGER = StatusLogger.getLogger();
    static final String LOG4J2CONFIGFILESYSPROP = "com.ibm.bi.log4j2.config";
    File log4j2Cfgfile;
    File logsFolder;

    public void start(BundleContext context) throws Exception {
        this.logit("Starting com.ibm.bi.logging4j2 bundle", new Object[0]);
        this.setLongSystemProperty("com.ibm.bi.logging.logExpiryInDays", 28L);
        this.setLongSystemProperty("com.ibm.bi.logging.sessionLogExpiryInHours", 48L);
        this.log4j2Cfgfile = this.determineLocations();
        Log4jContextFactory contextFactory = new Log4jContextFactory((ContextSelector)new BasicContextSelector());
        LogManager.setFactory((LoggerContextFactory)contextFactory);
        FileForcedConfigurationFactory ocf = new FileForcedConfigurationFactory(this.log4j2Cfgfile);
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)ocf);
        LoggerFactory.getLogger(this.getClass()).info("started");
    }

    private void setLongSystemProperty(String propertyName, Long defaultValue) {
        Long lPropertyValue = Long.getLong(propertyName);
        if (lPropertyValue == null || lPropertyValue <= 0L) {
            lPropertyValue = defaultValue;
            this.logit("%s using default %d", propertyName, lPropertyValue);
        }
        System.setProperty(propertyName, lPropertyValue.toString());
        this.logit("set %s to %d", propertyName, lPropertyValue);
    }

    File determineLocations() throws Exception {
        String overrideConfig = System.getProperty(LOG4J2CONFIGFILESYSPROP);
        if (!StringUtils.isEmpty((String)overrideConfig)) {
            this.log4j2Cfgfile = new File(overrideConfig);
            this.logit("using override log4j2 config file %s", this.log4j2Cfgfile.getCanonicalPath());
            return this.log4j2Cfgfile;
        }
        return this.determineDefaultLocations();
    }

    File determineDefaultLocations() throws Exception {
        String installDir = System.getProperty("wlp.install.dir");
        this.logit("detected install dir as %s", installDir);
        this.log4j2Cfgfile = new File(installDir, CFG_FILE_RELATIVE);
        this.logit("using log4j2 config file %s", this.log4j2Cfgfile.getCanonicalPath());
        this.logsFolder = new File(installDir, "../logs");
        this.logit("logs folder is %s", this.logsFolder.getCanonicalPath());
        System.setProperty("com.ibm.bi.logging.logdir", this.logsFolder.getCanonicalPath());
        return this.log4j2Cfgfile;
    }

    public void stop(BundleContext context) throws Exception {
        this.logit("Stopping com.ibm.bi.logging4j2 bundle", new Object[0]);
    }

    private void logit(String fmt, Object ... args) {
        String logging = this.getClass().getName() + " " + String.format(fmt, args);
        System.out.println(logging);
        STATUSLOGGER.info(logging);
    }
}

