/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.onlog4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.status.StatusLogger;

public class FileForcedConfigurationFactory
extends ConfigurationFactory {
    private File configFile;
    private static final Logger STATUSLOGGER = StatusLogger.getLogger();

    public FileForcedConfigurationFactory(File configFile) {
        this.configFile = configFile;
    }

    protected String[] getSupportedTypes() {
        return new String[]{"*"};
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        if (!this.isActive()) {
            return null;
        }
        return this.makeConfiguration(this.configFile, loggerContext);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        if (!this.isActive()) {
            return null;
        }
        return this.makeConfiguration(this.configFile, loggerContext);
    }

    private Configuration makeConfiguration(File configFile, LoggerContext loggerContext) {
        XmlConfiguration config = null;
        try (FileInputStream is = new FileInputStream(configFile);){
            config = new XmlConfiguration(loggerContext, new ConfigurationSource((InputStream)is, configFile));
        }
        catch (FileNotFoundException e) {
            STATUSLOGGER.error("Configuration File {} not found: {}", (Object)configFile, (Object)e.getMessage());
        }
        catch (IOException e) {
            STATUSLOGGER.error("Configuration File {} IO exception: {}", (Object)configFile, (Object)e.getMessage());
        }
        return config;
    }
}

