/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.onlog4j.plugin;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="CADynamicSessionFilter", category="Core", elementType="filter", printObject=true)
public final class CADynamicSessionFilter
extends AbstractFilter {
    private static final String PREFIX = "session.";
    private Level justLogitThreshold = Level.ERROR;
    private final String contextKey;
    private final ContextDataInjector injector = ContextDataInjectorFactory.createInjector();
    private Map<String, String> sessionLoggerNameMap = new ConcurrentHashMap<String, String>();

    @PluginFactory
    public static CADynamicSessionFilter createFilter(@PluginAttribute(value="contextKey") String key, @PluginAttribute(value="justLogitThreshold") Level justLogitThreshold) {
        return new CADynamicSessionFilter(key, justLogitThreshold);
    }

    private CADynamicSessionFilter(String key, Level justLogitThresholdLevel) {
        super(Filter.Result.ACCEPT, Filter.Result.NEUTRAL);
        Objects.requireNonNull(key, "contextKey cannot be null");
        this.contextKey = key;
        this.justLogitThreshold = justLogitThresholdLevel;
    }

    private Filter.Result filter(Level level, String loggerName) {
        if (loggerName == null || loggerName.startsWith(PREFIX)) {
            return Filter.Result.NEUTRAL;
        }
        ReadOnlyStringMap contextMap = this.currentContextData();
        if (!contextMap.containsKey(this.contextKey)) {
            return Filter.Result.NEUTRAL;
        }
        if (level.isMoreSpecificThan(this.justLogitThreshold)) {
            return Filter.Result.ACCEPT;
        }
        if (LogManager.getLogger((String)this.getSessionLoggerName(loggerName)).isEnabled(level)) {
            return Filter.Result.ACCEPT;
        }
        return Filter.Result.DENY;
    }

    private String getSessionLoggerName(String loggerName) {
        String sln = this.sessionLoggerNameMap.get(loggerName);
        if (sln == null) {
            sln = PREFIX + loggerName;
            this.sessionLoggerNameMap.put(loggerName, sln);
        }
        return sln;
    }

    public Filter.Result filter(LogEvent event) {
        return this.filter(event.getLevel(), event.getLoggerName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.filter(level, logger.getName());
    }

    private ReadOnlyStringMap currentContextData() {
        return this.injector.rawContextData();
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.filter(level, logger.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CADynamicSessionFilter other = (CADynamicSessionFilter)((Object)obj);
        if (this.justLogitThreshold == null ? other.justLogitThreshold != null : !this.justLogitThreshold.equals((Object)other.justLogitThreshold)) {
            return false;
        }
        return !(this.contextKey == null ? other.contextKey != null : !this.contextKey.equals(other.contextKey));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.justLogitThreshold == null ? 0 : this.justLogitThreshold.hashCode());
        result = 31 * result + (this.contextKey == null ? 0 : this.contextKey.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("contextKey=").append(this.contextKey);
        sb.append(", justLogitThreshold=").append(this.justLogitThreshold);
        return sb.toString();
    }
}

