/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.onlog4j.plugin;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;

@Plugin(name="CAJsonLayout", category="core", elementType="layout", printObject=true)
public final class CAJsonLayout
extends AbstractStringLayout {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private SimpleDateFormat ISO_DATETIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String[] fields = new String[]{"rootId", "parentId", "currentId", "logSESSIONID", "sessionId", "serviceName", "requestName", "clientAddress", "clientPort", "hostName", "userName", "processId"};
    private final JsonFactory jsonFactory = new JsonFactory();

    protected CAJsonLayout(Charset charset) {
        super(charset);
    }

    public String toSerializable(LogEvent event) {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonGenerator g = this.jsonFactory.createGenerator((Writer)stringWriter);
            g.writeStartObject();
            this.writeBasicFields(event, g);
            this.writeMDCFields(event, g);
            this.writeThrowableEvents(event, g);
            g.writeEndObject();
            g.flush();
            g.close();
            stringWriter.append("\n");
            return stringWriter.toString();
        }
        catch (IOException e) {
            LOGGER.error("Could not write event as JSON", (Throwable)e);
            return null;
        }
    }

    private void writeBasicFields(LogEvent event, JsonGenerator g) throws IOException {
        g.writeStringField("loggerName", event.getLoggerName());
        g.writeStringField("logLevel", event.getLevel().toString());
        g.writeStringField("timeStamp", this.ISO_DATETIME.format(event.getTimeMillis()));
        g.writeStringField("threadId", event.getThreadName());
        g.writeStringField("logMessage", event.getMessage().getFormattedMessage());
    }

    private void writeThrowableEvents(LogEvent event, JsonGenerator g) throws IOException {
        Throwable thrown = event.getThrown();
        if (thrown == null) {
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        String throwableString = sw.toString();
        if (throwableString.isEmpty()) {
            return;
        }
        g.writeStringField("throwable", throwableString);
    }

    private void writeMDCFields(LogEvent event, JsonGenerator g) throws IOException {
        for (String f : fields) {
            g.writeStringField(f, (String)event.getContextData().getValue(f));
        }
    }

    @PluginFactory
    public static CAJsonLayout createLayout(@PluginAttribute(value="charset") String charset) {
        Charset c = UTF8;
        if (charset != null) {
            if (Charset.isSupported(charset)) {
                c = Charset.forName(charset);
            } else {
                LOGGER.error("Charset " + charset + " is not supported for layout, using " + c.displayName());
            }
        }
        return new CAJsonLayout(c);
    }
}

