/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.onlog4j.plugin;

import com.ibm.bi.logging.onlog4j.plugin.DumpUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="CAOnDemandDumpFilter", category="Core", elementType="filter", printObject=true)
public final class CAOnDemandDumpFilter
extends AbstractFilter {
    private AtomicBoolean dumpEnabled = new AtomicBoolean(false);
    private final Properties prop = new Properties();
    private final Timer timer = new Timer();
    private final DumpUtil dumpUtil;
    private String sessionId;
    private String expectedClassname = null;
    private AtomicInteger numberDump = new AtomicInteger(1);
    private AtomicLong lastModified = new AtomicLong(0L);
    private AtomicInteger linenumber = new AtomicInteger(0);
    private Pattern messageMatchPattern = null;

    @PluginFactory
    public static CAOnDemandDumpFilter createFilter(@PluginAttribute(value="rulefile") String rulefile) {
        return new CAOnDemandDumpFilter(rulefile);
    }

    private CAOnDemandDumpFilter(String rulefile) {
        super(Filter.Result.ACCEPT, Filter.Result.NEUTRAL);
        long interval = Long.getLong("dump.rule.time.interval", 60000L);
        final File ruleFile = new File(System.getProperty("install.dir", ".") + File.separator + rulefile);
        if (ruleFile.exists()) {
            try {
                this.prop.load(new FileInputStream(ruleFile));
                this.updateAttributes();
                this.lastModified.set(ruleFile.lastModified());
                System.out.println("CAOnDemandDumpFilter rule file " + ruleFile.getCanonicalPath() + " is loaded \n" + this.prop);
                this.timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        if (CAOnDemandDumpFilter.this.lastModified.get() < ruleFile.lastModified()) {
                            CAOnDemandDumpFilter.this.lastModified.set(ruleFile.lastModified());
                            CAOnDemandDumpFilter.this.prop.clear();
                            try {
                                CAOnDemandDumpFilter.this.prop.load(new FileInputStream(ruleFile));
                                CAOnDemandDumpFilter.this.updateAttributes();
                                System.out.println("CAOnDemandDumpFilter rule file " + ruleFile.getCanonicalPath() + " is reloaded \n" + CAOnDemandDumpFilter.this.prop);
                            }
                            catch (IOException e) {
                                System.err.println("Failed to read rules");
                            }
                        }
                    }
                }, 0L, interval);
                System.out.println("CAOnDemandDumpFilter rule file monitor is running.");
            }
            catch (IOException e) {
                System.err.println("Failed to read rule file " + ruleFile.getAbsolutePath());
            }
        } else {
            System.err.println("Can not read rule file " + ruleFile.getAbsolutePath());
        }
        this.dumpUtil = new DumpUtil(this.prop);
    }

    private void updateAttributes() {
        this.dumpEnabled.set(Boolean.parseBoolean(this.prop.getProperty("dump.enabled", "false")));
        this.numberDump.set(Integer.parseInt(this.prop.getProperty("dump.count", "1")));
        this.setSessionId(this.prop.getProperty("session.id"));
        this.setMatchPattern(this.prop.getProperty("match_pattern"));
        this.setExpectedClassname(this.prop.getProperty("expected.classname"));
        this.linenumber.set(Integer.parseInt(this.prop.getProperty("line.number", "0")));
    }

    public Filter.Result filter(LogEvent event) {
        if (this.dumpEnabled.get() && this.numberDump.get() > 0) {
            this.checkDumpRules(event);
        }
        return Filter.Result.ACCEPT;
    }

    private void checkDumpRules(LogEvent event) {
        if (this.hasSessionId() && !this.sessionIdMatched(event)) {
            return;
        }
        if (this.hasMessagePattern() && !this.logMessageMatched(event)) {
            return;
        }
        if (this.hasClassAndLineNumber() && !this.classNameAndLineMatched(event)) {
            return;
        }
        this.numberDump.decrementAndGet();
        this.dumpUtil.threadDump();
    }

    private boolean hasSessionId() {
        return StringUtils.isNotBlank((String)this.sessionId);
    }

    private boolean sessionIdMatched(LogEvent event) {
        return this.sessionId.equalsIgnoreCase(this.getSessionId(event));
    }

    private boolean hasMessagePattern() {
        return this.messageMatchPattern != null;
    }

    private boolean logMessageMatched(LogEvent event) {
        return this.messageMatchPattern.matcher(event.getMessage().getFormattedMessage()).matches();
    }

    private boolean hasClassAndLineNumber() {
        return StringUtils.isNotBlank((String)this.getExpectedClassname()) && this.linenumber.get() > 0;
    }

    private boolean classNameAndLineMatched(LogEvent event) {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        int maxToSearch = sts.length;
        for (int i = 1; i < maxToSearch; ++i) {
            if (!sts[i].getClassName().equals(this.getExpectedClassname()) || sts[i].getLineNumber() != this.linenumber.get()) continue;
            return true;
        }
        return false;
    }

    private synchronized void setSessionId(String usersession) {
        this.sessionId = usersession != null && !usersession.isEmpty() ? usersession : null;
    }

    private synchronized void setMatchPattern(String match_pattern) {
        this.messageMatchPattern = match_pattern != null && !match_pattern.isEmpty() ? Pattern.compile(match_pattern) : null;
    }

    private synchronized String getExpectedClassname() {
        return this.expectedClassname;
    }

    private synchronized void setExpectedClassname(String expectedClassname) {
        this.expectedClassname = expectedClassname;
    }

    private String getSessionId(LogEvent event) {
        ReadOnlyStringMap map = event.getContextData();
        return map != null ? (String)map.getValue("sessionId") : null;
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.timer.cancel();
        return super.stop(timeout, timeUnit);
    }
}

