/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.onlog4j.plugin;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="CAStartupFilter", category="Core", elementType="filter", printObject=true)
public final class CAStartupFilter
extends AbstractFilter {
    private static final String PREFIX = "startup.";
    private final String sysPropName;
    private Map<String, String> startupLoggerNameMap = new ConcurrentHashMap<String, String>();
    private boolean enabled;

    @PluginFactory
    public static CAStartupFilter createFilter(@PluginAttribute(value="sysPropName") String sysPropName) {
        return new CAStartupFilter(sysPropName);
    }

    private CAStartupFilter(String _sysPropName) {
        super(Filter.Result.ACCEPT, Filter.Result.NEUTRAL);
        Objects.requireNonNull(_sysPropName, "sysPropName cannot be null");
        this.sysPropName = _sysPropName;
        this.enabled = "false".equals(System.getProperty(this.sysPropName));
    }

    private Filter.Result filter(Level level, String loggerName) {
        if (!this.enabled) {
            return Filter.Result.NEUTRAL;
        }
        if (loggerName == null || loggerName.startsWith(PREFIX)) {
            return Filter.Result.NEUTRAL;
        }
        String propValue = System.getProperty(this.sysPropName);
        if (propValue == null || "true".equals(propValue)) {
            this.enabled = false;
            return Filter.Result.NEUTRAL;
        }
        if (LogManager.getLogger((String)this.getStartupLoggerName(loggerName)).isEnabled(level)) {
            return Filter.Result.ACCEPT;
        }
        return Filter.Result.NEUTRAL;
    }

    private String getStartupLoggerName(String loggerName) {
        String sln = this.startupLoggerNameMap.get(loggerName);
        if (sln == null) {
            sln = PREFIX + loggerName;
            this.startupLoggerNameMap.put(loggerName, sln);
        }
        return sln;
    }

    public Filter.Result filter(LogEvent event) {
        return this.filter(event.getLevel(), event.getLoggerName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.filter(level, logger.getName());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.filter(level, logger.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CAStartupFilter other = (CAStartupFilter)((Object)obj);
        return !(this.sysPropName == null ? other.sysPropName != null : !this.sysPropName.equals(other.sysPropName));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.sysPropName == null ? 0 : this.sysPropName.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sysPropName=").append(this.sysPropName);
        return sb.toString();
    }
}

