/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.onlog4j.plugin;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="MetricsNoOp", category="Core", elementType="appender", printObject=true)
public class MetricsNoOpAppender
extends AbstractAppender {
    protected static final StatusLogger LOG = StatusLogger.getLogger();
    private final AtomicLong total = new AtomicLong();
    private final AtomicLong errors = new AtomicLong();

    public MetricsNoOpAppender(String name, Layout<?> layout) {
        super(name, null, layout);
    }

    public long getTotalCount() {
        return this.total.get();
    }

    public long getErrorCount() {
        return this.errors.get();
    }

    public void append(LogEvent event) {
        this.total.incrementAndGet();
        if (event.getLevel().compareTo(Level.ERROR) == 0) {
            this.errors.incrementAndGet();
            if (this.errors.get() % 200L == 0L) {
                LOG.warn(String.format("MetricsNoOpAppender - error log events %d", this.errors.get()));
            }
        }
        if (this.total.get() % 1000L == 0L) {
            LOG.warn(String.format("MetricsNoOpAppender - total logging events %d, error log events %d", this.total.get(), this.errors.get()));
        }
    }

    @PluginFactory
    public static MetricsNoOpAppender createAppender(@PluginAttribute(value="name") String name) {
        return new MetricsNoOpAppender(Objects.requireNonNull(name), null);
    }
}

